/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfECTSInSpecialSeasonEvaluation;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.student.Registration;

public class MaximumNumberOfECTSInSpecialSeasonEvaluationExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        MaximumNumberOfECTSInSpecialSeasonEvaluation rule = (MaximumNumberOfECTSInSpecialSeasonEvaluation)curricularRule;
        Registration registration = enrolmentContext.getRegistration();
        BigDecimal totalEcts = this.getTotalEcts(registration, enrolmentContext);
        if (!rule.allowEcts(totalEcts)) {
            if (enrolmentContext.isRegistrationFromResponsiblePerson()) {
                return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.EnrolmentInSpecialSeasonEvaluationExecutor.too.many.specialSeason.ects", rule.getMaxEcts().toPlainString());
            }
            return RuleResult.createWarning(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.EnrolmentInSpecialSeasonEvaluationExecutor.too.many.specialSeason.ects", rule.getMaxEcts().toPlainString());
        }
        return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private BigDecimal getTotalEcts(Registration registration, EnrolmentContext enrolmentContext) {
        BigDecimal result = BigDecimal.ZERO;
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModuleToEvaluate.getDegreeModule());
            if (!enrolmentContext.isResponsiblePersonStudent() && curricularCourse.isDissertation()) continue;
            result = result.add(BigDecimal.valueOf(degreeModuleToEvaluate.getEctsCredits()));
        }
        return result;
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }
}

