/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.postingRules.GenericSingleEntryTypePR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public abstract class GenericSingleEntryTypePR
extends GenericSingleEntryTypePR_Base {
    protected GenericSingleEntryTypePR() {
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate) {
        super.init(eventType, startDate, endDate, serviceAgreementTemplate);
        this.checkParameters(entryType);
        super.setEntryType(entryType);
    }

    private void checkParameters(EntryType entryType) {
        if (entryType == null) {
            throw new DomainException("error.accounting.postingRules.GenericSingleEntryTypePR.entryType.cannot.be.null", new String[0]);
        }
    }

    public void setEntryType(EntryType entryType) {
        throw new DomainException("error.accounting.postingRules.GenericSingleEntryTypePR.cannot.modify.entryType", new String[0]);
    }

    public void internalAddOtherPartyAmount(User responsibleUser, Event event, Account fromAcount, Account toAccount, Money amount, AccountingTransactionDetailDTO transactionDetailDTO) {
        this.makeAccountingTransaction(responsibleUser, event, fromAcount, toAccount, this.getEntryType(), amount, transactionDetailDTO);
    }

    public AccountingTransaction depositAmount(User responsibleUser, Event event, Account fromAcount, Account toAccount, Money amount, AccountingTransactionDetailDTO transactionDetailDTO) {
        this.checkEntryTypeForDeposit(event, this.getEntryType());
        return this.makeAccountingTransaction(responsibleUser, event, fromAcount, toAccount, this.getEntryType(), amount, transactionDetailDTO);
    }
}

