/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventState;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent_Base;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public abstract class GratuityEvent
extends GratuityEvent_Base {
    protected GratuityEvent() {
    }

    protected void init(AdministrativeOffice administrativeOffice, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        this.init(administrativeOffice, EventType.GRATUITY, person, studentCurricularPlan, executionYear);
    }

    protected void init(AdministrativeOffice administrativeOffice, EventType eventType, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        super.init(administrativeOffice, eventType, person, executionYear);
        this.checkParameters(administrativeOffice, studentCurricularPlan);
        super.setStudentCurricularPlan(studentCurricularPlan);
    }

    private void checkParameters(AdministrativeOffice administrativeOffice, StudentCurricularPlan studentCurricularPlan) {
        if (studentCurricularPlan == null) {
            throw new DomainException("error.accounting.events.gratuity.GratuityEvent.studentCurricularPlan.cannot.be.null", new String[0]);
        }
        if (administrativeOffice == null) {
            throw new DomainException("error.accounting.events.gratuity.GratuityEvent.administrativeOffice.cannot.be.null", new String[0]);
        }
    }

    public Account getToAccount() {
        return this.getUnit().getAccountBy(AccountType.INTERNAL);
    }

    protected Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    private Unit getUnit() {
        return this.getDegree().getUnit();
    }

    public Degree getDegree() {
        return this.getDegreeCurricularPlan().getDegree();
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" (").appendLabel(this.getDegree().getDegreeType().getName().getContent()).appendLabel(" - ").appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent()).appendLabel(" - ").appendLabel(this.getExecutionYear().getYear()).appendLabel(")");
        return labelFormatter;
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = super.getDescription();
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent()).appendLabel(" - ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent()).appendLabel(" - ");
        labelFormatter.appendLabel(this.getExecutionYear().getYear());
        return labelFormatter;
    }

    protected DegreeCurricularPlanServiceAgreementTemplate getServiceAgreementTemplate() {
        return this.getDegreeCurricularPlan().getServiceAgreementTemplate();
    }

    private DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getStudentCurricularPlan().getDegreeCurricularPlan();
    }

    public Registration getRegistration() {
        return this.getStudentCurricularPlan().getRegistration();
    }

    public boolean isCompleteEnrolmentModel() {
        return this.getRegistration().isCompleteEnrolmentModel(this.getExecutionYear());
    }

    public boolean isCustomEnrolmentModel() {
        return this.getRegistration().isCustomEnrolmentModel(this.getExecutionYear());
    }

    public double getEnrolmentsEctsForRegistration() {
        return this.getRegistration().getEnrolmentsEcts(this.getExecutionYear());
    }

    public int getNumberOfEnrolmentsForRegistration() {
        return this.getRegistration().getEnrolments(this.getExecutionYear()).size();
    }

    public boolean canRemoveExemption(DateTime when) {
        if (this.hasGratuityExemption() && this.isClosed()) {
            return this.getPayedAmount().greaterOrEqualThan(this.calculateTotalAmountToPayWithoutDiscount(when));
        }
        return true;
    }

    public boolean hasGratuityExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof GratuityExemption)) continue;
            return true;
        }
        return false;
    }

    public GratuityExemption getGratuityExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof GratuityExemption)) continue;
            return (GratuityExemption)((Object)exemption);
        }
        return null;
    }

    private Money calculateTotalAmountToPayWithoutDiscount(DateTime when) {
        return this.getPostingRule().calculateTotalAmountToPay((Event)((Object)this), when, false);
    }

    public boolean isGratuityExemptionAvailable() {
        return this.hasGratuityExemption();
    }

    public boolean isGratuityExemptionNotAvailable() {
        return !this.hasGratuityExemption();
    }

    public boolean canApplyExemption(GratuityExemptionJustificationType justificationType) {
        return true;
    }

    public BigDecimal calculateDiscountPercentage(Money amount) {
        return this.hasGratuityExemption() ? this.getGratuityExemption().calculateDiscountPercentage(amount) : BigDecimal.ZERO;
    }

    protected void disconnect() {
        super.setStudentCurricularPlan(null);
        super.disconnect();
    }

    public boolean isGratuityEventWithPaymentPlan() {
        return false;
    }

    public boolean isOpen() {
        if (this.isCancelled()) {
            return false;
        }
        return this.calculateAmountToPay(new DateTime()).greaterThan(Money.ZERO);
    }

    public boolean isClosed() {
        if (this.isCancelled()) {
            return false;
        }
        return this.calculateAmountToPay(new DateTime()).lessOrEqualThan(Money.ZERO);
    }

    public boolean isInState(EventState eventState) {
        if (eventState == EventState.OPEN) {
            return this.isOpen();
        }
        if (eventState == EventState.CLOSED) {
            return this.isClosed();
        }
        if (eventState == EventState.CANCELLED) {
            return this.isCancelled();
        }
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.gratuity.DfaGratuityEvent.unexpected.state.to.test", new String[0]);
    }

    protected void internalRecalculateState(DateTime whenRegistered) {
        if (this.canCloseEvent(whenRegistered)) {
            this.closeNonProcessedCodes();
            this.closeEvent();
        } else if (this.getCurrentEventState() != EventState.OPEN) {
            this.changeState(EventState.OPEN, new DateTime());
            this.reopenCancelledCodes();
        }
    }

    public boolean isGratuity() {
        return true;
    }

    public boolean isDfaGratuityEvent() {
        return false;
    }

    static {
        GratuityEvent.getRelationGratuityEventStudentCurricularPlan().addListener((RelationListener)new RelationAdapter<StudentCurricularPlan, GratuityEvent>(){

            public void beforeAdd(StudentCurricularPlan studentCurricularPlan, GratuityEvent gratuityEvent) {
                if (gratuityEvent != null && studentCurricularPlan != null && studentCurricularPlan.getRegistration().hasGratuityEvent(gratuityEvent.getExecutionYear(), ((Object)((Object)gratuityEvent)).getClass())) {
                    throw new DomainException("error.accounting.events.gratuity.GratuityEvent.person.already.has.gratuity.event.in.registration.and.year", new String[0]);
                }
            }
        });
    }
}

