/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.EquivalencePlan;
import org.fenixedu.academic.domain.EquivalencePlanEntry;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;

public class EquivalencePlanEntryCreator
implements FactoryExecutor,
Serializable {
    private EquivalencePlan equivalencePlan;
    private final Set<DegreeModule> originDegreeModules = new HashSet<DegreeModule>();
    private final Set<DegreeModule> destinationDegreeModules = new HashSet<DegreeModule>();
    private DegreeModule originDegreeModuleToAdd;
    private DegreeModule destinationDegreeModuleToAdd;
    private LogicOperator originLogicOperator = LogicOperator.AND;
    private LogicOperator destinationLogicOperator = LogicOperator.AND;
    private Boolean transitiveOrigin = true;
    private Double ectsCredits;
    private CourseGroup destinationDegreeModulesPreviousCourseGroup;

    public EquivalencePlanEntryCreator(EquivalencePlan equivalencePlan) {
        this.setEquivalencePlan(equivalencePlan);
    }

    @Override
    public Object execute() {
        Double ectsCredits = this.getEctsCredits() != null && this.getEctsCredits() > 0.0 ? this.getEctsCredits() : null;
        return new EquivalencePlanEntry(this.getEquivalencePlan(), this.getOriginDegreeModules(), this.getDestinationDegreeModules(), this.getDestinationDegreeModulesPreviousCourseGroup(), this.getOriginLogicOperator(), this.getDestinationLogicOperator(), this.getTransitiveOrigin(), ectsCredits);
    }

    public EquivalencePlan getEquivalencePlan() {
        return this.equivalencePlan;
    }

    public void setEquivalencePlan(EquivalencePlan equivalencePlan) {
        this.equivalencePlan = equivalencePlan;
    }

    public Set<DegreeModule> getOriginDegreeModules() {
        TreeSet<DegreeModule> degreeModules = new TreeSet<DegreeModule>(DegreeModule.COMPARATOR_BY_NAME);
        for (DegreeModule degreeModule : this.originDegreeModules) {
            degreeModules.add(degreeModule);
        }
        return degreeModules;
    }

    public Set<DegreeModule> getDestinationDegreeModules() {
        TreeSet<DegreeModule> degreeModules = new TreeSet<DegreeModule>(DegreeModule.COMPARATOR_BY_NAME);
        for (DegreeModule degreeModule : this.destinationDegreeModules) {
            degreeModules.add(degreeModule);
        }
        return degreeModules;
    }

    public DegreeModule getOriginDegreeModuleToAdd() {
        return this.originDegreeModuleToAdd;
    }

    public void setOriginDegreeModuleToAdd(DegreeModule degreeModule) {
        this.originDegreeModuleToAdd = degreeModule;
    }

    public DegreeModule getDestinationDegreeModuleToAdd() {
        return this.destinationDegreeModuleToAdd;
    }

    public void setDestinationDegreeModuleToAdd(DegreeModule degreeModule) {
        this.destinationDegreeModuleToAdd = degreeModule;
    }

    public void addOrigin(DegreeModule degreeModule) {
        if (degreeModule != null) {
            this.originDegreeModules.add(degreeModule);
        }
    }

    public void addDestination(DegreeModule degreeModule) {
        if (degreeModule != null) {
            this.destinationDegreeModules.add(degreeModule);
        }
    }

    public LogicOperator getOriginLogicOperator() {
        return this.originLogicOperator;
    }

    public void setOriginLogicOperator(LogicOperator originLogicOperator) {
        this.originLogicOperator = originLogicOperator;
    }

    public LogicOperator getDestinationLogicOperator() {
        return this.destinationLogicOperator;
    }

    public void setDestinationLogicOperator(LogicOperator destinationLogicOperator) {
        this.destinationLogicOperator = destinationLogicOperator;
    }

    public Boolean getTransitiveOrigin() {
        return this.transitiveOrigin;
    }

    public void setTransitiveOrigin(Boolean transitiveOrigin) {
        this.transitiveOrigin = transitiveOrigin;
    }

    public Double getEctsCredits() {
        return this.ectsCredits;
    }

    public void setEctsCredits(Double ectsCredits) {
        this.ectsCredits = ectsCredits;
    }

    public void setDestinationDegreeModulesPreviousCourseGroup(CourseGroup previousCourseGroup) {
        this.destinationDegreeModulesPreviousCourseGroup = previousCourseGroup;
    }

    public CourseGroup getDestinationDegreeModulesPreviousCourseGroup() {
        return this.destinationDegreeModulesPreviousCourseGroup;
    }
}

