/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.commons;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.service.services.thesis.ChangeThesisPerson;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

public abstract class AbstractManageThesisDA
extends FenixDispatchAction {
    private static final Logger logger = LoggerFactory.getLogger(AbstractManageThesisDA.class);

    public ActionForward viewOperationsThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("thesis", (Object)this.getThesis(request));
        return mapping.findForward("viewOperationsThesis");
    }

    protected Integer getId(String id) {
        if (id == null || id.equals("")) {
            return null;
        }
        try {
            return new Integer(id);
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected Thesis getThesis(HttpServletRequest request) {
        return (Thesis)((Object)this.getDomainObject(request, "thesisID"));
    }

    public ActionForward changePersonType(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisBean bean = (ThesisBean)this.getRenderedObject("bean");
        RenderUtils.invalidateViewState((String)"bean");
        if (bean == null) {
            return this.searchStudent(mapping, actionForm, request, response);
        }
        bean.setPerson(null);
        bean.setRawPersonName(null);
        bean.setUnitName(null);
        bean.setRawUnitName(null);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("select-person");
    }

    public ActionForward searchStudent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisBean bean = new ThesisBean();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("search-student");
    }

    public abstract ActionForward editProposal(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)request.getParameter("degreeCurricularPlanID"));
    }

    public ActionForward selectPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisBean bean = (ThesisBean)this.getRenderedObject("bean");
        if (bean == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        Person selectedPerson = bean.getPerson();
        if (selectedPerson == null) {
            this.addActionMessage("info", request, "thesis.selectPerson.internal.required");
            return mapping.findForward("select-person");
        }
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        Thesis thesis = this.getThesis(request);
        ChangeThesisPerson.PersonTarget personTarget = bean.getTargetType();
        if (personTarget == ChangeThesisPerson.PersonTarget.president) {
            Enrolment enrolment = thesis.getEnrolment();
            ExecutionYear executionYear = enrolment.getExecutionYear();
            if (selectedPerson == null || !degreeCurricularPlan.isScientificCommissionMember(executionYear, selectedPerson)) {
                this.addActionMessage("info", request, "thesis.selectPerson.president.required.scientific.commission");
                return mapping.findForward("select-person");
            }
        }
        if (personTarget == ChangeThesisPerson.PersonTarget.vowel) {
            for (ThesisEvaluationParticipant participant : thesis.getVowels()) {
                if (participant.getPerson() != selectedPerson) continue;
                this.addActionMessage("info", request, "thesis.selectPerson.vowel.duplicated");
                return mapping.findForward("select-person");
            }
        }
        ChangeThesisPerson.run(degreeCurricularPlan, thesis, new ChangeThesisPerson.PersonChange(bean.getTargetType(), selectedPerson, bean.getTarget()));
        return this.editProposal(mapping, actionForm, request, response);
    }

    public ActionForward selectPersonInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisBean bean = (ThesisBean)this.getRenderedObject("bean");
        if (bean == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("select-person");
    }

    public ActionForward selectExternal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisBean bean = (ThesisBean)this.getRenderedObject("bean");
        if (bean == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        Thesis thesis = this.getThesis(request);
        ChangeThesisPerson.addExternal(thesis, bean.getTargetType(), bean.getExternalName(), bean.getExternalEmail());
        return this.editProposal(mapping, actionForm, request, response);
    }

    public ActionForward selectExternalInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisBean bean = (ThesisBean)this.getRenderedObject("bean");
        if (bean == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("select-person");
    }
}

