/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.student.enrollment.bolonha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.DegreeModuleToEnrol;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentEnrollmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumEnrolmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumGroupBean;
import org.fenixedu.academic.ui.renderers.student.enrollment.bolonha.BolonhaStudentEnrollmentInputRenderer;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixWebFramework.rendererExtensions.controllers.CopyCheckBoxValuesController;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyArrayConverter;
import pt.ist.fenixWebFramework.renderers.components.HtmlActionLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlActionLinkController;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class BolonhaStudentEnrolmentLayout
extends Layout {
    private final CopyCheckBoxValuesController enrollmentsController = new CopyCheckBoxValuesController(false);
    private final CopyCheckBoxValuesController degreeModulesToEvaluateController = new CopyCheckBoxValuesController();
    private BolonhaStudentEnrollmentBean bolonhaStudentEnrollmentBean = null;
    protected boolean canPerformStudentEnrolments = false;
    private BolonhaStudentEnrollmentInputRenderer renderer;

    public CopyCheckBoxValuesController getEnrollmentsController() {
        return this.enrollmentsController;
    }

    public BolonhaStudentEnrollmentInputRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(BolonhaStudentEnrollmentInputRenderer renderer) {
        this.renderer = renderer;
    }

    public HtmlComponent createComponent(Object object, Class type) {
        this.setBolonhaStudentEnrollmentBean((BolonhaStudentEnrollmentBean)object);
        if (this.getBolonhaStudentEnrollmentBean() == null) {
            return new HtmlText();
        }
        HtmlBlockContainer container = new HtmlBlockContainer();
        HtmlMultipleHiddenField hiddenEnrollments = new HtmlMultipleHiddenField();
        hiddenEnrollments.bind(this.getRenderer().getInputContext().getMetaObject(), "curriculumModulesToRemove");
        hiddenEnrollments.setConverter((Converter)new DomainObjectKeyArrayConverter());
        hiddenEnrollments.setController((HtmlController)this.enrollmentsController);
        HtmlMultipleHiddenField hiddenDegreeModulesToEvaluate = new HtmlMultipleHiddenField();
        hiddenDegreeModulesToEvaluate.bind(this.getRenderer().getInputContext().getMetaObject(), "degreeModulesToEvaluate");
        hiddenDegreeModulesToEvaluate.setConverter(this.getBolonhaStudentEnrollmentBean().getDegreeModulesToEvaluateConverter());
        hiddenDegreeModulesToEvaluate.setController((HtmlController)this.getDegreeModulesToEvaluateController());
        container.addChild((HtmlComponent)hiddenEnrollments);
        container.addChild((HtmlComponent)hiddenDegreeModulesToEvaluate);
        this.generateGroup(container, this.getBolonhaStudentEnrollmentBean().getStudentCurricularPlan(), this.getBolonhaStudentEnrollmentBean().getRootStudentCurriculumGroupBean(), this.getBolonhaStudentEnrollmentBean().getExecutionPeriod(), 0);
        return container;
    }

    protected void generateGroup(HtmlBlockContainer blockContainer, StudentCurricularPlan studentCurricularPlan, StudentCurriculumGroupBean studentCurriculumGroupBean, ExecutionSemester executionSemester, int depth) {
        if (BolonhaStudentEnrolmentLayout.isCycleExternal(studentCurriculumGroupBean) && !this.getRenderer().isAllowedToEnrolInAffinityCycle()) {
            return;
        }
        HtmlTable groupTable = this.createGroupTable(blockContainer, depth);
        this.addGroupHeaderRow(groupTable, studentCurriculumGroupBean, executionSemester);
        if (this.canPerformStudentEnrolments || !this.groupIsConcluded(studentCurriculumGroupBean)) {
            if (this.getRenderer().isEncodeGroupRules()) {
                this.encodeCurricularRules(groupTable, studentCurriculumGroupBean.getCurriculumModule());
            }
            HtmlTable coursesTable = this.createCoursesTable(blockContainer, depth);
            this.generateEnrolments(studentCurriculumGroupBean, coursesTable);
            this.generateCurricularCoursesToEnrol(coursesTable, studentCurriculumGroupBean, executionSemester);
            this.generateGroups(blockContainer, studentCurriculumGroupBean, studentCurricularPlan, executionSemester, depth);
        }
        if (studentCurriculumGroupBean.isRoot()) {
            this.generateCycleCourseGroupsToEnrol(blockContainer, executionSemester, studentCurricularPlan, depth);
        }
    }

    private static boolean isCycleExternal(StudentCurriculumGroupBean studentCurriculumGroupBean) {
        CurriculumGroup curriculumModule = studentCurriculumGroupBean.getCurriculumModule();
        return curriculumModule.isCycleCurriculumGroup() && ((CycleCurriculumGroup)((Object)curriculumModule)).isExternal();
    }

    protected boolean groupIsConcluded(StudentCurriculumGroupBean bean) {
        return bean.getCurriculumModule().isCycleCurriculumGroup() && bean.getCurriculumModule().isConcluded();
    }

    protected void encodeCurricularRules(HtmlTable groupTable, CurriculumGroup curriculumGroup) {
        if (curriculumGroup.isNoCourseGroupCurriculumGroup()) {
            return;
        }
        Context context = this.getDegreeModuleContext(curriculumGroup, this.getBolonhaStudentEnrollmentBean().getExecutionPeriod());
        List curricularRules = curriculumGroup.getDegreeModule().getCurricularRules(context, this.getBolonhaStudentEnrollmentBean().getExecutionPeriod());
        if (!curricularRules.isEmpty()) {
            this.encodeCurricularRules(groupTable, curricularRules);
        }
    }

    protected Context getDegreeModuleContext(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester) {
        CourseGroup degreeModule = curriculumGroup.getDegreeModule();
        if (curriculumGroup.isRoot()) {
            return null;
        }
        CurriculumGroup parentCurriculumGroup = curriculumGroup.getCurriculumGroup();
        for (Context context : parentCurriculumGroup.getDegreeModule().getValidChildContexts(executionSemester)) {
            if (context.getChildDegreeModule() != degreeModule) continue;
            return context;
        }
        return null;
    }

    protected HtmlTable createGroupTable(HtmlBlockContainer blockContainer, int depth) {
        HtmlTable groupTable = new HtmlTable();
        groupTable.setClasses(this.getRenderer().getTablesClasses());
        groupTable.setStyle("width: " + (this.getRenderer().getInitialWidth() - depth) + "em; margin-left: " + depth + "em;");
        blockContainer.addChild((HtmlComponent)groupTable);
        return groupTable;
    }

    protected void addGroupHeaderRow(HtmlTable groupTable, StudentCurriculumGroupBean studentCurriculumGroupBean, ExecutionSemester executionSemester) {
        HtmlTableRow groupHeaderRow = groupTable.createRow();
        groupHeaderRow.setClasses(this.getRenderer().getGroupRowClasses());
        HtmlTableCell titleCell = groupHeaderRow.createCell();
        if (studentCurriculumGroupBean.getCurriculumModule().isRoot()) {
            if (studentCurriculumGroupBean.getCurriculumModule().getDegreeCurricularPlanOfStudent().isEmpty()) {
                titleCell.setBody((HtmlComponent)new HtmlText(studentCurriculumGroupBean.getCurriculumModule().getName().getContent()));
            } else {
                titleCell.setBody((HtmlComponent)this.createDegreeCurricularPlanLink(studentCurriculumGroupBean));
            }
        } else if (studentCurriculumGroupBean.getCurriculumModule().isCycleCurriculumGroup()) {
            this.setTitleCellInformation(groupHeaderRow, titleCell, studentCurriculumGroupBean, executionSemester);
        } else {
            titleCell.setBody((HtmlComponent)new HtmlText(this.buildCurriculumGroupLabel(studentCurriculumGroupBean.getCurriculumModule(), executionSemester), false));
        }
        HtmlTableCell checkBoxCell = groupHeaderRow.createCell();
        checkBoxCell.setClasses("aright");
        HtmlCheckBox checkBox = new HtmlCheckBox(true){

            public void setChecked(boolean checked) {
                if (this.isDisabled()) {
                    super.setChecked(true);
                } else {
                    super.setChecked(checked);
                }
            }
        };
        MetaObject enrolmentMetaObject = MetaObjectFactory.createObject((Object)((Object)studentCurriculumGroupBean.getCurriculumModule()), (Schema)new Schema(CurriculumGroup.class));
        checkBox.setName("enrolmentCheckBox" + studentCurriculumGroupBean.getCurriculumModule().getExternalId());
        checkBox.setUserValue(enrolmentMetaObject.getKey().toString());
        checkBoxCell.setBody((HtmlComponent)checkBox);
        if (this.isToDisableEnrolmentOption(studentCurriculumGroupBean)) {
            checkBox.setDisabled(true);
        } else {
            this.enrollmentsController.addCheckBox(checkBox);
        }
    }

    protected void setTitleCellInformation(HtmlTableRow groupHeaderRow, HtmlTableCell titleCell, StudentCurriculumGroupBean studentCurriculumGroupBean, ExecutionSemester executionSemester) {
        CycleCurriculumGroup group = (CycleCurriculumGroup)((Object)studentCurriculumGroupBean.getCurriculumModule());
        boolean concluded = group.isConcluded();
        titleCell.setBody((HtmlComponent)new HtmlText(this.buildCycleCurriculumGroupLabel(group, concluded, executionSemester), false));
        if (concluded) {
            groupHeaderRow.setClasses(this.getRenderer().getConcludedGroupRowClasses());
        }
    }

    protected String buildCycleCurriculumGroupLabel(CycleCurriculumGroup curriculumGroup, boolean concluded, ExecutionSemester executionSemester) {
        String label = this.buildCurriculumGroupLabel((CurriculumGroup)((Object)curriculumGroup), executionSemester);
        if (concluded) {
            label = label.concat(" - ").concat(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curriculum.cycle.concluded", (String[])new String[0]));
        }
        return label;
    }

    protected String buildCurriculumGroupLabel(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester) {
        if (curriculumGroup.isNoCourseGroupCurriculumGroup()) {
            return curriculumGroup.getName().getContent();
        }
        StringBuilder result = new StringBuilder(curriculumGroup.getName().getContent());
        if (this.getRenderer().isEncodeGroupRules()) {
            result.append(" <span title=\"");
            result.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curriculum.credits.legend.creditsConcluded", (String[])new String[0]));
            result.append(" \"> c(");
            result.append(curriculumGroup.getCreditsConcluded(executionSemester.getExecutionYear()));
            result.append(")</span>");
        } else {
            CreditsLimit creditsLimit = (CreditsLimit)((Object)curriculumGroup.getMostRecentActiveCurricularRule(CurricularRuleType.CREDITS_LIMIT, executionSemester));
            if (creditsLimit != null) {
                result.append(" <span title=\"");
                result.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curriculum.credits.legend.minCredits", (String[])new String[0]));
                result.append(" \">m(");
                result.append(creditsLimit.getMinimumCredits());
                result.append(")</span>,");
            }
            result.append(" <span title=\"");
            result.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curriculum.credits.legend.creditsConcluded", (String[])new String[0]));
            result.append(" \"> c(");
            result.append(curriculumGroup.getCreditsConcluded(executionSemester.getExecutionYear()));
            result.append(")</span>");
            if (creditsLimit != null) {
                result.append(", <span title=\"");
                result.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curriculum.credits.legend.maxCredits", (String[])new String[0]));
                result.append(" \">M(");
                result.append(creditsLimit.getMaximumCredits());
                result.append(")</span>");
            }
        }
        return result.toString();
    }

    protected HtmlLink createDegreeCurricularPlanLink(StudentCurriculumGroupBean studentCurriculumGroupBean) {
        HtmlLink degreeCurricularPlanLink = new HtmlLink();
        degreeCurricularPlanLink.setText(studentCurriculumGroupBean.getCurriculumModule().getName().getContent());
        degreeCurricularPlanLink.setModuleRelative(false);
        degreeCurricularPlanLink.setTarget("_blank");
        degreeCurricularPlanLink.setContextRelative(false);
        degreeCurricularPlanLink.setUrl(studentCurriculumGroupBean.getCurriculumModule().getStudentCurricularPlan().getDegree().getSiteUrl());
        return degreeCurricularPlanLink;
    }

    protected HtmlTable createCoursesTable(HtmlBlockContainer blockContainer, int depth) {
        HtmlTable coursesTable = new HtmlTable();
        blockContainer.addChild((HtmlComponent)coursesTable);
        coursesTable.setClasses(this.getRenderer().getTablesClasses());
        coursesTable.setStyle("width: " + (this.getRenderer().getInitialWidth() - depth - this.getRenderer().getWidthDecreasePerLevel()) + "em; margin-left: " + (depth + this.getRenderer().getWidthDecreasePerLevel()) + "em;");
        return coursesTable;
    }

    protected void generateCurricularCoursesToEnrol(HtmlTable groupTable, StudentCurriculumGroupBean studentCurriculumGroupBean, ExecutionSemester executionSemester) {
        List<IDegreeModuleToEvaluate> coursesToEvaluate = studentCurriculumGroupBean.getSortedDegreeModulesToEvaluate();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : coursesToEvaluate) {
            HtmlTableRow htmlTableRow = groupTable.createRow();
            HtmlTableCell cellName = htmlTableRow.createCell();
            cellName.setClasses(this.getRenderer().getCurricularCourseToEnrolNameClasses());
            String degreeModuleName = degreeModuleToEvaluate.getDegreeModule().getNameI18N(executionSemester).getContent();
            if (degreeModuleToEvaluate.getDegreeModule().isLeaf() && !degreeModuleToEvaluate.isOptionalCurricularCourse()) {
                CurricularCourse curricularCourse;
                GradeScale gradeScaleChain;
                if (!StringUtils.isEmpty((String)degreeModuleToEvaluate.getDegreeModule().getCode())) {
                    degreeModuleName = degreeModuleToEvaluate.getDegreeModule().getCode() + " - " + degreeModuleName;
                }
                if (this.canPerformStudentEnrolments && (gradeScaleChain = (curricularCourse = (CurricularCourse)((Object)degreeModuleToEvaluate.getDegreeModule())).getGradeScaleChain()) != GradeScale.TYPE20) {
                    degreeModuleName = degreeModuleName + " (" + BundleUtil.getString((String)"resources.StudentResources", (String)"label.grade.scale", (String[])new String[0]) + " - " + gradeScaleChain.getDescription() + ")";
                }
            }
            cellName.setBody((HtmlComponent)new HtmlText(degreeModuleName));
            HtmlTableCell yearCell = htmlTableRow.createCell();
            yearCell.setClasses(this.getRenderer().getCurricularCourseToEnrolYearClasses());
            yearCell.setColspan(Integer.valueOf(2));
            yearCell.setBody((HtmlComponent)new HtmlText(degreeModuleToEvaluate.getYearFullLabel()));
            if (!degreeModuleToEvaluate.isOptionalCurricularCourse()) {
                HtmlTableCell ectsCell = htmlTableRow.createCell();
                ectsCell.setClasses(this.getRenderer().getCurricularCourseToEnrolEctsClasses());
                StringBuilder ects = new StringBuilder();
                ects.append(degreeModuleToEvaluate.getEctsCredits()).append(" ").append(BundleUtil.getString((String)"resources.StudentResources", (String)"label.credits.abbreviation", (String[])new String[0]));
                ectsCell.setBody((HtmlComponent)new HtmlText(ects.toString()));
                HtmlTableCell checkBoxCell = htmlTableRow.createCell();
                checkBoxCell.setClasses(this.getRenderer().getCurricularCourseToEnrolCheckBoxClasses());
                HtmlCheckBox checkBox = new HtmlCheckBox(false);
                checkBox.setName("degreeModuleToEnrolCheckBox" + degreeModuleToEvaluate.getKey());
                checkBox.setUserValue(degreeModuleToEvaluate.getKey());
                checkBox.setVisible(!this.isToDisableEnrolmentOption(degreeModuleToEvaluate));
                this.getDegreeModulesToEvaluateController().addCheckBox(checkBox);
                checkBoxCell.setBody((HtmlComponent)checkBox);
            } else {
                HtmlTableCell cell = htmlTableRow.createCell();
                cell.setClasses(this.getRenderer().getCurricularCourseToEnrolEctsClasses());
                cell.setBody((HtmlComponent)new HtmlText(""));
                HtmlTableCell linkTableCell = htmlTableRow.createCell();
                linkTableCell.setClasses(this.getRenderer().getCurricularCourseToEnrolCheckBoxClasses());
                HtmlActionLink actionLink = new HtmlActionLink();
                actionLink.setText(BundleUtil.getString((String)"resources.StudentResources", (String)"label.chooseOptionalCurricularCourse", (String[])new String[0]));
                actionLink.setController((HtmlController)new OptionalCurricularCourseLinkController(degreeModuleToEvaluate));
                if (this.isToDisableEnrolmentOption(degreeModuleToEvaluate)) {
                    actionLink.setOnClick("function(){return false;}");
                    actionLink.setStyle("text-decoration: line-through; color: grey; border-bottom: none;");
                } else {
                    actionLink.setOnClick("$(this).closest('form').find('input[name=\\'method\\']').attr('value', 'prepareChooseOptionalCurricularCourseToEnrol');");
                }
                actionLink.setName("optionalCurricularCourseLink" + degreeModuleToEvaluate.getCurriculumGroup().getExternalId() + "_" + degreeModuleToEvaluate.getContext().getExternalId());
                linkTableCell.setBody((HtmlComponent)actionLink);
            }
            if (!this.getRenderer().isEncodeCurricularRules()) continue;
            this.encodeCurricularRules(groupTable, degreeModuleToEvaluate);
        }
    }

    private boolean isToDisableEnrolmentOption(StudentCurriculumGroupBean input) {
        return input.isToBeDisabled() || this.isStudentLogged() && this.appliesAnyRules(input.getCurriculumModule(), CurricularRuleType.ENROLMENT_TO_BE_APPROVED_BY_COORDINATOR);
    }

    private boolean isToDisableEnrolmentOption(IDegreeModuleToEvaluate input) {
        return this.isStudentLogged() && this.appliesAnyRules(input, CurricularRuleType.ENROLMENT_TO_BE_APPROVED_BY_COORDINATOR);
    }

    private boolean appliesAnyRules(IDegreeModuleToEvaluate input, CurricularRuleType ... curricularRuleTypes) {
        if (input != null && input.getContext() != null && curricularRuleTypes != null) {
            for (CurricularRuleType curricularRuleType : curricularRuleTypes) {
                CourseGroup parentCourseGroup = input.getCurriculumGroup().getDegreeModule();
                ExecutionSemester executionInterval = this.bolonhaStudentEnrollmentBean.getExecutionPeriod();
                List rules = input.getDegreeModule().getCurricularRules(curricularRuleType, parentCourseGroup, executionInterval);
                if (!rules.isEmpty() && rules.iterator().next().appliesToContext(input.getContext())) {
                    return true;
                }
                rules = parentCourseGroup.getCurricularRules(curricularRuleType, executionInterval);
                if (rules.isEmpty() || !((ICurricularRule)rules.iterator().next()).appliesToContext(input.getContext())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean appliesAnyRules(CurriculumGroup input, CurricularRuleType ... curricularRuleTypes) {
        if (input != null && curricularRuleTypes != null) {
            for (CurricularRuleType curricularRuleType : curricularRuleTypes) {
                CurriculumGroup parentCurriculumGroup = input.getCurriculumGroup();
                CourseGroup parentCourseGroup = parentCurriculumGroup.getDegreeModule();
                ExecutionSemester executionInterval = this.bolonhaStudentEnrollmentBean.getExecutionPeriod();
                List rules = input.getDegreeModule().getCurricularRules(curricularRuleType, parentCourseGroup, executionInterval);
                if (!rules.isEmpty()) {
                    return true;
                }
                if (parentCurriculumGroup.isRoot() || !this.appliesAnyRules(parentCurriculumGroup, curricularRuleTypes)) continue;
                return true;
            }
        }
        return false;
    }

    protected void encodeCurricularRules(HtmlTable groupTable, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        DegreeModule degreeModule = degreeModuleToEvaluate.getDegreeModule();
        List<CurricularRule> curricularRules = degreeModule.getCurricularRules(degreeModuleToEvaluate.getContext(), degreeModuleToEvaluate.getExecutionPeriod());
        if (!curricularRules.isEmpty()) {
            this.encodeCurricularRules(groupTable, curricularRules);
        }
    }

    protected void encodeCurricularRules(HtmlTable groupTable, List<CurricularRule> curricularRules) {
        HtmlTableRow htmlTableRow = groupTable.createRow();
        HtmlTable rulesTable = new HtmlTable();
        HtmlTableCell cellRules = htmlTableRow.createCell();
        cellRules.setClasses(this.getRenderer().getCurricularCourseToEnrolNameClasses());
        cellRules.setBody((HtmlComponent)rulesTable);
        cellRules.setColspan(Integer.valueOf(5));
        rulesTable.setClasses("smalltxt noborder");
        rulesTable.setStyle("width: 100%;");
        for (CurricularRule curricularRule : curricularRules) {
            HtmlTableCell cellName = rulesTable.createRow().createCell();
            cellName.setStyle("color: #888");
            cellName.setBody((HtmlComponent)new HtmlText(CurricularRuleLabelFormatter.getLabel(curricularRule, I18N.getLocale())));
        }
    }

    protected void generateEnrolments(StudentCurriculumGroupBean studentCurriculumGroupBean, HtmlTable groupTable) {
        for (StudentCurriculumEnrolmentBean studentEnrolmentBean : studentCurriculumGroupBean.getEnrolledCurriculumCourses()) {
            if (studentEnrolmentBean.getCurriculumModule().isTemporary()) {
                this.generateEnrolment(groupTable, studentEnrolmentBean.getCurriculumModule(), this.getRenderer().getTemporaryEnrolmentNameClasses(), this.getRenderer().getTemporaryEnrolmentYearClasses(), this.getRenderer().getTemporaryEnrolmentSemesterClasses(), this.getRenderer().getTemporaryEnrolmentEctsClasses(), this.getRenderer().getTemporaryEnrolmentCheckBoxClasses());
                continue;
            }
            if (studentEnrolmentBean.getCurriculumModule().isImpossible()) {
                this.generateEnrolment(groupTable, studentEnrolmentBean.getCurriculumModule(), this.getRenderer().getImpossibleEnrolmentNameClasses(), this.getRenderer().getImpossibleEnrolmentYearClasses(), this.getRenderer().getImpossibleEnrolmentSemesterClasses(), this.getRenderer().getImpossibleEnrolmentEctsClasses(), this.getRenderer().getImpossibleEnrolmentCheckBoxClasses());
                continue;
            }
            this.generateEnrolment(groupTable, studentEnrolmentBean.getCurriculumModule(), this.getRenderer().getEnrolmentNameClasses(), this.getRenderer().getEnrolmentYearClasses(), this.getRenderer().getEnrolmentSemesterClasses(), this.getRenderer().getEnrolmentEctsClasses(), this.getRenderer().getEnrolmentCheckBoxClasses());
        }
    }

    protected void generateEnrolment(HtmlTable groupTable, Enrolment enrolment, String enrolmentNameClasses, String enrolmentYearClasses, String enrolmentSemesterClasses, String enrolmentEctsClasses, String enrolmentCheckBoxClasses) {
        EnroledCurriculumModuleWrapper wrapper = new EnroledCurriculumModuleWrapper((CurriculumModule)((Object)enrolment), enrolment.getExecutionPeriod());
        HtmlTableRow htmlTableRow = groupTable.createRow();
        HtmlTableCell cellName = htmlTableRow.createCell();
        cellName.setClasses(enrolmentNameClasses);
        String enrolmentName = this.getPresentationNameFor(enrolment);
        cellName.setBody((HtmlComponent)new HtmlText(enrolmentName));
        HtmlTableCell yearCell = htmlTableRow.createCell();
        yearCell.setClasses(enrolmentYearClasses);
        String year = enrolment.getExecutionPeriod().getExecutionYear().getYear();
        yearCell.setBody((HtmlComponent)new HtmlText(year));
        HtmlTableCell semesterCell = htmlTableRow.createCell();
        semesterCell.setClasses(enrolmentSemesterClasses);
        StringBuilder semester = new StringBuilder();
        semester.append(enrolment.getExecutionPeriod().getSemester().toString());
        semester.append(" ");
        semester.append(BundleUtil.getString((String)"resources.EnumerationResources", (String)"SEMESTER.ABBREVIATION", (String[])new String[0]));
        semesterCell.setBody((HtmlComponent)new HtmlText(semester.toString()));
        HtmlTableCell ectsCell = htmlTableRow.createCell();
        ectsCell.setClasses(enrolmentEctsClasses);
        StringBuilder ects = new StringBuilder();
        double ectsCredits = enrolment.isBolonhaDegree() && this.getBolonhaStudentEnrollmentBean().getCurricularRuleLevel().isNormal() ? enrolment.getAccumulatedEctsCredits(enrolment.getExecutionPeriod()) : enrolment.getEctsCredits().doubleValue();
        ects.append(ectsCredits).append(" ").append(BundleUtil.getString((String)"resources.StudentResources", (String)"label.credits.abbreviation", (String[])new String[0]));
        ectsCell.setBody((HtmlComponent)new HtmlText(ects.toString()));
        MetaObject enrolmentMetaObject = MetaObjectFactory.createObject((Object)enrolment, (Schema)new Schema(Enrolment.class));
        HtmlCheckBox checkBox = new HtmlCheckBox(true);
        checkBox.setName("enrolmentCheckBox" + enrolment.getExternalId());
        checkBox.setUserValue(enrolmentMetaObject.getKey().toString());
        checkBox.setDisabled(this.isToDisableEnrolmentOption(wrapper));
        this.enrollmentsController.addCheckBox(checkBox);
        HtmlTableCell cellCheckBox = htmlTableRow.createCell();
        cellCheckBox.setClasses(enrolmentCheckBoxClasses);
        cellCheckBox.setBody((HtmlComponent)checkBox);
    }

    protected String getPresentationNameFor(Enrolment enrolment) {
        CurricularCourse curricularCourse;
        GradeScale gradeScaleChain;
        String result = null;
        String code = "";
        if (!StringUtils.isEmpty((String)enrolment.getCode())) {
            code = enrolment.getCode() + " - ";
        }
        if (enrolment instanceof OptionalEnrolment) {
            ExecutionSemester executionSemester = enrolment.getExecutionPeriod();
            OptionalEnrolment optionalEnrolment = (OptionalEnrolment)((Object)enrolment);
            result = optionalEnrolment.getOptionalCurricularCourse().getNameI18N(executionSemester).getContent() + " (" + code + optionalEnrolment.getCurricularCourse().getNameI18N(executionSemester).getContent() + ")";
        } else {
            result = code + enrolment.getName().getContent();
        }
        if (enrolment.getDegreeModule().isLeaf() && !enrolment.isOptional() && this.canPerformStudentEnrolments && (gradeScaleChain = (curricularCourse = (CurricularCourse)((Object)enrolment.getDegreeModule())).getGradeScaleChain()) != GradeScale.TYPE20) {
            result = result + " (" + BundleUtil.getString((String)"resources.StudentResources", (String)"label.grade.scale", (String[])new String[0]) + " - " + gradeScaleChain.getDescription() + ")";
        }
        return result;
    }

    protected void generateGroups(HtmlBlockContainer container, StudentCurriculumGroupBean bean, StudentCurricularPlan plan, ExecutionSemester executionSemester, int depth) {
        for (StudentCurriculumGroupBean studentCurriculumGroupBean : bean.getEnrolledCurriculumGroupsSortedByOrder(executionSemester)) {
            this.generateGroup(container, plan, studentCurriculumGroupBean, executionSemester, depth + this.getRenderer().getWidthDecreasePerLevel());
        }
        for (IDegreeModuleToEvaluate iDegreeModuleToEvaluate : bean.getCourseGroupsToEnrolSortedByContext()) {
            this.generateCourseGroupToEnroll(container, iDegreeModuleToEvaluate, plan, depth + this.getRenderer().getWidthDecreasePerLevel());
        }
    }

    protected void generateCourseGroupToEnroll(HtmlBlockContainer blockContainer, IDegreeModuleToEvaluate degreeModuleToEnrol, StudentCurricularPlan studentCurricularPlan, int depth) {
        CourseGroup courseGroup = (CourseGroup)((Object)degreeModuleToEnrol.getContext().getChildDegreeModule());
        if (courseGroup.isCycleCourseGroup()) {
            return;
        }
        this.generateCourseGroupToEnroll(blockContainer, degreeModuleToEnrol, depth);
    }

    protected void generateCourseGroupToEnroll(HtmlBlockContainer blockContainer, IDegreeModuleToEvaluate degreeModuleToEnrol, int depth) {
        HtmlTable groupTable = this.createGroupTable(blockContainer, depth);
        HtmlTableRow htmlTableRow = groupTable.createRow();
        htmlTableRow.setClasses(this.getRenderer().getGroupRowClasses());
        htmlTableRow.createCell().setBody((HtmlComponent)new HtmlText(degreeModuleToEnrol.getContext().getChildDegreeModule().getName()));
        HtmlTableCell cell = htmlTableRow.createCell();
        cell.setClasses("aright");
        HtmlCheckBox checkBox = new HtmlCheckBox(false);
        String name = "degreeModuleToEnrolCheckBox" + degreeModuleToEnrol.getContext().getExternalId().toString() + ":" + degreeModuleToEnrol.getCurriculumGroup().getExternalId().toString();
        checkBox.setName(name);
        checkBox.setUserValue(degreeModuleToEnrol.getKey());
        this.getDegreeModulesToEvaluateController().addCheckBox(checkBox);
        cell.setBody((HtmlComponent)checkBox);
        if (this.getRenderer().isEncodeGroupRules()) {
            this.encodeCurricularRules(groupTable, degreeModuleToEnrol);
        }
    }

    private boolean isStudentLogged() {
        return this.isStudentLogged(this.bolonhaStudentEnrollmentBean.getStudentCurricularPlan());
    }

    private boolean isStudentLogged(StudentCurricularPlan studentCurricularPlan) {
        return Authenticate.getUser().getPerson() == studentCurricularPlan.getPerson();
    }

    protected void generateCycleCourseGroupsToEnrol(HtmlBlockContainer container, ExecutionSemester executionSemester, StudentCurricularPlan studentCurricularPlan, int depth) {
        if (studentCurricularPlan.hasConcludedAnyInternalCycle() && studentCurricularPlan.getDegreeType().hasExactlyOneCycleType()) {
            return;
        }
        if (this.canPerformStudentEnrolments) {
            for (CycleType cycleType : this.getAllCycleTypesToEnrolPreviousToFirstExistingCycle(studentCurricularPlan)) {
                this.generateCourseGroupToEnroll(container, this.buildDegreeModuleToEnrolForCycle(studentCurricularPlan, cycleType, executionSemester), depth + this.getRenderer().getWidthDecreasePerLevel());
            }
        }
        if (this.getRenderer().isAllowedToChooseAffinityCycle()) {
            for (CycleType cycleType : studentCurricularPlan.getSupportedCycleTypesToEnrol()) {
                this.generateCycleCourseGroupToEnrol(container, cycleType, depth + this.getRenderer().getWidthDecreasePerLevel());
            }
        }
    }

    protected IDegreeModuleToEvaluate buildDegreeModuleToEnrolForCycle(StudentCurricularPlan scp, CycleType cycleType, ExecutionSemester semester) {
        CycleCourseGroup cycleCourseGroup = scp.getCycleCourseGroup(cycleType);
        Context context = (Context)cycleCourseGroup.getParentContextsByExecutionSemester(semester).iterator().next();
        return new DegreeModuleToEnrol((CurriculumGroup)((Object)scp.getRoot()), context, semester);
    }

    protected List<CycleType> getAllCycleTypesToEnrolPreviousToFirstExistingCycle(StudentCurricularPlan scp) {
        CycleType cycleType;
        ArrayList<CycleType> result = new ArrayList<CycleType>();
        ArrayList<CycleType> supportedCyclesToEnrol = new ArrayList<CycleType>(scp.getDegreeType().getSupportedCyclesToEnrol());
        Collections.sort(supportedCyclesToEnrol, CycleType.COMPARATOR_BY_LESS_WEIGHT);
        Iterator iterator = supportedCyclesToEnrol.iterator();
        while (iterator.hasNext() && !scp.hasCycleCurriculumGroup(cycleType = (CycleType)((Object)iterator.next()))) {
            result.add(cycleType);
        }
        return result;
    }

    protected void generateCycleCourseGroupToEnrol(HtmlBlockContainer container, CycleType cycleType, int depth) {
        HtmlTable groupTable = this.createGroupTable(container, depth);
        HtmlTableRow htmlTableRow = groupTable.createRow();
        htmlTableRow.setClasses(this.getRenderer().getGroupRowClasses());
        htmlTableRow.createCell().setBody((HtmlComponent)new HtmlText(RenderUtils.getEnumString((Enum)cycleType)));
        HtmlTableCell cell = htmlTableRow.createCell();
        cell.setClasses("aright");
        HtmlActionLink actionLink = new HtmlActionLink();
        actionLink.setText(BundleUtil.getString((String)"resources.StudentResources", (String)"label.choose", (String[])new String[0]));
        actionLink.setController((HtmlController)new CycleSelectionLinkController(cycleType));
        actionLink.setOnClick("(function (z){var node = z; while(node.tagName != 'FORM'){ node = node.parentNode; } return node;})(this).method.value='prepareChooseCycleCourseGroupToEnrol';");
        actionLink.setName("cycleLink_" + cycleType.name());
        cell.setBody((HtmlComponent)actionLink);
    }

    public CopyCheckBoxValuesController getDegreeModulesToEvaluateController() {
        return this.degreeModulesToEvaluateController;
    }

    public void setBolonhaStudentEnrollmentBean(BolonhaStudentEnrollmentBean bolonhaStudentEnrollmentBean) {
        this.bolonhaStudentEnrollmentBean = bolonhaStudentEnrollmentBean;
        this.canPerformStudentEnrolments = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, Authenticate.getUser()).collect(Collectors.toSet()).contains(bolonhaStudentEnrollmentBean.getStudentCurricularPlan().getDegree());
    }

    public BolonhaStudentEnrollmentBean getBolonhaStudentEnrollmentBean() {
        return this.bolonhaStudentEnrollmentBean;
    }

    protected static class CycleSelectionLinkController
    extends HtmlActionLinkController {
        private static final long serialVersionUID = -5469571160954095720L;
        private final CycleType cycleTypeToEnrol;

        public CycleSelectionLinkController(CycleType cycleTypeToEnrol) {
            this.cycleTypeToEnrol = cycleTypeToEnrol;
        }

        protected boolean isToSkipUpdate() {
            return false;
        }

        public void linkPressed(IViewState viewState, HtmlActionLink link) {
            BolonhaStudentEnrollmentBean studentEnrollmentBean = (BolonhaStudentEnrollmentBean)viewState.getMetaObject().getObject();
            studentEnrollmentBean.setCycleTypeToEnrol(this.cycleTypeToEnrol);
        }
    }

    protected static class OptionalCurricularCourseLinkController
    extends HtmlActionLinkController {
        private static final long serialVersionUID = 2760270166511466030L;
        private final IDegreeModuleToEvaluate degreeModuleToEnrol;

        public OptionalCurricularCourseLinkController(IDegreeModuleToEvaluate degreeModuleToEnrol) {
            this.degreeModuleToEnrol = degreeModuleToEnrol;
        }

        protected boolean isToSkipUpdate() {
            return false;
        }

        public void linkPressed(IViewState viewState, HtmlActionLink link) {
            ((BolonhaStudentEnrollmentBean)viewState.getMetaObject().getObject()).setOptionalDegreeModuleToEnrol(this.degreeModuleToEnrol);
        }
    }
}

