/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components.degreeStructure;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.ui.faces.components.degreeStructure.UIDegreeModule;
import org.fenixedu.academic.util.CurricularPeriodLabelFormatter;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class UICurricularCourse
extends UIDegreeModule {
    public static final String COMPONENT_TYPE = "org.fenixedu.academic.ui.faces.components.degreeStructure.UICurricularCourse";
    public static final String COMPONENT_FAMILY = "org.fenixedu.academic.ui.faces.components.degreeStructure.UICurricularCourse";
    private final CurricularCourse curricularCourse;
    private final boolean byYears;

    public UICurricularCourse() {
        this.curricularCourse = (CurricularCourse)((Object)this.degreeModule);
        this.byYears = false;
    }

    public UICurricularCourse(DegreeModule curricularCourse, Context previousContext, Boolean toEdit, Boolean showRules, int depth, String tabs, ExecutionYear executionYear, String module, String currentPage, Boolean expandable) {
        super(curricularCourse, previousContext, toEdit, showRules, depth, tabs, executionYear, module, currentPage, expandable);
        this.curricularCourse = (CurricularCourse)((Object)this.degreeModule);
        this.byYears = false;
    }

    public UICurricularCourse(DegreeModule curricularCourse, Context previousContext, Boolean toEdit, Boolean showRules, ExecutionYear executionYear, String module, String currentPage, Boolean expandable) {
        super(curricularCourse, previousContext, toEdit, showRules, 0, null, executionYear, module, currentPage, expandable);
        this.curricularCourse = (CurricularCourse)((Object)this.degreeModule);
        this.byYears = true;
    }

    @Override
    public String getFamily() {
        return "org.fenixedu.academic.ui.faces.components.degreeStructure.UICurricularCourse";
    }

    @Override
    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.facesContext = facesContext;
        this.writer = facesContext.getResponseWriter();
        this.encodeCurricularCourse();
        if (this.showRules.booleanValue() && !this.curricularCourse.getCurricularRulesSet().isEmpty()) {
            this.encodeCurricularRules();
        }
        if (!this.byYears && this.curricularCourse.isBolonhaDegree() && this.curricularCourse.isAnual(this.executionYear)) {
            this.encodeInNextPeriod(facesContext);
        }
    }

    private void encodeCurricularCourse() throws IOException {
        this.writer.startElement("tr", (UIComponent)this);
        this.encodeName(true);
        this.encodeContext(this.previousContext.getCurricularPeriod());
        this.encodeRegime();
        this.encodeLoadsAndCredits(this.previousContext.getCurricularPeriod());
        if (this.toEdit.booleanValue()) {
            if (this.showRules.booleanValue()) {
                this.encodeCurricularRulesOptions();
            } else {
                this.encodeCurricularCourseOptions();
            }
        }
        this.writer.endElement("tr");
    }

    private void encodeName(boolean linkable) throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        if (linkable) {
            this.writer.startElement("a", (UIComponent)this);
            if (this.curricularCourse.isBolonhaDegree()) {
                this.encodeLinkHref(this.module + "/viewCurricularCourse.faces", "&curricularCourseID=" + this.curricularCourse.getExternalId(), false);
            } else {
                this.encodeNonBolonhaLinkHref();
            }
            this.appendCodeAndName();
            this.writer.endElement("a");
        } else {
            this.appendCodeAndName();
        }
        this.writer.endElement("td");
    }

    private void encodeNonBolonhaLinkHref() throws IOException {
        StringBuilder href = new StringBuilder();
        href.append(this.module + "/showCourseSite.do?method=showCurricularCourseSite");
        href.append("&curricularCourseID=").append(this.curricularCourse.getExternalId());
        href.append("&degreeID=").append(this.curricularCourse.getDegree().getExternalId());
        href.append("&degreeCurricularPlanID=").append(this.curricularCourse.getDegreeCurricularPlan().getExternalId());
        Map requestParameterMap = this.facesContext.getExternalContext().getRequestParameterMap();
        if (this.executionYear != null) {
            ExecutionSemester executionSemester = this.executionYear.getLastExecutionPeriod();
            href.append("&executionPeriodOID=").append(executionSemester.getExternalId());
        } else if (requestParameterMap.get("executionPeriodOID") != null) {
            href.append("&executionPeriodOID=").append((String)requestParameterMap.get("executionPeriodOID"));
        }
        this.writer.writeAttribute("href", (Object)href.toString(), null);
    }

    private void encodeContext(CurricularPeriod curricularPeriod) throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"smalltxt", null);
        if (!this.byYears) {
            this.writer.writeAttribute("align", (Object)"center", null);
            this.writer.append((CharSequence)CurricularPeriodLabelFormatter.getFullLabel(curricularPeriod, true));
        } else {
            this.writer.append((CharSequence)this.previousContext.getParentCourseGroup().getName());
        }
        this.writer.endElement("td");
    }

    private void encodeRegime() throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        if (!this.curricularCourse.isOptional() && this.curricularCourse.getRegime(this.executionYear) != null) {
            this.writer.writeAttribute("class", (Object)"highlight2 smalltxt", null);
            this.writer.writeAttribute("align", (Object)"center", null);
            this.writer.writeAttribute("style", (Object)"width: 1em;", null);
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.EnumerationResources", (String)(this.curricularCourse.getRegime(this.executionYear).toString() + ".ACRONYM"), (String[])new String[0]));
        } else {
            this.writer.append((CharSequence)"&nbsp;");
        }
        this.writer.endElement("td");
    }

    private void encodeLoadsAndCredits(CurricularPeriod curricularPeriod) throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        if (!this.curricularCourse.isOptional()) {
            this.writer.writeAttribute("class", (Object)"smalltxt", null);
            this.writer.writeAttribute("align", (Object)"right", null);
            this.writer.startElement("span", (UIComponent)this);
            this.writer.writeAttribute("style", (Object)"color: #888", null);
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"contactLessonHoursAcronym", (String[])new String[0])).append("-");
            this.writer.endElement("span");
            BigDecimal contactLoad = new BigDecimal(this.curricularCourse.getContactLoad(curricularPeriod, this.executionYear)).setScale(2, RoundingMode.HALF_EVEN);
            this.writer.append((CharSequence)contactLoad.toPlainString()).append(" ");
            this.writer.startElement("span", (UIComponent)this);
            this.writer.writeAttribute("style", (Object)"color: #888", null);
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"autonomousWorkAcronym", (String[])new String[0])).append("-");
            this.writer.endElement("span");
            this.writer.append((CharSequence)this.curricularCourse.getAutonomousWorkHours(curricularPeriod, this.executionYear).toString()).append(" ");
            this.writer.startElement("span", (UIComponent)this);
            this.writer.writeAttribute("style", (Object)"color: #888", null);
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"totalLoadAcronym", (String[])new String[0])).append("-");
            this.writer.endElement("span");
            this.writer.append((CharSequence)this.curricularCourse.getTotalLoad(curricularPeriod, this.executionYear).toString());
            this.writer.endElement("td");
            this.writer.startElement("td", (UIComponent)this);
            this.writer.writeAttribute("class", (Object)"smalltxt", null);
            this.writer.writeAttribute("align", (Object)"right", null);
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"credits.abbreviation", (String[])new String[0])).append(" ");
            this.writer.append((CharSequence)this.curricularCourse.getEctsCredits(curricularPeriod, this.executionYear).toString());
            if (this.curricularCourse.getBaseWeight() != null) {
                this.writer.append((CharSequence)" (");
                this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"weight", (String[])new String[0])).append(" ");
                this.writer.append((CharSequence)this.curricularCourse.getBaseWeight().toString());
                this.writer.append((CharSequence)")");
            }
        } else {
            this.writer.append((CharSequence)"&nbsp;");
            this.writer.endElement("td");
            this.writer.startElement("td", (UIComponent)this);
        }
        this.writer.endElement("td");
    }

    public void encodeInNextPeriod(FacesContext facesContext) throws IOException {
        this.facesContext = facesContext;
        this.writer = facesContext.getResponseWriter();
        this.writer.startElement("tr", (UIComponent)this);
        this.encodeName(false);
        this.writer.startElement("td", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"smalltxt", null);
        if (!this.byYears) {
            this.writer.writeAttribute("align", (Object)"center", null);
            if (this.previousContext.getCurricularPeriod().getParent().getChildOrder() != null) {
                this.writer.append((CharSequence)String.valueOf(this.previousContext.getCurricularPeriod().getParent().getChildOrder()));
                this.writer.append((CharSequence)" ");
                this.writer.append((CharSequence)BundleUtil.getString((String)"resources.EnumerationResources", (String)(this.previousContext.getCurricularPeriod().getParent().getAcademicPeriod().getName() + ".ABBREVIATION"), (String[])new String[0]));
                this.writer.append((CharSequence)", ");
            }
            this.writer.append((CharSequence)String.valueOf(this.previousContext.getCurricularPeriod().getChildOrder() + 1));
            this.writer.append((CharSequence)" ");
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.EnumerationResources", (String)(this.previousContext.getCurricularPeriod().getAcademicPeriod().getName() + ".ABBREVIATION"), (String[])new String[0]));
        } else {
            this.writer.append((CharSequence)this.previousContext.getParentCourseGroup().getName());
        }
        this.writer.endElement("td");
        this.encodeRegime();
        this.writer.startElement("td", (UIComponent)this);
        if (!this.curricularCourse.isOptional()) {
            this.writer.writeAttribute("class", (Object)"smalltxt", null);
            this.writer.writeAttribute("align", (Object)"right", null);
            this.writer.startElement("span", (UIComponent)this);
            this.writer.writeAttribute("style", (Object)"color: #888", null);
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"contactLessonHoursAcronym", (String[])new String[0])).append("-");
            this.writer.endElement("span");
            BigDecimal contactLoad = new BigDecimal(this.curricularCourse.getCompetenceCourse().getContactLoad((Integer)(this.previousContext.getCurricularPeriod().getChildOrder() + 1), this.executionYear)).setScale(2, RoundingMode.HALF_EVEN);
            this.writer.append((CharSequence)contactLoad.toString()).append(" ");
            this.writer.startElement("span", (UIComponent)this);
            this.writer.writeAttribute("style", (Object)"color: #888", null);
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"autonomousWorkAcronym", (String[])new String[0])).append("-");
            this.writer.endElement("span");
            this.writer.append((CharSequence)this.curricularCourse.getCompetenceCourse().getAutonomousWorkHours((Integer)(this.previousContext.getCurricularPeriod().getChildOrder() + 1), this.executionYear).toString()).append(" ");
            this.writer.startElement("span", (UIComponent)this);
            this.writer.writeAttribute("style", (Object)"color: #888", null);
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"totalLoadAcronym", (String[])new String[0])).append("-");
            this.writer.endElement("span");
            this.writer.append((CharSequence)this.curricularCourse.getCompetenceCourse().getTotalLoad((Integer)(this.previousContext.getCurricularPeriod().getChildOrder() + 1), this.executionYear).toString());
            this.writer.endElement("td");
            this.writer.startElement("td", (UIComponent)this);
            this.writer.writeAttribute("class", (Object)"smalltxt", null);
            this.writer.writeAttribute("align", (Object)"right", null);
            this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"credits.abbreviation", (String[])new String[0])).append(" ");
            this.writer.append((CharSequence)String.valueOf(this.curricularCourse.getCompetenceCourse().getEctsCredits((Integer)(this.previousContext.getCurricularPeriod().getChildOrder() + 1), this.executionYear)));
        } else {
            this.writer.append((CharSequence)"&nbsp;");
            this.writer.endElement("td");
            this.writer.startElement("td", (UIComponent)this);
        }
        this.writer.endElement("td");
        this.writer.startElement("td", (UIComponent)this);
        this.writer.append((CharSequence)"&nbsp;");
        this.writer.endElement("td");
        this.writer.endElement("tr");
    }

    private void encodeCurricularCourseOptions() throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        this.writer.writeAttribute("align", (Object)"right", null);
        this.writer.writeAttribute("style", (Object)"width: 9em;", null);
        if (this.loggedPersonCanManageDegreeCurricularPlans().booleanValue()) {
            this.encodeLink(this.module + "/editCurricularCourse.faces", "&contextID=" + this.previousContext.getExternalId() + "&curricularCourseID=" + this.curricularCourse.getExternalId(), false, "edit");
            this.writer.append((CharSequence)" , ");
            this.encodeLink(this.module + "/deleteCurricularCourseContext.faces", "&contextID=" + this.previousContext.getExternalId() + "&curricularCourseID=" + this.curricularCourse.getExternalId(), false, "delete");
        }
        this.writer.endElement("td");
    }

    private void encodeCurricularRulesOptions() throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        this.writer.writeAttribute("align", (Object)"right", null);
        this.writer.writeAttribute("style", (Object)"width: 9em;", null);
        if (this.loggedPersonCanManageDegreeCurricularPlans().booleanValue()) {
            this.encodeLink(this.module + "/curricularRules/createCurricularRule.faces", "&degreeModuleID=" + this.curricularCourse.getExternalId(), false, "setCurricularRule");
        }
        this.writer.endElement("td");
    }
}

