/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.student;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.service.ServiceMonitoring;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.student.EnrolStudentInWrittenEvaluation$callable$runEnrolStudentInWrittenEvaluation;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EnrolStudentInWrittenEvaluation {
    private static final EnrolStudentInWrittenEvaluation serviceInstance;
    public static final Advice advice$runEnrolStudentInWrittenEvaluation;

    protected void run(String username, String writtenEvaluationOID) throws FenixServiceException {
        ServiceMonitoring.logService(this.getClass(), username, writtenEvaluationOID);
        WrittenEvaluation writtenEvaluation = (WrittenEvaluation)FenixFramework.getDomainObject((String)writtenEvaluationOID);
        Person person = Person.readPersonByUsername(username);
        Student student = person.getStudent();
        Registration registration = this.findCorrectRegistration(student, writtenEvaluation.getAssociatedExecutionCoursesSet());
        if (writtenEvaluation == null || registration == null) {
            throw new InvalidArgumentsServiceException();
        }
        if (!writtenEvaluation.isInEnrolmentPeriod()) {
            throw new FenixServiceException("Enrolment period is not opened");
        }
        this.enrolmentAction(writtenEvaluation, registration);
    }

    private Registration findCorrectRegistration(Student student, Set<ExecutionCourse> associatedExecutionCoursesSet) {
        for (Registration registration : student.getRegistrationsSet()) {
            if (!registration.isActive()) continue;
            for (Attends attends : registration.getAssociatedAttendsSet()) {
                ExecutionCourse executionCourse = attends.getExecutionCourse();
                if (!associatedExecutionCoursesSet.contains((Object)executionCourse)) continue;
                return registration;
            }
        }
        return null;
    }

    public void enrolmentAction(WrittenEvaluation writtenEvaluation, Registration registration) {
        writtenEvaluation.enrolStudent(registration);
    }

    public static void runEnrolStudentInWrittenEvaluation(String string, String string2) throws FenixServiceException {
        Object object = advice$runEnrolStudentInWrittenEvaluation.perform((Callable)new EnrolStudentInWrittenEvaluation$callable$runEnrolStudentInWrittenEvaluation(string, string2));
    }

    static /* synthetic */ void advised$runEnrolStudentInWrittenEvaluation(String username, String writtenEvaluationOID) throws FenixServiceException {
        serviceInstance.run(username, writtenEvaluationOID);
    }

    static {
        advice$runEnrolStudentInWrittenEvaluation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new EnrolStudentInWrittenEvaluation();
    }
}

