/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.scientificCouncil.thesis;

import java.lang.annotation.Annotation;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.domain.thesis.ThesisParticipationType;
import org.fenixedu.academic.domain.thesis.ThesisState;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.scientificCouncil.thesis.ApproveThesisProposal$callable$runApproveThesisProposal;
import org.fenixedu.academic.service.services.scientificCouncil.thesis.ThesisServiceWithMailNotification;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ApproveThesisProposal
extends ThesisServiceWithMailNotification {
    private static final int FIELD_ON = 1;
    private static final int FIELD_OFF = 0;
    private static final String SUBJECT_KEY = "thesis.proposal.jury.approve.subject";
    private static final String BODY_KEY = "thesis.proposal.jury.approve.body";
    private static final String NO_DATE_KEY = "thesis.proposal.jury.approve.body.noDate";
    private static final String WITH_DATE_KEY = "thesis.proposal.jury.approve.body.withDate";
    private static final String COORDINATOR_SENDER = "thesis.proposal.jury.approve.body.sender.coordinator";
    private static final String COUNCIL_MEMBER_SENDER = "thesis.proposal.jury.approve.body.sender.council";
    private static final String COUNCIL_MEMBER_ROLE = "thesis.proposal.jury.approve.body.role.council";
    private static final ApproveThesisProposal serviceInstance;
    public static final Advice advice$runApproveThesisProposal;

    @Override
    void process(Thesis thesis) {
        if (thesis.getState() != ThesisState.APPROVED) {
            thesis.approveProposal();
        }
    }

    @Override
    protected Collection<String> getReceiversEmails(Thesis thesis) {
        Set<String> persons = thesis.getAllParticipants(ThesisParticipationType.ORIENTATOR, ThesisParticipationType.COORIENTATOR, ThesisParticipationType.PRESIDENT, ThesisParticipationType.VOWEL).stream().map(p -> p.getEmail()).collect(Collectors.toSet());
        persons.add(thesis.getStudent().getPerson().getProfile().getEmail());
        ExecutionYear executionYear = thesis.getEnrolment().getExecutionYear();
        for (ScientificCommission member : thesis.getDegree().getScientificCommissionMembers(executionYear)) {
            if (!member.isContact().booleanValue()) continue;
            persons.add(member.getPerson().getProfile().getEmail());
        }
        return persons;
    }

    @Override
    protected String getSubject(Thesis thesis) {
        return this.getMessage(I18N.getLocale(), SUBJECT_KEY, thesis.getTitle().getContent());
    }

    @Override
    protected String getMessage(Thesis thesis) {
        String dateMessage;
        Locale locale = I18N.getLocale();
        Person currentPerson = AccessControl.getPerson();
        ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
        String institutionName = Bennu.getInstance().getInstitutionUnit().getPartyName().getContent(locale);
        String title = thesis.getTitle().getContent();
        String year = executionYear.getYear();
        String degreeName = thesis.getDegree().getNameFor(executionYear).getContent();
        String studentName = thesis.getStudent().getPerson().getName();
        String studentNumber = thesis.getStudent().getNumber().toString();
        String presidentName = this.name(thesis.getPresident());
        String presidentAffiliation = this.affiliation(thesis.getPresident());
        String vowel1Name = this.name(thesis.getVowels(), 0);
        String vowel1Affiliation = this.affiliation(thesis.getVowels(), 0);
        String vowel2Name = this.name(thesis.getVowels(), 1);
        String vowel2Affiliation = this.affiliation(thesis.getVowels(), 1);
        String vowel3Name = this.name(thesis.getVowels(), 2);
        String vowel3Affiliation = this.affiliation(thesis.getVowels(), 2);
        String vowel4Name = this.name(thesis.getVowels(), 3);
        String vowel4Affiliation = this.affiliation(thesis.getVowels(), 3);
        String orientationName = thesis.getOrientation().stream().map(p -> p.getName() + ", " + p.getAffiliation()).collect(Collectors.joining("\n"));
        String currentPersonName = currentPerson.getNickname();
        String discussedDate = "";
        if (thesis.getDiscussed() == null) {
            dateMessage = this.getMessage(locale, NO_DATE_KEY, new Object[0]);
        } else {
            dateMessage = this.getMessage(locale, WITH_DATE_KEY, new Object[0]);
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"MM/dd/yyyy");
            discussedDate = thesis.getDiscussed().toString(fmt);
        }
        String sender = thesis.isCoordinator() ? this.getMessage(locale, COORDINATOR_SENDER, new Object[0]) : this.getMessage(locale, COUNCIL_MEMBER_SENDER, new Object[0]);
        String role = thesis.isCoordinator() ? "" : this.getMessage(locale, COUNCIL_MEMBER_ROLE, new Object[0]);
        Calendar today = Calendar.getInstance(locale);
        return this.getMessage(locale, BODY_KEY, year, degreeName, studentName, studentNumber, presidentName, presidentAffiliation, this.includeFlag(vowel1Name), vowel1Name, vowel1Affiliation, this.includeFlag(vowel2Name), vowel2Name, vowel2Affiliation, this.includeFlag(vowel3Name), vowel3Name, vowel3Affiliation, this.includeFlag(vowel4Name), vowel4Name, vowel4Affiliation, this.includeFlag(orientationName), orientationName, dateMessage, discussedDate, institutionName, "" + today.get(5), today.getDisplayName(2, 2, locale), "" + today.get(1), sender, currentPersonName, role);
    }

    private int includeFlag(String value) {
        return value == null ? 0 : 1;
    }

    private String name(ThesisEvaluationParticipant participant) {
        return participant == null ? null : participant.getName();
    }

    private String name(List<ThesisEvaluationParticipant> participants, int index) {
        if (participants.size() > index) {
            return this.name(participants.get(index));
        }
        return null;
    }

    private String affiliation(ThesisEvaluationParticipant participant) {
        return participant == null ? null : participant.getAffiliation();
    }

    private String affiliation(List<ThesisEvaluationParticipant> participants, int index) {
        if (participants.size() > index) {
            return this.affiliation(participants.get(index));
        }
        return null;
    }

    public static void runApproveThesisProposal(Thesis thesis) {
        Object object = advice$runApproveThesisProposal.perform((Callable)new ApproveThesisProposal$callable$runApproveThesisProposal(thesis));
    }

    static /* synthetic */ void advised$runApproveThesisProposal(Thesis thesis) {
        serviceInstance.run(thesis);
    }

    static {
        advice$runApproveThesisProposal = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ApproveThesisProposal();
    }
}

