/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionCourseLog;
import org.fenixedu.academic.domain.ExportGrouping;
import org.fenixedu.academic.domain.FinalEvaluation;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Mark;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftProfessorship;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.messaging.ConversationMessage;
import org.fenixedu.academic.domain.messaging.ConversationThread;
import org.fenixedu.academic.domain.messaging.ExecutionCourseForum;
import org.fenixedu.academic.domain.messaging.Forum;
import org.fenixedu.academic.domain.messaging.ForumSubscription;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.service.ServiceMonitoring;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.manager.MergeExecutionCourses$callable$merge;
import org.fenixedu.academic.util.MultiLanguageString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MergeExecutionCourses {
    private static final ConcurrentLinkedQueue<SubDomainMergeHandler> handlers;
    public static final Advice advice$merge;

    public static void registerMergeHandler(SubDomainMergeHandler handler) {
        handlers.add(handler);
    }

    public static void merge(ExecutionCourse executionCourse, ExecutionCourse executionCourse2) throws FenixServiceException {
        Object object = advice$merge.perform((Callable)new MergeExecutionCourses$callable$merge(executionCourse, executionCourse2));
    }

    static /* synthetic */ void advised$merge(ExecutionCourse executionCourseTo, ExecutionCourse executionCourseFrom) throws FenixServiceException {
        if (executionCourseFrom == null) {
            throw new InvalidArgumentsServiceException();
        }
        if (executionCourseTo == null) {
            throw new InvalidArgumentsServiceException();
        }
        ServiceMonitoring.logService(MergeExecutionCourses.class, executionCourseTo.getExternalId(), executionCourseFrom.getExternalId());
        if (executionCourseTo.equals((Object)executionCourseFrom)) {
            throw new SourceAndDestinationAreTheSameException();
        }
        if (MergeExecutionCourses.haveShiftsWithSameName(executionCourseFrom, executionCourseTo)) {
            throw new DuplicateShiftNameException();
        }
        for (SubDomainMergeHandler handler : handlers) {
            Set<String> blockers = handler.mergeBlockers(executionCourseFrom, executionCourseTo);
            if (blockers.isEmpty()) {
                handler.merge(executionCourseFrom, executionCourseTo);
                continue;
            }
            throw new MergeNotPossibleException(blockers);
        }
        executionCourseFrom.delete();
    }

    private static boolean haveShiftsWithSameName(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        HashSet<String> shiftNames = new HashSet<String>();
        for (Shift shift : executionCourseFrom.getAssociatedShifts()) {
            shiftNames.add(shift.getNome());
        }
        for (Shift shift : executionCourseTo.getAssociatedShifts()) {
            if (!shiftNames.contains(shift.getNome())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMergeAllowed(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        return executionCourseTo != null && executionCourseFrom != null && executionCourseFrom.getExecutionPeriod().equals(executionCourseTo.getExecutionPeriod()) && executionCourseFrom != executionCourseTo;
    }

    private static void copySummaries(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        ArrayList associatedSummaries = new ArrayList();
        associatedSummaries.addAll(executionCourseFrom.getAssociatedSummariesSet());
        for (Summary summary : associatedSummaries) {
            summary.setExecutionCourse(executionCourseTo);
        }
    }

    private static void copyGroupPropertiesExecutionCourse(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        ArrayList associatedGroupPropertiesExecutionCourse = new ArrayList();
        associatedGroupPropertiesExecutionCourse.addAll(executionCourseFrom.getExportGroupingsSet());
        for (ExportGrouping groupPropertiesExecutionCourse : associatedGroupPropertiesExecutionCourse) {
            if (executionCourseTo.hasGrouping(groupPropertiesExecutionCourse.getGrouping())) {
                groupPropertiesExecutionCourse.delete();
                continue;
            }
            groupPropertiesExecutionCourse.setExecutionCourse(executionCourseTo);
        }
    }

    private static void removeEvaluations(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) throws FenixServiceException {
        while (!executionCourseFrom.getAssociatedEvaluationsSet().isEmpty()) {
            Evaluation evaluation = (Evaluation)((Object)executionCourseFrom.getAssociatedEvaluationsSet().iterator().next());
            if (evaluation instanceof FinalEvaluation) {
                FinalEvaluation finalEvaluationFrom = (FinalEvaluation)((Object)evaluation);
                if (!finalEvaluationFrom.getMarksSet().isEmpty()) {
                    throw new FenixServiceException("error.merge.execution.course.final.evaluation.exists");
                }
                finalEvaluationFrom.delete();
                continue;
            }
            executionCourseTo.getAssociatedEvaluationsSet().add(evaluation);
            executionCourseFrom.getAssociatedEvaluationsSet().remove((Object)evaluation);
        }
    }

    private static void copyBibliographicReference(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        while (!executionCourseFrom.getAssociatedBibliographicReferencesSet().isEmpty()) {
            executionCourseTo.getAssociatedBibliographicReferencesSet().add(executionCourseFrom.getAssociatedBibliographicReferencesSet().iterator().next());
        }
    }

    private static void copyShifts(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        ArrayList<Shift> associatedShifts = new ArrayList<Shift>(executionCourseFrom.getAssociatedShifts());
        for (Shift shift : associatedShifts) {
            ArrayList courseLoadsFrom = new ArrayList(shift.getCourseLoadsSet());
            Iterator iter = courseLoadsFrom.iterator();
            while (iter.hasNext()) {
                CourseLoad courseLoadFrom = (CourseLoad)((Object)iter.next());
                CourseLoad courseLoadTo = executionCourseTo.getCourseLoadByShiftType(courseLoadFrom.getType());
                if (courseLoadTo == null) {
                    courseLoadTo = new CourseLoad(executionCourseTo, courseLoadFrom.getType(), courseLoadFrom.getUnitQuantity(), courseLoadFrom.getTotalQuantity());
                }
                iter.remove();
                shift.removeCourseLoads(courseLoadFrom);
                shift.addCourseLoads(courseLoadTo);
            }
        }
    }

    private static void copyLessonsInstances(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        ArrayList<LessonInstance> associatedLessons = new ArrayList<LessonInstance>(executionCourseFrom.getAssociatedLessonInstances());
        for (LessonInstance lessonInstance : associatedLessons) {
            CourseLoad courseLoadFrom = lessonInstance.getCourseLoad();
            CourseLoad courseLoadTo = executionCourseTo.getCourseLoadByShiftType(courseLoadFrom.getType());
            if (courseLoadTo == null) {
                courseLoadTo = new CourseLoad(executionCourseTo, courseLoadFrom.getType(), courseLoadFrom.getUnitQuantity(), courseLoadFrom.getTotalQuantity());
            }
            lessonInstance.setCourseLoad(courseLoadTo);
        }
    }

    private static void copyAttends(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) throws FenixServiceException {
        for (Attends attends : executionCourseFrom.getAttendsSet()) {
            Attends otherAttends = executionCourseTo.getAttendsByStudent(attends.getRegistration());
            if (otherAttends == null) {
                attends.setDisciplinaExecucao(executionCourseTo);
                continue;
            }
            if (attends.getEnrolment() != null && otherAttends.getEnrolment() == null) {
                otherAttends.setEnrolment(attends.getEnrolment());
            } else if ((otherAttends.getEnrolment() == null || attends.getEnrolment() != null) && otherAttends.getEnrolment() != null && attends.getEnrolment() != null) {
                throw new FenixServiceException("Unable to merge execution courses. Registration " + attends.getRegistration().getNumber() + " has an enrolment in both.");
            }
            for (Mark mark : attends.getAssociatedMarksSet()) {
                otherAttends.addAssociatedMarks(mark);
            }
            for (StudentGroup group : attends.getAllStudentGroups()) {
                otherAttends.addStudentGroups(group);
            }
            attends.delete();
        }
        Iterator associatedAttendsFromDestination = executionCourseTo.getAttendsSet().iterator();
        HashMap<String, Attends> alreadyAttendingDestination = new HashMap<String, Attends>();
        while (associatedAttendsFromDestination.hasNext()) {
            Attends attend = (Attends)((Object)associatedAttendsFromDestination.next());
            Registration registration = attend.getRegistration();
            if (registration == null) {
                attend.delete();
                continue;
            }
            Integer number = registration.getNumber();
            alreadyAttendingDestination.put(number.toString(), attend);
        }
        ArrayList associatedAttendsFromSource = new ArrayList();
        associatedAttendsFromSource.addAll(executionCourseFrom.getAttendsSet());
        for (Attends attend : associatedAttendsFromSource) {
            if (alreadyAttendingDestination.containsKey(attend.getRegistration().getNumber().toString())) continue;
            attend.setDisciplinaExecucao(executionCourseTo);
        }
    }

    private static void copyProfessorships(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        for (Professorship professorship : executionCourseFrom.getProfessorshipsSet()) {
            Professorship otherProfessorship = MergeExecutionCourses.findProfessorShip(executionCourseTo, professorship.getPerson());
            if (otherProfessorship == null) {
                otherProfessorship = Professorship.create(professorship.getResponsibleFor(), executionCourseTo, professorship.getPerson());
            }
            while (!professorship.getAssociatedSummariesSet().isEmpty()) {
                otherProfessorship.addAssociatedSummaries((Summary)((Object)professorship.getAssociatedSummariesSet().iterator().next()));
            }
            while (!professorship.getAssociatedShiftProfessorshipSet().isEmpty()) {
                otherProfessorship.addAssociatedShiftProfessorship((ShiftProfessorship)((Object)professorship.getAssociatedShiftProfessorshipSet().iterator().next()));
            }
        }
    }

    private static Professorship findProfessorShip(ExecutionCourse executionCourseTo, Person person) {
        for (Professorship professorship : executionCourseTo.getProfessorshipsSet()) {
            if (professorship.getPerson() != person) continue;
            return professorship;
        }
        return null;
    }

    private static void copyForuns(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) throws FenixServiceException {
        while (!executionCourseFrom.getForuns().isEmpty()) {
            ExecutionCourseForum sourceForum = executionCourseFrom.getForuns().iterator().next();
            MultiLanguageString forumName = sourceForum.getName();
            ExecutionCourseForum targetForum = executionCourseTo.getForumByName(forumName);
            if (targetForum == null) {
                sourceForum.setExecutionCourse(executionCourseTo);
                continue;
            }
            MergeExecutionCourses.copyForumSubscriptions(sourceForum, targetForum);
            MergeExecutionCourses.copyThreads(sourceForum, targetForum);
            executionCourseFrom.removeForum(sourceForum);
            sourceForum.delete();
        }
    }

    private static void copyForumSubscriptions(ExecutionCourseForum sourceForum, ExecutionCourseForum targetForum) {
        while (!sourceForum.getForumSubscriptionsSet().isEmpty()) {
            ForumSubscription sourceForumSubscription = (ForumSubscription)((Object)sourceForum.getForumSubscriptionsSet().iterator().next());
            Person sourceForumSubscriber = sourceForumSubscription.getPerson();
            ForumSubscription targetForumSubscription = targetForum.getPersonSubscription(sourceForumSubscriber);
            if (targetForumSubscription == null) {
                sourceForumSubscription.setForum((Forum)((Object)targetForum));
                continue;
            }
            if (sourceForumSubscription.getReceivePostsByEmail().booleanValue()) {
                targetForumSubscription.setReceivePostsByEmail(true);
            }
            if (sourceForumSubscription.getFavorite().booleanValue()) {
                targetForumSubscription.setFavorite(true);
            }
            sourceForum.removeForumSubscriptions(sourceForumSubscription);
            sourceForumSubscription.delete();
        }
    }

    private static void copyThreads(ExecutionCourseForum sourceForum, ExecutionCourseForum targetForum) {
        while (!sourceForum.getConversationThreadSet().isEmpty()) {
            ConversationThread sourceConversationThread = (ConversationThread)sourceForum.getConversationThreadSet().iterator().next();
            if (!targetForum.hasConversationThreadWithSubject(sourceConversationThread.getTitle())) {
                sourceConversationThread.setForum((Forum)((Object)targetForum));
                continue;
            }
            ConversationThread targetConversionThread = targetForum.getConversationThreadBySubject(sourceConversationThread.getTitle());
            for (ConversationMessage message : sourceConversationThread.getMessageSet()) {
                message.setConversationThread(targetConversionThread);
            }
            sourceForum.removeConversationThread(sourceConversationThread);
            sourceConversationThread.delete();
        }
    }

    private static void copyExecutionCourseLogs(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        for (ExecutionCourseLog executionCourseLog : executionCourseFrom.getExecutionCourseLogsSet()) {
            executionCourseLog.setExecutionCourse(executionCourseTo);
        }
    }

    private static void copyPersistentGroups(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        for (Object group : executionCourseFrom.getStudentGroupSet()) {
            group.setExecutionCourse(executionCourseTo);
        }
        for (Object group : executionCourseFrom.getSpecialCriteriaOverExecutionCourseGroupSet()) {
            group.setExecutionCourse(executionCourseTo);
        }
        for (Object group : executionCourseFrom.getTeacherGroupSet()) {
            group.setExecutionCourse(executionCourseTo);
        }
    }

    private static void dropEvaluationMethods(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
        if (executionCourseFrom.getEvaluationMethod() != null) {
            executionCourseFrom.getEvaluationMethod().delete();
        }
    }

    static {
        advice$merge = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        handlers = new ConcurrentLinkedQueue();
        MergeExecutionCourses.registerMergeHandler(new SubDomainMergeHandler(){

            @Override
            public Set<String> mergeBlockers(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
                if (!MergeExecutionCourses.isMergeAllowed(executionCourseFrom, executionCourseTo)) {
                    return Collections.singleton("Cannot merge courses of different periods");
                }
                return Collections.emptySet();
            }

            @Override
            public void merge(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) throws FenixServiceException {
                MergeExecutionCourses.copyShifts(executionCourseFrom, executionCourseTo);
            }
        });
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::copyLessonsInstances);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::copyProfessorships);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::copyAttends);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::copyBibliographicReference);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::dropEvaluationMethods);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::copySummaries);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::copyGroupPropertiesExecutionCourse);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::removeEvaluations);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::copyForuns);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::copyExecutionCourseLogs);
        MergeExecutionCourses.registerMergeHandler(MergeExecutionCourses::copyPersistentGroups);
        MergeExecutionCourses.registerMergeHandler((from, to) -> to.getAssociatedCurricularCoursesSet().addAll(from.getAssociatedCurricularCoursesSet()));
        MergeExecutionCourses.registerMergeHandler((from, to) -> to.copyLessonPlanningsFrom(from));
    }

    @FunctionalInterface
    public static interface SubDomainMergeHandler {
        default public Set<String> mergeBlockers(ExecutionCourse executionCourseFrom, ExecutionCourse executionCourseTo) {
            return Collections.emptySet();
        }

        public void merge(ExecutionCourse var1, ExecutionCourse var2) throws FenixServiceException;
    }

    public static class MergeNotPossibleException
    extends FenixServiceException {
        private static final long serialVersionUID = 3761968254943244338L;

        public MergeNotPossibleException(Set<String> blockers) {
            super(blockers.stream().collect(Collectors.joining("; ")));
        }
    }

    public static class DuplicateShiftNameException
    extends FenixServiceException {
        private static final long serialVersionUID = 3761968254943244338L;
    }

    public static class SourceAndDestinationAreTheSameException
    extends FenixServiceException {
        private static final long serialVersionUID = 3761968254943244338L;
    }
}

