/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission;

import java.io.Serializable;
import java.util.Date;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class MarkSheetEnrolmentEvaluationBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String gradeValue;
    private Date evaluationDate;
    private Enrolment enrolment;
    private String bookReference;
    private String page;
    private EnrolmentEvaluation enrolmentEvaluation;
    private ExecutionSemester executionSemester;
    private Boolean enrolmentEvaluationSet;
    private EvaluationSeason evaluationSeason;
    private GradeScale gradeScale;
    private Double weight;

    public MarkSheetEnrolmentEvaluationBean() {
    }

    public MarkSheetEnrolmentEvaluationBean(Enrolment enrolment, Date evaluationDate, Grade grade) {
        this.setEnrolment(enrolment);
        this.setEvaluationDate(evaluationDate);
        this.setGradeValue(grade.getValue());
        this.setWeight(enrolment.getWeigth());
    }

    public MarkSheetEnrolmentEvaluationBean(Enrolment enrolment, ExecutionSemester executionSemester, EvaluationSeason season) {
        this.setExecutionSemester(executionSemester);
        this.setEnrolment(enrolment);
        this.setEvaluationSeason(season);
        this.setWeight(enrolment.getWeigth());
        if (this.getHasGrade().booleanValue()) {
            EnrolmentEvaluation enrolmentEvaluation = this.getLatestEnrolmentEvaluation();
            Grade grade = enrolmentEvaluation.getGrade();
            this.gradeValue = grade.getValue();
            this.evaluationDate = enrolmentEvaluation.getExamDate();
            this.bookReference = enrolmentEvaluation.getBookReference();
            this.page = enrolmentEvaluation.getPage();
            this.gradeScale = enrolmentEvaluation.getAssociatedGradeScale();
        }
        this.enrolmentEvaluationSet = null;
    }

    public Date getEvaluationDate() {
        return this.evaluationDate;
    }

    public void setEvaluationDate(Date evaluationDate) {
        this.evaluationDate = evaluationDate;
    }

    public Enrolment getEnrolment() {
        return this.enrolment;
    }

    public void setEnrolment(Enrolment enrolment) {
        this.enrolment = enrolment;
    }

    public String getGradeValue() {
        return this.gradeValue;
    }

    public void setGradeValue(String grade) {
        this.gradeValue = grade;
    }

    public boolean hasAnyGradeValue() {
        return this.getGradeValue() != null && this.getGradeValue().length() != 0;
    }

    public EnrolmentEvaluation getEnrolmentEvaluation() {
        return this.enrolmentEvaluation;
    }

    public void setEnrolmentEvaluation(EnrolmentEvaluation enrolmentEvaluation) {
        this.enrolmentEvaluation = enrolmentEvaluation;
        if (this.enrolmentEvaluation != null) {
            this.setEnrolment(this.enrolmentEvaluation.getEnrolment());
        }
    }

    public String getBookReference() {
        return this.bookReference;
    }

    public void setBookReference(String bookReference) {
        this.bookReference = bookReference;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public ExecutionSemester getExecutionSemester() {
        return this.executionSemester != null ? this.executionSemester : null;
    }

    public void setExecutionSemester(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public Boolean getHasGrade() {
        return this.getLatestEnrolmentEvaluation() != null;
    }

    public Boolean getHasFinalGrade() {
        return this.getHasGrade() != false && this.getLatestEnrolmentEvaluation().isFinal();
    }

    public String getName() {
        return this.getEnrolment().getName().getContent();
    }

    public EnrolmentEvaluation getLatestEnrolmentEvaluation() {
        return this.getEnrolment().getLatestEnrolmentEvaluationBySeason(this.getEvaluationSeason());
    }

    public String getExecutionYearFullLabel() {
        return this.getEnrolment().getExecutionPeriod().getExecutionYear().getYear();
    }

    public String getExecutionSemesterFullLabel() {
        return String.format("%s %s", this.getEnrolment().getExecutionPeriod().getSemester().toString(), BundleUtil.getString((String)"resources.EnumerationResources", (String)"SEMESTER.ABBREVIATION", (String[])new String[0]));
    }

    public String getEnrolmentState() {
        return this.getEnrolment().getEnrollmentState().getDescription();
    }

    public String getEnrolmentCondition() {
        return this.getEnrolment().getEnrolmentCondition().getDescription();
    }

    public void setEnrolmentEvaluationSet(Boolean value) {
        this.enrolmentEvaluationSet = value;
    }

    public Boolean getEnrolmentEvaluationSet() {
        return this.enrolmentEvaluationSet;
    }

    public EvaluationSeason getEvaluationSeason() {
        return this.evaluationSeason;
    }

    public void setEvaluationSeason(EvaluationSeason evaluationSeason) {
        this.evaluationSeason = evaluationSeason;
    }

    public GradeScale getGradeScale() {
        return this.gradeScale;
    }

    public void setGradeScale(GradeScale value) {
        this.gradeScale = value;
    }

    public boolean isEnrolmentBeMarkedAsEnroled() {
        return this.getEnrolment().getEvaluationsSet().isEmpty();
    }

    public boolean isPossibleToUnEnrolEnrolment() {
        return this.getEnrolment().getEvaluationsSet().isEmpty() && this.getEnrolment().getEnrollmentState().equals((Object)EnrollmentState.ENROLLED);
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }
}

