/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.dto.DataTranferObject;
import org.fenixedu.academic.dto.InfoCurricularCourseScope;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;

public class CurricularCourseScopesForPrintDTO
extends DataTranferObject {
    private List<DegreeCurricularPlanForPrintDTO> degreeCurricularPlans = new ArrayList<DegreeCurricularPlanForPrintDTO>();
    private static final Comparator<InfoCurricularCourseScope> COMPARATOR_BY_ANOTATION_AND_CURRICULAR_COURSE_NAME = new Comparator<InfoCurricularCourseScope>(){

        @Override
        public int compare(InfoCurricularCourseScope o1, InfoCurricularCourseScope o2) {
            if (o1.getAnotation() == null) {
                return -1;
            }
            if (o2.getAnotation() == null) {
                return 1;
            }
            int result = o1.getAnotation().compareTo(o2.getAnotation());
            return result == 0 ? o1.getInfoCurricularCourse().getName().compareTo(o2.getInfoCurricularCourse().getName()) : result;
        }
    };

    public void add(InfoCurricularCourseScope scope) {
        DegreeCurricularPlanForPrintDTO selectedCurricularPlan = this.getSelectedCurricularPlan(scope);
        CurricularYearForPrintDTO selectedCurricularYear = this.getSelectedCurricularYear(scope, selectedCurricularPlan);
        BranchForPrintDTO selectedBranch = this.getSelectedBranch(scope, selectedCurricularYear);
        CurricularSemesterForPrintDTO selectedSemester = this.getSelectedSemester(scope, selectedBranch);
        this.addScope(scope, selectedSemester);
    }

    private void addScope(InfoCurricularCourseScope scope, CurricularSemesterForPrintDTO selectedSemester) {
        selectedSemester.getScopes().add(scope);
        this.sortScopes(selectedSemester.getScopes());
    }

    private void sortScopes(List<InfoCurricularCourseScope> scopes) {
        Collections.sort(scopes, COMPARATOR_BY_ANOTATION_AND_CURRICULAR_COURSE_NAME);
    }

    private CurricularSemesterForPrintDTO getSelectedSemester(final InfoCurricularCourseScope scope, BranchForPrintDTO selectedBranch) {
        CurricularSemesterForPrintDTO selectedSemester = (CurricularSemesterForPrintDTO)CollectionUtils.find(selectedBranch.getSemesters(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                CurricularSemesterForPrintDTO curricularSemesterForPrintDTO = (CurricularSemesterForPrintDTO)arg0;
                return curricularSemesterForPrintDTO.getSemester().equals(scope.getInfoCurricularSemester().getSemester());
            }
        });
        if (selectedSemester == null) {
            selectedSemester = new CurricularSemesterForPrintDTO(scope.getInfoCurricularSemester().getSemester());
            selectedBranch.getSemesters().add(selectedSemester);
        }
        return selectedSemester;
    }

    private BranchForPrintDTO getSelectedBranch(final InfoCurricularCourseScope scope, CurricularYearForPrintDTO selectedCurricularYear) {
        BranchForPrintDTO selectedBranch = (BranchForPrintDTO)CollectionUtils.find(selectedCurricularYear.getBranches(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                BranchForPrintDTO branchForPrintDTO = (BranchForPrintDTO)arg0;
                return branchForPrintDTO.getName().equals(scope.getInfoBranch().getName());
            }
        });
        if (selectedBranch == null) {
            selectedBranch = new BranchForPrintDTO(scope.getInfoBranch().getName());
            selectedCurricularYear.getBranches().add(selectedBranch);
        }
        return selectedBranch;
    }

    private CurricularYearForPrintDTO getSelectedCurricularYear(final InfoCurricularCourseScope scope, DegreeCurricularPlanForPrintDTO selectedCurricularPlan) {
        CurricularYearForPrintDTO selectedCurricularYear = (CurricularYearForPrintDTO)CollectionUtils.find(selectedCurricularPlan.getYears(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                CurricularYearForPrintDTO curricularYearForPrintDTO = (CurricularYearForPrintDTO)arg0;
                return curricularYearForPrintDTO.getYear().equals(scope.getInfoCurricularSemester().getInfoCurricularYear().getYear());
            }
        });
        if (selectedCurricularYear == null) {
            selectedCurricularYear = new CurricularYearForPrintDTO(scope.getInfoCurricularSemester().getInfoCurricularYear().getYear());
            selectedCurricularPlan.getYears().add(selectedCurricularYear);
        }
        return selectedCurricularYear;
    }

    private DegreeCurricularPlanForPrintDTO getSelectedCurricularPlan(final InfoCurricularCourseScope scope) {
        DegreeCurricularPlanForPrintDTO selectedCurricularPlan = (DegreeCurricularPlanForPrintDTO)CollectionUtils.find(this.getDegreeCurricularPlans(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                DegreeCurricularPlanForPrintDTO degreeCurricularPlanForPrintDTO = (DegreeCurricularPlanForPrintDTO)arg0;
                return degreeCurricularPlanForPrintDTO.name.equals(scope.getInfoCurricularCourse().getInfoDegreeCurricularPlan().getName());
            }
        });
        if (selectedCurricularPlan == null) {
            InfoDegreeCurricularPlan degreeCurricularPlan = scope.getInfoCurricularCourse().getInfoDegreeCurricularPlan();
            selectedCurricularPlan = new DegreeCurricularPlanForPrintDTO(degreeCurricularPlan.getName(), degreeCurricularPlan.getInfoDegree().getNome(), degreeCurricularPlan.getAnotation());
            this.getDegreeCurricularPlans().add(selectedCurricularPlan);
        }
        return selectedCurricularPlan;
    }

    public List<DegreeCurricularPlanForPrintDTO> getDegreeCurricularPlans() {
        return this.degreeCurricularPlans;
    }

    public void setDegreeCurricularPlans(List<DegreeCurricularPlanForPrintDTO> degreeCurricularPlans) {
        this.degreeCurricularPlans = degreeCurricularPlans;
    }

    public static class CurricularSemesterForPrintDTO
    extends DataTranferObject {
        private Integer semester;
        private List<InfoCurricularCourseScope> scopes = new ArrayList<InfoCurricularCourseScope>();

        public CurricularSemesterForPrintDTO(Integer semester) {
            this.semester = semester;
        }

        public void add(InfoCurricularCourseScope scope) {
            this.getScopes().add(scope);
        }

        public List<InfoCurricularCourseScope> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<InfoCurricularCourseScope> scopes) {
            this.scopes = scopes;
        }

        public Integer getSemester() {
            return this.semester;
        }

        public void setSemester(Integer semester) {
            this.semester = semester;
        }
    }

    public static class BranchForPrintDTO
    extends DataTranferObject {
        private String name;
        private List<CurricularSemesterForPrintDTO> semesters = new ArrayList<CurricularSemesterForPrintDTO>();

        public BranchForPrintDTO(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<CurricularSemesterForPrintDTO> getSemesters() {
            return this.semesters;
        }

        public void setSemesters(List<CurricularSemesterForPrintDTO> semester) {
            this.semesters = semester;
        }
    }

    public static class CurricularYearForPrintDTO
    extends DataTranferObject {
        private Integer year;
        private List<BranchForPrintDTO> branches = new ArrayList<BranchForPrintDTO>();

        public CurricularYearForPrintDTO(Integer year) {
            this.year = year;
        }

        public List<BranchForPrintDTO> getBranches() {
            return this.branches;
        }

        public void setBranches(List<BranchForPrintDTO> branches) {
            this.branches = branches;
        }

        public Integer getYear() {
            return this.year;
        }

        public void setYear(Integer year) {
            this.year = year;
        }
    }

    public static class DegreeCurricularPlanForPrintDTO
    extends DataTranferObject {
        private String name;
        private String degreeName;
        private String anotation;
        private List<CurricularYearForPrintDTO> years = new ArrayList<CurricularYearForPrintDTO>();

        public DegreeCurricularPlanForPrintDTO(String name, String degreeName, String anotation) {
            this.name = name;
            this.degreeName = degreeName;
            this.anotation = anotation;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<CurricularYearForPrintDTO> getYears() {
            return this.years;
        }

        public void setYears(List<CurricularYearForPrintDTO> years) {
            this.years = years;
        }

        public String getAnotation() {
            return this.anotation;
        }

        public void setAnotation(String anotation) {
            this.anotation = anotation;
        }

        public String getDegreeName() {
            return this.degreeName;
        }

        public void setDegreeName(String degreeName) {
            this.degreeName = degreeName;
        }
    }
}

