/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.Under23TransportsDeclarationRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;

public class Under23TransportsDeclarationRequest
extends Under23TransportsDeclarationRequest_Base {
    private Under23TransportsDeclarationRequest() {
    }

    public Under23TransportsDeclarationRequest(RegistrationAcademicServiceRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkPersonAge(this.getPerson());
    }

    private void checkPersonAge(Person person) {
        if (new Period((ReadablePartial)person.getDateOfBirthYearMonthDay(), (ReadablePartial)new LocalDate()).getYears() > 23) {
            throw new DomainException("error.Under23TransportsDeclarationRequest.invalid.person.age", new String[0]);
        }
    }

    protected void createAcademicServiceRequestSituations(AcademicServiceRequestBean academicServiceRequestBean) {
        super.createAcademicServiceRequestSituations(academicServiceRequestBean);
        if (academicServiceRequestBean.isNew()) {
            AcademicServiceRequestSituation.create((AcademicServiceRequest)((Object)this), new AcademicServiceRequestBean(AcademicServiceRequestSituationType.PROCESSING, academicServiceRequestBean.getResponsible()));
        } else if (academicServiceRequestBean.isToConclude()) {
            AcademicServiceRequestSituation.create((AcademicServiceRequest)((Object)this), new AcademicServiceRequestBean(AcademicServiceRequestSituationType.DELIVERED, academicServiceRequestBean.getResponsible()));
        }
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public EventType getEventType() {
        return null;
    }

    public boolean hasPersonalInfo() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return false;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isToPrint() {
        return !this.isDelivered();
    }

    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.UNDER_23_TRANSPORTS_REQUEST;
    }

    public String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isPagedDocument() {
        return false;
    }
}

