/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.bennu.core.domain.User;

public class RejectJuryElementsDocuments
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (!process2.getActiveState().equals(PhdThesisProcessStateType.JURY_WAITING_FOR_VALIDATION)) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
        if (process2.hasJuryElementsDocument().booleanValue() && process2.getJuryElementsDocument().getDocumentAccepted().booleanValue()) {
            return;
        }
        if (process2.hasJuryPresidentDocument().booleanValue() && process2.getJuryPresidentDocument().getDocumentAccepted().booleanValue()) {
            return;
        }
        throw new PreConditionNotValidException();
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        process2.deleteLastState();
        process2.rejectJuryElementsDocuments();
        if (bean.isToNotify()) {
            AlertService.alertCoordinators(process2.getIndividualProgramProcess(), "message.phd.alert.reject.jury.elements.documents.subject", "message.phd.alert.reject.jury.elements.documents.body");
        }
        return process2;
    }
}

