/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.standalone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessState;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneCandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.StandaloneCandidacyPeriod;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class StandaloneCandidacyProcess
extends StandaloneCandidacyProcess_Base {
    private static final List<Activity> activities = new ArrayList<Activity>();
    private static final Predicate<DegreeType> ALLOWED_DEGREE_TYPES;

    private StandaloneCandidacyProcess() {
    }

    public StandaloneCandidacyProcess(ExecutionSemester executionSemester, DateTime start, DateTime end) {
        this();
        this.checkParameters((ExecutionInterval)((Object)executionSemester), start, end);
        this.setState(CandidacyProcessState.STAND_BY);
        new StandaloneCandidacyPeriod(this, executionSemester, start, end);
    }

    private void checkParameters(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        if (executionInterval == null) {
            throw new DomainException("error.StandaloneCandidacyProcess.invalid.executionInterval", new String[0]);
        }
        if (start == null || end == null || start.isAfter((ReadableInstant)end)) {
            throw new DomainException("error.StandaloneCandidacyProcess.invalid.interval", new String[0]);
        }
    }

    public boolean canExecuteActivity(User userView) {
        return StandaloneCandidacyProcess.isAllowedToManageProcess(userView);
    }

    public List<Activity> getActivities() {
        return activities;
    }

    private void edit(DateTime start, DateTime end) {
        this.checkParameters(this.getCandidacyPeriod().getExecutionInterval(), start, end);
        this.getCandidacyPeriod().edit(start, end);
    }

    public List<StandaloneIndividualCandidacyProcess> getSortedStandaloneIndividualCandidaciesThatCanBeSendToJury() {
        ArrayList<StandaloneIndividualCandidacyProcess> result = new ArrayList<StandaloneIndividualCandidacyProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            if (!child.isCandidacyValid()) continue;
            result.add((StandaloneIndividualCandidacyProcess)((Object)child));
        }
        Collections.sort(result, StandaloneIndividualCandidacyProcess.COMPARATOR_BY_CANDIDACY_PERSON);
        return result;
    }

    public List<StandaloneIndividualCandidacyProcess> getAcceptedStandaloneIndividualCandidacies() {
        ArrayList<StandaloneIndividualCandidacyProcess> result = new ArrayList<StandaloneIndividualCandidacyProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            if (!child.isCandidacyValid() || !child.isCandidacyAccepted()) continue;
            result.add((StandaloneIndividualCandidacyProcess)((Object)child));
        }
        return result;
    }

    private static boolean isAllowedToManageProcess(User userView) {
        for (AcademicProgram program : AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_CANDIDACY_PROCESSES, userView.getPerson().getUser()).collect(Collectors.toSet())) {
            if (!ALLOWED_DEGREE_TYPES.test(program.getDegreeType())) continue;
            return true;
        }
        return false;
    }

    static {
        activities.add(new EditCandidacyPeriod());
        activities.add(new SendToCoordinator());
        activities.add(new PrintCandidacies());
        ALLOWED_DEGREE_TYPES = DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree, DegreeType::isAdvancedFormationDiploma, DegreeType::isIntegratedMasterDegree, DegreeType::isSpecializationDegree);
    }

    private static class PrintCandidacies
    extends Activity<StandaloneCandidacyProcess> {
        private PrintCandidacies() {
        }

        @Override
        public void checkPreConditions(StandaloneCandidacyProcess process2, User userView) {
            if (!StandaloneCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneCandidacyProcess executeActivity(StandaloneCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class SendToCoordinator
    extends Activity<StandaloneCandidacyProcess> {
        private SendToCoordinator() {
        }

        @Override
        public void checkPreConditions(StandaloneCandidacyProcess process2, User userView) {
            if (!StandaloneCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isInStandBy()) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacyPeriod() == null || !process2.hasStarted() || process2.hasOpenCandidacyPeriod()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneCandidacyProcess executeActivity(StandaloneCandidacyProcess process2, User userView, Object object) {
            process2.setState(CandidacyProcessState.SENT_TO_COORDINATOR);
            return process2;
        }
    }

    private static class EditCandidacyPeriod
    extends Activity<StandaloneCandidacyProcess> {
        private EditCandidacyPeriod() {
        }

        @Override
        public void checkPreConditions(StandaloneCandidacyProcess process2, User userView) {
            if (!StandaloneCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneCandidacyProcess executeActivity(StandaloneCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            process2.edit(bean.getStart(), bean.getEnd());
            return process2;
        }
    }

    @StartActivity
    public static class CreateCandidacyPeriod
    extends Activity<StandaloneCandidacyProcess> {
        @Override
        public void checkPreConditions(StandaloneCandidacyProcess process2, User userView) {
            if (!StandaloneCandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneCandidacyProcess executeActivity(StandaloneCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            return new StandaloneCandidacyProcess((ExecutionSemester)((Object)bean.getExecutionInterval()), bean.getStart(), bean.getEnd());
        }
    }
}

