/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate$callable$sendEmailFor;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate$callable$sendMultiEmailFor;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate_Base;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MobilityEmailTemplate
extends MobilityEmailTemplate_Base {
    public static final Advice advice$sendEmailFor = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$sendMultiEmailFor = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected MobilityEmailTemplate(MobilityApplicationPeriod period, MobilityProgram program, MobilityEmailTemplateType type, String subject, String body) {
        this.setRootDomainObject(Bennu.getInstance());
        this.checkParameters(period, program, type, subject, body);
        this.setPeriod(period);
        this.setMobilityProgram(program);
        this.setType(type);
        this.setSubject(subject);
        this.setBody(body);
    }

    private void checkParameters(MobilityApplicationPeriod period, MobilityProgram program, MobilityEmailTemplateType type, String subject, String body) {
        if (period == null) {
            throw new DomainException("error.mobility.MobilityEmailTemplate.period.is.required", new String[0]);
        }
        if (program == null) {
            throw new DomainException("error.mobility.MobilityEmailTemplate.program.is.required", new String[0]);
        }
        if (period.hasEmailTemplateFor(program, type) && period.getEmailTemplateFor(program, type) != this) {
            throw new DomainException("error.mobility.MobilityEmailTemplate.for.type.already.exists", new String[0]);
        }
        if (StringUtils.isEmpty((String)subject)) {
            throw new DomainException("error.mobility.MobilityEmailTemplate.subject.is.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)body)) {
            throw new DomainException("error.mobility.MobilityEmailTemplate.body.is.required", new String[0]);
        }
    }

    public void update(String subject, String body) {
        this.checkParameters(this.getPeriod(), this.getMobilityProgram(), this.getType(), subject, body);
        this.setSubject(subject);
        this.setBody(body);
    }

    public void delete() {
        this.setMobilityProgram(null);
        this.setPeriod(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void sendEmailFor(DegreeOfficePublicCandidacyHashCode degreeOfficePublicCandidacyHashCode) {
        Object object = advice$sendEmailFor.perform((Callable)new MobilityEmailTemplate$callable$sendEmailFor(this, degreeOfficePublicCandidacyHashCode));
    }

    static /* synthetic */ void advised$sendEmailFor(MobilityEmailTemplate this_, DegreeOfficePublicCandidacyHashCode hashCode) {
        this_.getType().sendEmailFor(this_, hashCode);
    }

    public void sendMultiEmailFor(Collection<MobilityIndividualApplicationProcess> collection) {
        Object object = advice$sendMultiEmailFor.perform((Callable)new MobilityEmailTemplate$callable$sendMultiEmailFor(this, collection));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$sendMultiEmailFor(MobilityEmailTemplate this_, Collection processes) {
        this_.getType().sendMultiEmailFor(this_, processes);
    }

    public String getSubjectFor(MobilityIndividualApplicationProcess process2) {
        return this.getSubject();
    }

    public String getBodyFor(MobilityIndividualApplicationProcess process2) {
        return this.getBody();
    }

    public static MobilityEmailTemplate create(MobilityApplicationPeriod period, MobilityProgram program, MobilityEmailTemplateType type, String subject, String body) {
        return new MobilityEmailTemplate(period, program, type, subject, body);
    }

    public boolean isFor(MobilityProgram program, MobilityEmailTemplateType type) {
        return this.getMobilityProgram() == program && this.getType().equals((Object)type);
    }
}

