/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.workflow;

import java.util.Comparator;
import java.util.Set;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacyOperationType;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.util.workflow.IStateWithOperations;
import org.fenixedu.academic.domain.util.workflow.Operation;

public abstract class CandidacyOperation
extends Operation {
    public static Comparator<CandidacyOperation> COMPARATOR_BY_TYPE = new Comparator<CandidacyOperation>(){

        @Override
        public int compare(CandidacyOperation leftCandidacyOperation, CandidacyOperation rightCandidacyOperation) {
            return leftCandidacyOperation.getType().compareTo(rightCandidacyOperation.getType());
        }
    };
    private Candidacy candidacy;

    protected CandidacyOperation(Set<RoleType> roleTypes, Candidacy candidacy) {
        super(roleTypes);
        this.setCandidacy(candidacy);
    }

    public Candidacy getCandidacy() {
        return this.candidacy;
    }

    private void setCandidacy(Candidacy candidacy) {
        this.candidacy = candidacy;
    }

    @Override
    public IStateWithOperations getState() {
        return this.getCandidacy().getActiveCandidacySituation();
    }

    @Override
    public int compareTo(Operation operation) {
        return ((CandidacyOperation)operation).getType().compareTo(this.getType());
    }

    public abstract CandidacyOperationType getType();
}

