/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.util.Comparator;
import org.fenixedu.academic.domain.candidacy.MeasurementTestRoom_Base;
import org.fenixedu.academic.domain.candidacy.MeasurementTestShift;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.spaces.domain.Space;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class MeasurementTestRoom
extends MeasurementTestRoom_Base {
    public static Comparator<MeasurementTestRoom> COMPARATOR_BY_ROOM_ORDER;

    protected MeasurementTestRoom() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public MeasurementTestRoom(String name, Integer capacity, MeasurementTestShift shift) {
        this();
        String[] args = new String[]{};
        if (shift == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTestRoom.shift.cannot.be.null", args);
        }
        String[] args2 = new String[]{};
        if (name == null || name.isEmpty()) {
            throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTestRoom.name.cannot.be.null", args2);
        }
        String[] args1 = new String[]{};
        if (capacity == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTestRoom.capacity.cannot.be.null", args1);
        }
        this.setRoomOrder(shift.getRoomsSet().size() + 1);
        this.setShift(shift);
        this.setName(name);
        this.setCapacity(capacity);
    }

    public boolean isAvailable() {
        return this.getCapacity() - this.getRegistrationsSet().size() > 0;
    }

    public Space getCampus() {
        return this.getShift().getTest().getCampus();
    }

    static {
        MeasurementTestRoom.getRelationMeasurementTestShiftMeasurementTestRoom().addListener((RelationListener)new RelationAdapter<MeasurementTestShift, MeasurementTestRoom>(){

            public void beforeAdd(MeasurementTestShift shift, MeasurementTestRoom toAdd) {
                if (toAdd != null && shift != null && shift.getRoomByName(toAdd.getName()) != null) {
                    throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTestShift.already.contains.room.with.same.name", new String[0]);
                }
            }
        });
        COMPARATOR_BY_ROOM_ORDER = new Comparator<MeasurementTestRoom>(){

            @Override
            public int compare(MeasurementTestRoom leftMeasurementTestRoom, MeasurementTestRoom rightMeasurementTestRoom) {
                return leftMeasurementTestRoom.getRoomOrder().compareTo(rightMeasurementTestRoom.getRoomOrder());
            }
        };
    }
}

