/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.AcademicServiceRequestEvent;
import org.fenixedu.academic.domain.accounting.report.events.Wrapper;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.MultiLanguageString;

public class AcademicServiceRequestEventWrapper
implements Wrapper {
    private final AcademicServiceRequestEvent event;
    private final AcademicServiceRequest request;

    public AcademicServiceRequestEventWrapper(AcademicServiceRequestEvent event) {
        this.event = event;
        this.request = event.getAcademicServiceRequest();
    }

    @Override
    public String getStudentNumber() {
        if (this.request.getPerson().getStudent() != null) {
            return this.request.getPerson().getStudent().getNumber().toString();
        }
        return "--";
    }

    @Override
    public String getStudentName() {
        return this.request.getPerson().getName();
    }

    @Override
    public String getStudentEmail() {
        return this.event.getPerson().getDefaultEmailAddressValue();
    }

    @Override
    public String getRegistrationStartDate() {
        if (this.request.isRequestForRegistration()) {
            return ((RegistrationAcademicServiceRequest)((Object)this.request)).getRegistration().getStartDate().toString("dd/MM/yyyy");
        }
        return "--";
    }

    @Override
    public String getExecutionYear() {
        return this.getForExecutionYear().getName();
    }

    @Override
    public String getDegreeName() {
        if (this.request.isRequestForRegistration()) {
            return ((RegistrationAcademicServiceRequest)((Object)this.request)).getRegistration().getDegree().getNameI18N().getContent(MultiLanguageString.pt);
        }
        return "--";
    }

    @Override
    public String getDegreeType() {
        if (this.request.isRequestForRegistration()) {
            return ((RegistrationAcademicServiceRequest)((Object)this.request)).getRegistration().getDegreeType().getName().getContent();
        }
        return "--";
    }

    @Override
    public String getPhdProgramName() {
        if (this.request.isRequestForPhd()) {
            return ((PhdAcademicServiceRequest)((Object)this.request)).getPhdIndividualProgramProcess().getPhdProgram().getName().getContent(MultiLanguageString.pt);
        }
        return "--";
    }

    @Override
    public String getEnrolledECTS() {
        if (this.request.isRequestForRegistration()) {
            Registration registration = ((RegistrationAcademicServiceRequest)((Object)this.request)).getRegistration();
            ExecutionYear executionYear = ExecutionYear.readByDateTime(this.request.getCreationDate());
            return new BigDecimal(registration.getEnrolmentsEcts(executionYear)).toString();
        }
        return "--";
    }

    @Override
    public String getRegime() {
        if (this.request.isRequestForRegistration()) {
            Registration registration = ((RegistrationAcademicServiceRequest)((Object)this.request)).getRegistration();
            ExecutionYear executionYear = ExecutionYear.readByDateTime(this.request.getCreationDate());
            return registration.getRegimeType(executionYear).getLocalizedName();
        }
        return "--";
    }

    @Override
    public String getEnrolmentModel() {
        ExecutionYear executionYear;
        Registration registration;
        if (this.request.isRequestForRegistration() && (registration = ((RegistrationAcademicServiceRequest)((Object)this.request)).getRegistration()).getEnrolmentModelForExecutionYear(executionYear = ExecutionYear.readByDateTime(this.request.getCreationDate())) != null) {
            return registration.getEnrolmentModelForExecutionYear(executionYear).getLocalizedName();
        }
        return "--";
    }

    @Override
    public String getResidenceYear() {
        return "--";
    }

    @Override
    public String getResidenceMonth() {
        return "--";
    }

    @Override
    public String getStudiesType() {
        if (this.request.isRequestForRegistration()) {
            return "Curso";
        }
        if (this.request.isRequestForPhd()) {
            return "Programa Doutoral";
        }
        return "--";
    }

    @Override
    public String getTotalDiscount() {
        return this.event.getTotalDiscount().toPlainString();
    }

    @Override
    public boolean isAfterOrEqualExecutionYear(ExecutionYear executionYear) {
        return !ExecutionYear.readByDateTime(this.request.getCreationDate()).isBefore(executionYear);
    }

    @Override
    public ExecutionYear getForExecutionYear() {
        return ExecutionYear.readByDateTime(this.request.getCreationDate());
    }

    @Override
    public AdministrativeOffice getRelatedAcademicOffice() {
        return this.event.getAdministrativeOffice();
    }

    @Override
    public String getRelatedEventExternalId() {
        return "--";
    }

    @Override
    public String getDebtorFiscalId() {
        return "--";
    }

    @Override
    public String getDebtorName() {
        return "--";
    }
}

