<%--

    Copyright © 2002 Instituto Superior Técnico

    This file is part of FenixEdu Academic.

    FenixEdu Academic is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FenixEdu Academic is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with FenixEdu Academic.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<html:xhtml/>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://fenix-ashes.ist.utl.pt/fenix-renderers" prefix="fr" %>

<h2><bean:message bundle="ACADEMIC_OFFICE_RESOURCES" key="label.payments.guide"/></h2>

<p class="mtop15 mbottom05"><strong><bean:message bundle="ACADEMIC_OFFICE_RESOURCES" key="label.payments.person"/></strong></p>
<fr:view name="paymentsManagementDTO" property="person"
	schema="person.view-with-name-and-idDocumentType-and-documentIdNumber">
	<fr:layout name="tabular">
		<fr:property name="classes" value="tstyle2 thlight thright mtop05" />
		<fr:property name="rowClasses" value="tdhl1,," />
	</fr:layout>
</fr:view>


<p class="mbottom05"><strong><bean:message bundle="ACADEMIC_OFFICE_RESOURCES" key="label.payments"/></strong></p>
<logic:notEmpty name="paymentsManagementDTO" property="selectedEntries">

	<fr:view name="paymentsManagementDTO" property="selectedEntries" schema="entryDTO.view">
		<fr:layout name="tabular" >
			<fr:property name="classes" value="tstyle4 mtop05 mbottom0" />
			<fr:property name="columnClasses" value="width30em acenter,width15em aright"/>
		</fr:layout>
	</fr:view>

	<table class="tstyle4 mtop0">
		<tr>
			<td class="width30em"></td>
			<td class="width15em aright" style="background-color: #fdfbdd;"><bean:message bundle="ACADEMIC_OFFICE_RESOURCES" key="label.payments.totalAmount"/>: <bean:write name="paymentsManagementDTO" property="totalAmountToPay" />&nbsp;<bean:message bundle="ACADEMIC_OFFICE_RESOURCES" key="label.payments.currencySymbol"/></td>
		</tr>
	</table>


	<html:form action="/guides.do" target="_blank">
		<html:hidden bundle="HTMLALT_RESOURCES" altKey="hidden.method" property="method" />
		<fr:edit id="paymentsManagementDTO" name="paymentsManagementDTO" visible="false"/>
		<html:submit bundle="HTMLALT_RESOURCES" altKey="submit.submit" onclick="this.form.method.value='printGuide';"><bean:message bundle="ACADEMIC_OFFICE_RESOURCES" key="label.payments.print"/></html:submit>
	</html:form>
	
</logic:notEmpty>


<logic:empty name="paymentsManagementDTO" property="selectedEntries">
	<span class="error"><!-- Error messages go here --><bean:message bundle="ACADEMIC_OFFICE_RESOURCES" key="label.payments.not.found"/></span>
</logic:empty>
