/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util.date;

import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;

public class SerializationTool {
    public static String yearMonthDaySerialize(YearMonthDay yearMonthDay) {
        if (yearMonthDay != null) {
            String dateString = String.format("%04d-%02d-%02d", yearMonthDay.get(DateTimeFieldType.year()), yearMonthDay.get(DateTimeFieldType.monthOfYear()), yearMonthDay.get(DateTimeFieldType.dayOfMonth()));
            return dateString;
        }
        return null;
    }

    public static YearMonthDay yearMonthDayDeserialize(String string) {
        if (!StringUtils.isEmpty((String)string)) {
            int year = Integer.parseInt(string.substring(0, 4));
            int month = Integer.parseInt(string.substring(5, 7));
            int day = Integer.parseInt(string.substring(8, 10));
            return year == 0 || month == 0 || day == 0 ? null : new YearMonthDay(year, month, day);
        }
        return null;
    }

    public static String intervalSerialize(Interval interval) {
        return interval.toString();
    }

    public static Interval intervalDeserialize(String string) {
        if (!StringUtils.isEmpty((String)string)) {
            String[] parts = string.split("/");
            DateTime start = new DateTime((Object)parts[0]);
            DateTime end = new DateTime((Object)parts[1]);
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
        return null;
    }
}

