/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.TimeOfDay;
import org.joda.time.base.BasePartial;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISODateTimeFormat;

public final class HourMinuteSecond
extends BasePartial
implements ReadablePartial,
Serializable {
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute()};
    public static final int HOUR_OF_DAY = 0;
    public static final int MINUTE_OF_HOUR = 1;
    public static final int SECOND_OF_MINUTE = 2;

    public static HourMinuteSecond fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new HourMinuteSecond(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static HourMinuteSecond fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new HourMinuteSecond(date.getHours(), date.getMinutes(), date.getSeconds());
    }

    public HourMinuteSecond() {
    }

    public HourMinuteSecond(Chronology chronology) {
        super(chronology);
    }

    public HourMinuteSecond(long instant) {
        super(instant);
    }

    public HourMinuteSecond(long instant, Chronology chronology) {
        super(instant, chronology);
    }

    public HourMinuteSecond(Object instant, Chronology chronology) {
        super(instant, DateTimeUtils.getChronology((Chronology)chronology));
    }

    public HourMinuteSecond(Object instant) {
        super(instant, null);
    }

    public HourMinuteSecond(int hour, int minute, int second) {
        this(hour, minute, second, null);
    }

    public HourMinuteSecond(int hour, int minute, int second, Chronology chronology) {
        super(new int[]{hour, minute, second}, chronology);
    }

    public HourMinuteSecond(int[] values, Chronology chronology) {
        super(values, chronology);
    }

    public HourMinuteSecond(BasePartial partial, int[] values) {
        super(partial, values);
    }

    public HourMinuteSecond(BasePartial partial, Chronology chrono) {
        super(partial, chrono);
    }

    public int size() {
        return 3;
    }

    protected DateTimeField getField(int index, Chronology chrono) {
        switch (index) {
            case 0: {
                return chrono.hourOfDay();
            }
            case 1: {
                return chrono.minuteOfHour();
            }
            case 2: {
                return chrono.secondOfMinute();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    public DateTimeFieldType getFieldType(int index) {
        return FIELD_TYPES[index];
    }

    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public HourMinuteSecond withChronologyRetainFields(Chronology newChronology) {
        newChronology = DateTimeUtils.getChronology((Chronology)newChronology);
        if ((newChronology = newChronology.withUTC()) == this.getChronology()) {
            return this;
        }
        HourMinuteSecond newHourMinuteSecond = new HourMinuteSecond((BasePartial)this, newChronology);
        newChronology.validate((ReadablePartial)newHourMinuteSecond, this.getValues());
        return newHourMinuteSecond;
    }

    public HourMinuteSecond withField(DateTimeFieldType fieldType, int value) {
        int index = this.indexOfSupported(fieldType);
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set((ReadablePartial)this, index, newValues, value);
        return new HourMinuteSecond((BasePartial)this, newValues);
    }

    public HourMinuteSecond withFieldAdded(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).add((ReadablePartial)this, index, newValues, amount);
        return new HourMinuteSecond((BasePartial)this, newValues);
    }

    public HourMinuteSecond withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        for (int i = 0; i < period.size(); ++i) {
            DurationFieldType fieldType = period.getFieldType(i);
            int index = this.indexOf(fieldType);
            if (index < 0) continue;
            newValues = this.getField(index).add((ReadablePartial)this, index, newValues, FieldUtils.safeMultiply((int)period.getValue(i), (int)scalar));
        }
        return new HourMinuteSecond((BasePartial)this, newValues);
    }

    public HourMinuteSecond plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public HourMinuteSecond plusHours(int hours) {
        return this.withFieldAdded(DurationFieldType.hours(), hours);
    }

    public HourMinuteSecond plusMinutes(int minutes) {
        return this.withFieldAdded(DurationFieldType.minutes(), minutes);
    }

    public HourMinuteSecond plusSeconds(int seconds) {
        return this.withFieldAdded(DurationFieldType.seconds(), seconds);
    }

    public HourMinuteSecond minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public HourMinuteSecond minusHours(int hours) {
        return this.withFieldAdded(DurationFieldType.hours(), FieldUtils.safeNegate((int)hours));
    }

    public HourMinuteSecond minusMinutes(int minutes) {
        return this.withFieldAdded(DurationFieldType.minutes(), FieldUtils.safeNegate((int)minutes));
    }

    public HourMinuteSecond minusSeconds(int seconds) {
        return this.withFieldAdded(DurationFieldType.seconds(), FieldUtils.safeNegate((int)seconds));
    }

    public Property property(DateTimeFieldType type) {
        return new Property(this, this.indexOfSupported(type));
    }

    public DateTime toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    public DateTime toDateTimeAtMidnight(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        return new DateTime(0, 0, 0, 0, 0, 0, 0, chrono);
    }

    public DateTime toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public DateTime toDateTimeAtCurrentTime(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        long instantMillis = DateTimeUtils.currentTimeMillis();
        long resolved = chrono.set((ReadablePartial)this, instantMillis);
        return new DateTime(resolved, chrono);
    }

    public DateMidnight toDateMidnight() {
        return this.toDateMidnight(null);
    }

    public DateMidnight toDateMidnight(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        return new DateMidnight(0, 0, 0, chrono);
    }

    public DateTime toDateTime(TimeOfDay time) {
        return this.toDateTime(time, null);
    }

    public DateTime toDateTime(TimeOfDay time, DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        long instant = DateTimeUtils.currentTimeMillis();
        instant = chrono.set((ReadablePartial)this, instant);
        if (time != null) {
            instant = chrono.set((ReadablePartial)time, instant);
        }
        return new DateTime(instant, chrono);
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public Interval toInterval(DateTimeZone zone) {
        zone = DateTimeUtils.getZone((DateTimeZone)zone);
        return this.toDateMidnight(zone).toInterval();
    }

    public LocalTime toLocalTime() {
        return new LocalTime(this.getHour(), this.getMinuteOfHour(), this.getSecondOfMinute());
    }

    public static HourMinuteSecond fromLocalTime(LocalTime time) {
        return new HourMinuteSecond(time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute());
    }

    public int getHour() {
        return this.getValue(0);
    }

    public int getMinuteOfHour() {
        return this.getValue(1);
    }

    public int getSecondOfMinute() {
        return this.getValue(2);
    }

    public Property hour() {
        return new Property(this, 0);
    }

    public Property minuteOfHour() {
        return new Property(this, 1);
    }

    public Property secondOfMinute() {
        return new Property(this, 2);
    }

    public String toString() {
        return ISODateTimeFormat.hourMinuteSecond().print((ReadablePartial)this);
    }

    public HourMinuteSecond setSecondOfMinute(int seconds) {
        return new HourMinuteSecond(this.getHour(), this.getMinuteOfHour(), seconds);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5727734012190224363L;
        private final HourMinuteSecond iHourMinuteSecond;
        private final int iFieldIndex;

        Property(HourMinuteSecond partial, int fieldIndex) {
            this.iHourMinuteSecond = partial;
            this.iFieldIndex = fieldIndex;
        }

        public DateTimeField getField() {
            return this.iHourMinuteSecond.getField(this.iFieldIndex);
        }

        protected ReadablePartial getReadablePartial() {
            return this.iHourMinuteSecond;
        }

        public HourMinuteSecond getHourMinuteSecond() {
            return this.iHourMinuteSecond;
        }

        public int get() {
            return this.iHourMinuteSecond.getValue(this.iFieldIndex);
        }

        public HourMinuteSecond addToCopy(int valueToAdd) {
            int[] newValues = this.iHourMinuteSecond.getValues();
            newValues = this.getField().add((ReadablePartial)this.iHourMinuteSecond, this.iFieldIndex, newValues, valueToAdd);
            return new HourMinuteSecond((BasePartial)this.iHourMinuteSecond, newValues);
        }

        public HourMinuteSecond addWrapFieldToCopy(int valueToAdd) {
            int[] newValues = this.iHourMinuteSecond.getValues();
            newValues = this.getField().addWrapField((ReadablePartial)this.iHourMinuteSecond, this.iFieldIndex, newValues, valueToAdd);
            return new HourMinuteSecond((BasePartial)this.iHourMinuteSecond, newValues);
        }

        public HourMinuteSecond setCopy(int value) {
            int[] newValues = this.iHourMinuteSecond.getValues();
            newValues = this.getField().set((ReadablePartial)this.iHourMinuteSecond, this.iFieldIndex, newValues, value);
            return new HourMinuteSecond((BasePartial)this.iHourMinuteSecond, newValues);
        }

        public HourMinuteSecond setCopy(String text, Locale locale) {
            int[] newValues = this.iHourMinuteSecond.getValues();
            newValues = this.getField().set((ReadablePartial)this.iHourMinuteSecond, this.iFieldIndex, newValues, text, locale);
            return new HourMinuteSecond((BasePartial)this.iHourMinuteSecond, newValues);
        }

        public HourMinuteSecond setCopy(String text) {
            return this.setCopy(text, null);
        }

        public HourMinuteSecond withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public HourMinuteSecond withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

