/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public class CurricularRuleLabelFormatter {
    public static String getLabel(ICurricularRule curricularRule) {
        return CurricularRuleLabelFormatter.buildLabel(curricularRule, I18N.getLocale());
    }

    public static String getLabel(ICurricularRule curricularRule, Locale locale) {
        return CurricularRuleLabelFormatter.buildLabel(curricularRule, locale);
    }

    private static String buildLabel(ICurricularRule curricularRule, Locale locale) {
        List<GenericPair<Object, Boolean>> labelList = curricularRule.getLabel();
        StringBuilder labelResult = new StringBuilder();
        for (GenericPair<Object, Boolean> labelElement : labelList) {
            if (labelElement.getRight().booleanValue()) {
                labelResult.append(BundleUtil.getString((String)"resources.BolonhaManagerResources", (Locale)locale, (String)labelElement.getLeft().toString(), (String[])new String[0]));
                continue;
            }
            labelResult.append(labelElement.getLeft());
        }
        return labelResult.toString();
    }
}

