/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.scientificCouncil.thesis;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.Serializable;
import java.util.SortedSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.domain.thesis.ThesisFile;
import org.fenixedu.academic.domain.thesis.ThesisParticipationType;
import org.fenixedu.academic.domain.thesis.ThesisVisibilityType;
import org.fenixedu.academic.report.thesis.StudentThesisIdentificationDocument;
import org.fenixedu.academic.report.thesis.ThesisJuryReportDocument;
import org.fenixedu.academic.service.services.scientificCouncil.thesis.ApproveThesisDiscussion;
import org.fenixedu.academic.service.services.scientificCouncil.thesis.ApproveThesisProposal;
import org.fenixedu.academic.service.services.thesis.ChangeThesisPerson;
import org.fenixedu.academic.service.services.thesis.CreateThesisAbstractFile;
import org.fenixedu.academic.service.services.thesis.CreateThesisDissertationFile;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.ScientificCouncilApplication;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.thesis.ManageSecondCycleThesisSearchBean;
import org.fenixedu.academic.ui.struts.action.student.thesis.ThesisFileBean;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ScientificCouncilApplication.ScientificDisserationsApp.class, path="list-new", titleKey="navigation.list.jury.proposals.new")
@Mapping(path="/manageSecondCycleThesis", module="scientificCouncil")
@Forwards(value={@Forward(name="firstPage", path="/scientificCouncil/thesis/firstPage.jsp"), @Forward(name="showPersonThesisDetails", path="/scientificCouncil/thesis/showPersonThesisDetails.jsp"), @Forward(name="showThesisDetails", path="/scientificCouncil/thesis/showThesisDetails.jsp"), @Forward(name="editThesisEvaluationParticipant", path="/scientificCouncil/thesis/editThesisEvaluationParticipant.jsp"), @Forward(name="editThesisDetails", path="/scientificCouncil/thesis/editThesisDetails.jsp"), @Forward(name="addJuryMember", path="/scientificCouncil/thesis/addJuryMember.jsp"), @Forward(name="addExternalOrientationMember", path="/scientificCouncil/thesis/addExternalOrientationMember.jsp"), @Forward(name="addOrientationMember", path="/scientificCouncil/thesis/addOrientationMember.jsp")})
public class ManageSecondCycleThesisDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward firstPage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.firstPage(new ManageSecondCycleThesisSearchBean(), mapping, request, response);
    }

    public ActionForward firstPage(ManageSecondCycleThesisSearchBean filterSearchForm, ActionMapping mapping, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SortedSet<Enrolment> enrolments = filterSearchForm.findEnrolments();
        request.setAttribute("enrolments", enrolments);
        request.setAttribute("manageSecondCycleThesisSearchBean", (Object)filterSearchForm);
        return mapping.findForward("firstPage");
    }

    public ActionForward filterSearch(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ManageSecondCycleThesisSearchBean filterSearchForm = (ManageSecondCycleThesisSearchBean)this.getRenderedObject("filterSearchForm");
        return this.firstPage(filterSearchForm, mapping, request, response);
    }

    public ActionForward searchPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ManageSecondCycleThesisSearchBean searchPersonForm = (ManageSecondCycleThesisSearchBean)this.getRenderedObject("searchPersonForm");
        SortedSet<Person> people = searchPersonForm.findPersonBySearchString();
        if (people.size() == 1) {
            Person person = people.first();
            return this.showPersonThesisDetails(mapping, request, person);
        }
        request.setAttribute("people", people);
        return this.firstPage(searchPersonForm, mapping, request, response);
    }

    public ActionForward showPersonThesisDetails(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = (Person)((Object)this.getDomainObject(request, "personOid"));
        return this.showPersonThesisDetails(mapping, request, person);
    }

    public ActionForward showPersonThesisDetails(ActionMapping mapping, HttpServletRequest request, Person person) throws Exception {
        request.setAttribute("person", (Object)person);
        return mapping.findForward("showPersonThesisDetails");
    }

    public ActionForward showThesisDetails(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        return this.showThesisDetails(mapping, request, thesis);
    }

    public ActionForward rejectThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        RejectionCommentBean rejectionCommentBean = (RejectionCommentBean)this.getRenderedObject();
        try {
            thesis.rejectProposal(rejectionCommentBean.getComment());
            this.addActionMessage("success", request, "message.thesis.reject.success");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
        }
        RenderUtils.invalidateViewState();
        return this.showThesisDetails(mapping, request, thesis);
    }

    private ActionForward showThesisDetails(ActionMapping mapping, HttpServletRequest request, Thesis thesis) throws Exception {
        if (!thesis.areThesisFilesReadable()) {
            ThesisFile thesisFile = thesis.getDissertation();
            ThesisFileBean thesisDissertationFileBean = new ThesisFileBean(thesis);
            if (thesisFile != null) {
                thesisDissertationFileBean.setTitle(thesisFile.getTitle());
                thesisDissertationFileBean.setSubTitle(thesisFile.getSubTitle());
                thesisDissertationFileBean.setLanguage(thesisFile.getLanguage());
            }
            request.setAttribute("thesisDissertationFileBean", (Object)thesisDissertationFileBean);
            ThesisFileBean thesisExtendendAbstractFileBean = new ThesisFileBean(thesis);
            request.setAttribute("thesisExtendendAbstractFileBean", (Object)thesisExtendendAbstractFileBean);
        }
        request.setAttribute("rejectionCommentBean", (Object)new RejectionCommentBean());
        request.setAttribute("thesis", (Object)thesis);
        return mapping.findForward("showThesisDetails");
    }

    public ActionForward editThesisEvaluationParticipant(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisEvaluationParticipant thesisEvaluationParticipant = (ThesisEvaluationParticipant)((Object)this.getDomainObject(request, "thesisEvaluationParticipantOid"));
        request.setAttribute("thesisEvaluationParticipant", (Object)thesisEvaluationParticipant);
        return mapping.findForward("editThesisEvaluationParticipant");
    }

    public ActionForward removeThesisEvaluationParticipant(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisEvaluationParticipant thesisEvaluationParticipant = (ThesisEvaluationParticipant)((Object)this.getDomainObject(request, "thesisEvaluationParticipantOid"));
        Thesis thesis = thesisEvaluationParticipant.getThesis();
        ChangeThesisPerson.remove(thesisEvaluationParticipant);
        return this.showThesisDetails(mapping, request, thesis);
    }

    public ActionForward editThesisDetails(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        request.setAttribute("thesis", (Object)thesis);
        return mapping.findForward("editThesisDetails");
    }

    public ActionForward changeThesisFilesVisibility(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        thesis.swapFilesVisibility();
        return this.showThesisDetails(mapping, request, thesis);
    }

    public ActionForward prepareAddJuryMember(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        request.setAttribute("thesis", (Object)thesis);
        EvaluationMemberBean evaluationMemberBean = (EvaluationMemberBean)this.getRenderedObject();
        if (evaluationMemberBean == null) {
            evaluationMemberBean = request.getParameter("external") == null ? new InternalEvaluationMemberBean() : new ExternalEvaluationMemberBean();
        }
        request.setAttribute("evaluationMemberBean", (Object)evaluationMemberBean);
        return mapping.findForward("addJuryMember");
    }

    public ActionForward prepareAddOrientationMember(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        request.setAttribute("thesis", (Object)thesis);
        EvaluationMemberBean evaluationMemberBean = (EvaluationMemberBean)this.getRenderedObject();
        if (evaluationMemberBean == null) {
            evaluationMemberBean = request.getParameter("external") == null ? new InternalEvaluationMemberBean() : new ExternalEvaluationMemberBean();
        }
        request.setAttribute("evaluationMemberBean", (Object)evaluationMemberBean);
        return mapping.findForward("addOrientationMember");
    }

    public ActionForward prepareAddExternalOrientationMember(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        request.setAttribute("thesis", (Object)thesis);
        EvaluationMemberBean evaluationMemberBean = (EvaluationMemberBean)this.getRenderedObject();
        if (evaluationMemberBean == null) {
            evaluationMemberBean = new ExternalEvaluationMemberBean();
        }
        request.setAttribute("evaluationMemberBean", (Object)evaluationMemberBean);
        return mapping.findForward("addExternalOrientationMember");
    }

    public ActionForward addEvaluationMember(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        EvaluationMemberBean evaluationMemberBean = (EvaluationMemberBean)this.getRenderedObject();
        evaluationMemberBean.addMember(thesis);
        return this.showThesisDetails(mapping, request, thesis);
    }

    public ActionForward makeDocumentUnavailable(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        FenixFramework.atomic(() -> thesis.setVisibility(null));
        return this.showThesisDetails(mapping, request, thesis);
    }

    public ActionForward makeDocumentAvailable(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        FenixFramework.atomic(() -> thesis.setVisibility(ThesisVisibilityType.INTRANET));
        return this.showThesisDetails(mapping, request, thesis);
    }

    public ActionForward substituteDissertation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.substituteDocument(mapping, request, true);
    }

    public ActionForward substituteExtendedAbstract(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.substituteDocument(mapping, request, false);
    }

    public ActionForward substituteDocument(ActionMapping mapping, HttpServletRequest request, boolean dissertationFile) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        ThesisFileBean bean = (ThesisFileBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        if (thesis.getVisibility() == null) {
            this.atomic(() -> thesis.setVisibility(ThesisVisibilityType.INTRANET));
        }
        if (bean != null && bean.getFile() != null) {
            if (thesis.getTitle() == null) {
                throw new DomainException("thesis.files.dissertation.title.required", new String[0]);
            }
            bean.setTitle(thesis.getTitle().toString());
            byte[] bytes = ByteStreams.toByteArray((InputStream)bean.getFile());
            if (dissertationFile) {
                CreateThesisDissertationFile.runCreateThesisDissertationFile(thesis, bytes, bean.getSimpleFileName(), bean.getTitle(), bean.getSubTitle(), bean.getLanguage());
            } else {
                CreateThesisAbstractFile.runCreateThesisAbstractFile(thesis, bytes, bean.getSimpleFileName(), bean.getTitle(), bean.getSubTitle(), bean.getLanguage());
            }
        }
        return this.showThesisDetails(mapping, request, thesis);
    }

    public ActionForward approveThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        try {
            ApproveThesisDiscussion.runApproveThesisDiscussion(thesis);
            this.addActionMessage("mail", request, "thesis.evaluated.mail.sent");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
        }
        return this.showThesisDetails(mapping, request, thesis);
    }

    public ActionForward approveProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        try {
            ApproveThesisProposal.runApproveThesisProposal(thesis);
            this.addActionMessage("mail", request, "thesis.approved.mail.sent");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
        }
        return this.showThesisDetails(mapping, request, thesis);
    }

    public ActionForward downloadIdentificationSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        try {
            StudentThesisIdentificationDocument document = new StudentThesisIdentificationDocument(thesis);
            byte[] data = ReportsUtils.generateReport(document).getData();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", document.getReportFileName()));
            response.getOutputStream().write(data);
            return null;
        }
        catch (Exception e) {
            this.addActionMessage("error", request, "student.thesis.generate.identification.failed");
            return this.showThesisDetails(mapping, request, thesis);
        }
    }

    public ActionForward downloadJuryReportSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisOid"));
        try {
            ThesisJuryReportDocument document = new ThesisJuryReportDocument(thesis);
            byte[] data = ReportsUtils.generateReport(document).getData();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", document.getReportFileName()));
            response.getOutputStream().write(data);
            return null;
        }
        catch (Exception e) {
            this.addActionMessage("error", request, "student.thesis.generate.juryreport.failed");
            return this.showThesisDetails(mapping, request, thesis);
        }
    }

    public static class RejectionCommentBean
    implements Serializable {
        String comment;

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    public static class ExternalEvaluationMemberBean
    extends EvaluationMemberBean {
        String personName;
        String personEmail;

        public String getPersonName() {
            return this.personName;
        }

        public void setPersonName(String personName) {
            this.personName = personName;
        }

        public String getPersonEmail() {
            return this.personEmail;
        }

        public void setPersonEmail(String personEmail) {
            this.personEmail = personEmail;
        }

        @Override
        public void addMember(Thesis thesis) {
            ChangeThesisPerson.addExternal(thesis, this.thesisParticipationType, this.getPersonName(), this.getPersonEmail());
        }
    }

    public static class InternalEvaluationMemberBean
    extends EvaluationMemberBean {
        Person person;
        Unit unit;

        public Person getPerson() {
            return this.person;
        }

        public void setPerson(Person person) {
            this.person = person;
        }

        public Unit getUnit() {
            return this.unit;
        }

        public void setUnit(Unit unit) {
            this.unit = unit;
        }

        @Override
        public void addMember(Thesis thesis) {
            ChangeThesisPerson.add(thesis, this.thesisParticipationType, this.person);
        }
    }

    public static abstract class EvaluationMemberBean
    implements Serializable {
        ThesisParticipationType thesisParticipationType;

        public ThesisParticipationType getThesisParticipationType() {
            return this.thesisParticipationType;
        }

        public void setThesisParticipationType(ThesisParticipationType thesisParticipationType) {
            this.thesisParticipationType = thesisParticipationType;
        }

        public abstract void addMember(Thesis var1);
    }
}

