/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.resourceAllocationManager.PeriodsManagementBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=RAMApplication.RAMPeriodsApp.class, path="manage", titleKey="label.occupation.period.management")
@Mapping(path="/periods", module="resourceAllocationManager")
@Forwards(value={@Forward(name="managePeriods", path="/resourceAllocationManager/periods/managePeriods.jsp")})
public class PeriodsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward managePeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PeriodsManagementBean bean = (PeriodsManagementBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        if (bean == null) {
            bean = new PeriodsManagementBean();
        } else {
            try {
                this.updateBean(request, bean);
            }
            catch (DomainException e) {
                this.addActionMessage("error", request, e.getKey());
            }
        }
        request.setAttribute("managementBean", (Object)bean);
        return mapping.findForward("managePeriods");
    }

    public ActionForward addNewPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PeriodsManagementBean bean = (PeriodsManagementBean)this.getRenderedObject();
        bean.addNewBean();
        request.setAttribute("managementBean", (Object)bean);
        return mapping.findForward("managePeriods");
    }

    public ActionForward duplicatePeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PeriodsManagementBean bean = (PeriodsManagementBean)this.getRenderedObject();
        try {
            bean.duplicatePeriod(request.getParameter("toDuplicateId"));
            this.addActionMessage("success", request, "label.occupation.period.duplicate.success");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey());
        }
        request.setAttribute("managementBean", (Object)bean);
        return mapping.findForward("managePeriods");
    }

    private void updateBean(HttpServletRequest request, PeriodsManagementBean bean) {
        if (request.getParameter("editPeriod") != null) {
            bean.getBeanById(request.getParameter("periodId")).updateDates(request.getParameter("intervals"));
        } else if (request.getParameter("removePeriod") != null) {
            bean.removePeriod(request.getParameter("removePeriod"));
        } else if (request.getParameter("editPeriodCourses") != null) {
            bean.getBeanById(request.getParameter("periodId")).updateCourses(request.getParameter("courses"));
        } else if (request.getParameter("createPeriod") != null) {
            bean.getBeanById(request.getParameter("periodId")).create(request.getParameter("intervals"), request.getParameter("courses"));
        } else if (request.getParameter("removeNewPeriod") != null) {
            bean.removeNewBean();
        }
    }
}

