/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.validator.DynaValidatorForm;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.InfoClass;
import org.fenixedu.academic.dto.InfoLessonInstanceAggregation;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.service.services.resourceAllocationManager.EditarTurma;
import org.fenixedu.academic.service.services.resourceAllocationManager.LerAulasDeTurma;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadAvailableShiftsForClass;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadShiftByOID;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadShiftsByClass;
import org.fenixedu.academic.service.services.resourceAllocationManager.RemoveShifts;
import org.fenixedu.academic.service.services.resourceAllocationManager.RemoverTurno;
import org.fenixedu.academic.ui.struts.action.exceptions.ExistingActionException;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ExecutionPeriodDA;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.base.FenixClassAndExecutionDegreeAndCurricularYearContextDispatchAction;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/manageClass", module="resourceAllocationManager", formBean="classForm", functionality=ExecutionPeriodDA.class)
@Forwards(value={@Forward(name="EditClass", path="/resourceAllocationManager/manageClass_bd.jsp"), @Forward(name="AddShifts", path="/resourceAllocationManager/addShifts_bd.jsp"), @Forward(name="ViewSchedule", path="/resourceAllocationManager/viewClassSchedule_bd.jsp")})
@Exceptions(value={@ExceptionHandling(handler=FenixErrorExceptionHandler.class, type=ExistingActionException.class, key="resources.Action.exceptions.ExistingActionException", scope="request")})
public class ManageClassDA
extends FenixClassAndExecutionDegreeAndCurricularYearContextDispatchAction {
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InfoClass infoClass = (InfoClass)request.getAttribute("context.classView");
        SchoolClass schoolClass = (SchoolClass)FenixFramework.getDomainObject((String)infoClass.getExternalId());
        request.setAttribute("schoolClass", (Object)schoolClass);
        DynaActionForm classForm = (DynaActionForm)form;
        classForm.set("className", schoolClass.getEditablePartOfName());
        List infoShifts = (List)ReadShiftsByClass.run(infoClass);
        if (infoShifts != null && !infoShifts.isEmpty()) {
            Collections.sort(infoShifts, InfoShift.SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS);
            request.setAttribute("shifts", (Object)infoShifts);
        }
        return mapping.findForward("EditClass");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm classForm = (DynaValidatorForm)form;
        String className = (String)classForm.get("className");
        User userView = Authenticate.getUser();
        InfoClass infoClassOld = (InfoClass)request.getAttribute("context.classView");
        InfoClass infoClassNew = null;
        try {
            infoClassNew = (InfoClass)EditarTurma.run(infoClassOld.getExternalId(), className);
        }
        catch (DomainException e) {
            throw new ExistingActionException((Object)"A SchoolClass", (Throwable)((Object)e));
        }
        request.removeAttribute("context.classView");
        request.setAttribute("context.classView", (Object)infoClassNew);
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward removeShift(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User userView = Authenticate.getUser();
        InfoClass infoClass = (InfoClass)request.getAttribute("context.classView");
        String shiftOID = request.getParameter("shift_oid");
        InfoShift infoShift = ReadShiftByOID.run(shiftOID);
        RemoverTurno.run(infoShift, infoClass);
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward prepareAddShifts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InfoClass infoClass = (InfoClass)request.getAttribute("context.classView");
        List infoShifts = (List)ReadAvailableShiftsForClass.run(infoClass);
        Collections.sort(infoShifts, InfoShift.SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS);
        request.setAttribute("shifts", (Object)infoShifts);
        return mapping.findForward("AddShifts");
    }

    public ActionForward viewSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InfoClass infoClass = (InfoClass)request.getAttribute("context.classView");
        DynaActionForm classForm = (DynaActionForm)form;
        classForm.set("className", (Object)infoClass.getNome());
        request.setAttribute("className", (Object)infoClass.getNome());
        List<InfoLessonInstanceAggregation> lessonList = LerAulasDeTurma.run(infoClass);
        request.setAttribute("lessonList", lessonList);
        return mapping.findForward("ViewSchedule");
    }

    public ActionForward removeShifts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm removeShiftsForm = (DynaActionForm)form;
        String[] selectedShifts = (String[])removeShiftsForm.get("selectedItems");
        if (selectedShifts.length == 0) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("errors.shifts.notSelected", new ActionError("errors.shifts.notSelected"));
            this.saveErrors(request, actionErrors);
            return mapping.getInputForward();
        }
        ArrayList<String> shiftOIDs = new ArrayList<String>();
        for (String selectedShift : selectedShifts) {
            shiftOIDs.add(selectedShift);
        }
        InfoClass infoClass = (InfoClass)request.getAttribute("context.classView");
        RemoveShifts.run(infoClass, shiftOIDs);
        return mapping.findForward("EditClass");
    }

    @Mapping(path="/removeShifts", module="resourceAllocationManager", input="/manageClass.do?method=prepare", formBean="selectMultipleItemsForm", functionality=ExecutionPeriodDA.class)
    @Forwards(value={@Forward(name="EditClass", path="/resourceAllocationManager/manageClass.do?method=prepare")})
    public static class RemoveShiftsDA
    extends ManageClassDA {
    }
}

