/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.thesis.academicAdminOffice;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramInformation;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.conclusion.PhdConclusionProcessBean;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisJuryElementBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.AddJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.AddPresidentJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.AddState;
import org.fenixedu.academic.domain.phd.thesis.activities.ConcludePhdProcess;
import org.fenixedu.academic.domain.phd.thesis.activities.DeleteDocument;
import org.fenixedu.academic.domain.phd.thesis.activities.DeleteJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.EditJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.EditPhdThesisProcessInformation;
import org.fenixedu.academic.domain.phd.thesis.activities.MoveJuryElementOrder;
import org.fenixedu.academic.domain.phd.thesis.activities.RatifyFinalThesis;
import org.fenixedu.academic.domain.phd.thesis.activities.RejectJuryElements;
import org.fenixedu.academic.domain.phd.thesis.activities.RejectJuryElementsDocuments;
import org.fenixedu.academic.domain.phd.thesis.activities.RemindJuryReviewToReporters;
import org.fenixedu.academic.domain.phd.thesis.activities.RemoveLastState;
import org.fenixedu.academic.domain.phd.thesis.activities.ReplaceDocument;
import org.fenixedu.academic.domain.phd.thesis.activities.RequestJuryElements;
import org.fenixedu.academic.domain.phd.thesis.activities.RequestJuryReviews;
import org.fenixedu.academic.domain.phd.thesis.activities.ScheduleThesisDiscussion;
import org.fenixedu.academic.domain.phd.thesis.activities.SetFinalGrade;
import org.fenixedu.academic.domain.phd.thesis.activities.SetPhdJuryElementRatificationEntity;
import org.fenixedu.academic.domain.phd.thesis.activities.SubmitJuryElementsDocuments;
import org.fenixedu.academic.domain.phd.thesis.activities.SubmitThesis;
import org.fenixedu.academic.domain.phd.thesis.activities.SwapJuryElementsOrder;
import org.fenixedu.academic.domain.phd.thesis.activities.UploadDocuments;
import org.fenixedu.academic.domain.phd.thesis.activities.ValidateJury;
import org.fenixedu.academic.report.phd.thesis.PhdThesisJuryElementsDocument;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessStateBean;
import org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.PhdIndividualProgramProcessDA;
import org.fenixedu.academic.ui.struts.action.phd.thesis.CommonPhdThesisProcessDA;
import org.fenixedu.academic.util.Pair;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.LocalDate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/phdThesisProcess", module="academicAdministration", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="requestJuryElements", path="/phd/thesis/academicAdminOffice/requestJuryElements.jsp"), @Forward(name="submitJuryElementsDocument", path="/phd/thesis/academicAdminOffice/submitJuryElementsDocument.jsp"), @Forward(name="manageThesisJuryElements", path="/phd/thesis/academicAdminOffice/manageThesisJuryElements.jsp"), @Forward(name="rejectJuryElements", path="/phd/thesis/academicAdminOffice/rejectJuryElements.jsp"), @Forward(name="addJuryElement", path="/phd/thesis/academicAdminOffice/addJuryElement.jsp"), @Forward(name="editJuryElement", path="/phd/thesis/academicAdminOffice/editJuryElement.jsp"), @Forward(name="validateJury", path="/phd/thesis/academicAdminOffice/validateJury.jsp"), @Forward(name="submitThesis", path="/phd/thesis/academicAdminOffice/submitThesis.jsp"), @Forward(name="requestJuryReviews", path="/phd/thesis/academicAdminOffice/requestJuryReviews.jsp"), @Forward(name="remindJuryReviews", path="/phd/thesis/academicAdminOffice/remindJuryReviews.jsp"), @Forward(name="addPresidentJuryElement", path="/phd/thesis/academicAdminOffice/addPresidentJuryElement.jsp"), @Forward(name="manageThesisDocuments", path="/phd/thesis/academicAdminOffice/manageThesisDocuments.jsp"), @Forward(name="scheduleThesisDiscussion", path="/phd/thesis/academicAdminOffice/scheduleThesisDiscussion.jsp"), @Forward(name="ratifyFinalThesis", path="/phd/thesis/academicAdminOffice/ratifyFinalThesis.jsp"), @Forward(name="setFinalGrade", path="/phd/thesis/academicAdminOffice/setFinalGrade.jsp"), @Forward(name="rejectJuryElementsDocuments", path="/phd/thesis/academicAdminOffice/rejectJuryElementsDocuments.jsp"), @Forward(name="viewMeetingSchedulingProcess", path="/phd/thesis/academicAdminOffice/viewMeetingSchedulingProcess.jsp"), @Forward(name="juryReporterFeedbackUpload", path="/phd/thesis/academicAdminOffice/juryReporterFeedbackUpload.jsp"), @Forward(name="replaceDocument", path="/phd/thesis/academicAdminOffice/replaceDocument.jsp"), @Forward(name="manageStates", path="/phd/thesis/academicAdminOffice/manageStates.jsp"), @Forward(name="editPhdThesisProcessInformation", path="/phd/thesis/academicAdminOffice/editPhdThesisProcessInformation.jsp"), @Forward(name="listConclusionProcess", path="/phd/thesis/academicAdminOffice/conclusion/listConclusionProcess.jsp"), @Forward(name="createConclusionProcess", path="/phd/thesis/academicAdminOffice/conclusion/createConclusionProcess.jsp"), @Forward(name="editPhdProcessState", path="/phd/thesis/academicAdminOffice/editState.jsp"), @Forward(name="viewLogs", path="/phd/thesis/academicAdminOffice/logs/viewLogs.jsp")})
public class PhdThesisProcessDA
extends CommonPhdThesisProcessDA {
    public ActionForward prepareRequestJuryElements(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("requestJuryElements");
    }

    public ActionForward requestJuryElements(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RequestJuryElements.class, this.getRenderedObject("thesisProcessBean"));
            this.addSuccessMessage(request, "message.thesis.jury.elements.requested.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("thesisProcessBean", this.getRenderedObject("thesisProcessBean"));
            return mapping.findForward("requestJuryElements");
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward prepareSubmitJuryElementsDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean(this.getProcess(request).getIndividualProgramProcess());
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.JURY_ELEMENTS));
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.JURY_PRESIDENT_ELEMENT));
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.JURY_PRESIDENT_DECLARATION));
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.MAXIMUM_GRADE_GUIDER_PROPOSAL));
        return this.prepareSubmitJuryElementsDocument(mapping, actionForm, request, response, bean);
    }

    public ActionForward prepareSubmitJuryElementsDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, PhdThesisProcessBean bean) {
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("submitJuryElementsDocument");
    }

    public ActionForward submitJuryElementsDocumentInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", this.getRenderedObject("thesisProcessBean"));
        return mapping.findForward("submitJuryElementsDocument");
    }

    public ActionForward submitJuryElementsDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            IViewState viewState = RenderUtils.getViewState((String)"thesisProcessBean.edit.documents");
            if (!viewState.isValid()) {
                RenderUtils.invalidateViewState((String)"thesisProcessBean.edit.documents");
                return this.submitJuryElementsDocumentInvalid(mapping, actionForm, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), SubmitJuryElementsDocuments.class, this.getRenderedObject("thesisProcessBean"));
            this.addSuccessMessage(request, "message.thesis.jury.elements.added.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            RenderUtils.invalidateViewState((String)"thesisProcessBean.edit.documents");
            return this.submitJuryElementsDocumentInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward manageThesisJuryElements(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("manageThesisJuryElements");
    }

    public ActionForward prepareAddJuryElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisJuryElementBean", (Object)new PhdThesisJuryElementBean(this.getProcess(request)));
        return mapping.findForward("addJuryElement");
    }

    public ActionForward prepareAddJuryElementInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisJuryElementBean", this.getRenderedObject("thesisJuryElementBean"));
        return mapping.findForward("addJuryElement");
    }

    public ActionForward prepareAddJuryElementPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisJuryElementBean", this.getRenderedObject("thesisJuryElementBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("addJuryElement");
    }

    public ActionForward addJuryElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AddJuryElement.class, this.getRenderedObject("thesisJuryElementBean"));
            this.addSuccessMessage(request, "message.thesis.added.jury.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.prepareAddJuryElementInvalid(mapping, actionForm, request, response);
        }
        return this.manageThesisJuryElements(mapping, actionForm, request, response);
    }

    public ActionForward prepareEditJuryElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisJuryElementBean", (Object)new PhdThesisJuryElementBean(this.getProcess(request), this.getJuryElement(request)));
        return mapping.findForward("editJuryElement");
    }

    public ActionForward editJuryElementInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisJuryElementBean", this.getRenderedObject("thesisJuryElementBean"));
        return mapping.findForward("editJuryElement");
    }

    public ActionForward editJuryElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), EditJuryElement.class, this.getRenderedObject("thesisJuryElementBean"));
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.editJuryElementInvalid(mapping, actionForm, request, response);
        }
        return this.redirect(String.format("/phdThesisProcess.do?method=manageThesisJuryElements&processId=%s", this.getProcess(request).getExternalId()), request);
    }

    public ActionForward deleteJuryElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), DeleteJuryElement.class, (Object)this.getJuryElement(request));
            this.addSuccessMessage(request, "message.thesis.jury.removed", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
        }
        return this.redirect(String.format("/phdThesisProcess.do?method=manageThesisJuryElements&processId=%s", this.getProcess(request).getExternalId()), request);
    }

    private ThesisJuryElement getJuryElement(HttpServletRequest request) {
        return (ThesisJuryElement)((Object)this.getDomainObject(request, "juryElementId"));
    }

    private void swapJuryElements(HttpServletRequest request, ThesisJuryElement e1, ThesisJuryElement e2) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), SwapJuryElementsOrder.class, new Pair<ThesisJuryElement, ThesisJuryElement>(e1, e2));
            this.addSuccessMessage(request, "message.thesis.jury.element.swapped", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            throw e;
        }
    }

    private void moveElement(HttpServletRequest request, ThesisJuryElement element, Integer position) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), MoveJuryElementOrder.class, new Pair<ThesisJuryElement, Integer>(element, position));
            this.addSuccessMessage(request, "message.thesis.jury.element.swapped", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
        }
    }

    public ActionForward moveUp(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcess process2 = this.getProcess(request);
        ThesisJuryElement juryElement = this.getJuryElement(request);
        ThesisJuryElement lower = process2.getOrderedThesisJuryElements().lower(juryElement);
        if (lower != null) {
            this.swapJuryElements(request, juryElement, lower);
        }
        return this.manageThesisJuryElements(mapping, actionForm, request, response);
    }

    public ActionForward moveDown(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcess process2 = this.getProcess(request);
        ThesisJuryElement juryElement = this.getJuryElement(request);
        ThesisJuryElement higher = process2.getOrderedThesisJuryElements().higher(juryElement);
        if (higher != null) {
            this.swapJuryElements(request, juryElement, higher);
        }
        return this.manageThesisJuryElements(mapping, actionForm, request, response);
    }

    public ActionForward moveTop(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ThesisJuryElement first;
        PhdThesisProcess process2 = this.getProcess(request);
        ThesisJuryElement juryElement = this.getJuryElement(request);
        if (juryElement != (first = process2.getOrderedThesisJuryElements().first())) {
            this.moveElement(request, juryElement, first.getElementOrder() - 1);
        }
        return this.manageThesisJuryElements(mapping, actionForm, request, response);
    }

    public ActionForward moveBottom(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ThesisJuryElement last;
        PhdThesisProcess process2 = this.getProcess(request);
        ThesisJuryElement juryElement = this.getJuryElement(request);
        if (juryElement != (last = process2.getOrderedThesisJuryElements().last())) {
            this.moveElement(request, juryElement, last.getElementOrder() - 1);
        }
        return this.manageThesisJuryElements(mapping, actionForm, request, response);
    }

    public ActionForward prepareAddPresidentJuryElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisJuryElementBean", (Object)new PhdThesisJuryElementBean(this.getProcess(request)));
        return mapping.findForward("addPresidentJuryElement");
    }

    public ActionForward prepareAddPresidentJuryElementInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisJuryElementBean", this.getRenderedObject("thesisJuryElementBean"));
        return mapping.findForward("addPresidentJuryElement");
    }

    public ActionForward prepareAddPresidentJuryElementPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisJuryElementBean", this.getRenderedObject("thesisJuryElementBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("addPresidentJuryElement");
    }

    public ActionForward addPresidentJuryElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AddPresidentJuryElement.class, this.getRenderedObject("thesisJuryElementBean"));
            this.addSuccessMessage(request, "message.thesis.added.jury.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.prepareAddPresidentJuryElementInvalid(mapping, actionForm, request, response);
        }
        return this.manageThesisJuryElements(mapping, actionForm, request, response);
    }

    public ActionForward prepareValidateJury(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        bean.setWhenJuryValidated(new LocalDate());
        request.setAttribute("thesisBean", (Object)bean);
        return mapping.findForward("validateJury");
    }

    public ActionForward prepareValidateJuryInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisBean", this.getRenderedObject("thesisBean"));
        return mapping.findForward("validateJury");
    }

    public ActionForward validateJury(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), ValidateJury.class, this.getRenderedObject("thesisBean"));
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.prepareValidateJuryInvalid(mapping, actionForm, request, response);
        }
        return this.manageThesisJuryElements(mapping, actionForm, request, response);
    }

    public ActionForward printJuryElementsDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhdThesisJuryElementsDocument report = new PhdThesisJuryElementsDocument(this.getProcess(request));
        this.writeFile(response, report.getReportFileName() + ".pdf", "application/pdf", ReportsUtils.generateReport(report).getData());
        return null;
    }

    public ActionForward prepareRejectJuryElements(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisBean", (Object)new PhdThesisProcessBean());
        return mapping.findForward("rejectJuryElements");
    }

    public ActionForward rejectJuryElements(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RejectJuryElements.class, this.getRenderedObject("thesisBean"));
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("thesisBean", this.getRenderedObject("thesisBean"));
            return mapping.findForward("rejectJuryElements");
        }
        return this.manageThesisJuryElements(mapping, actionForm, request, response);
    }

    public ActionForward prepareRequestJuryReviews(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("requestJuryReviewsBean", (Object)new PhdThesisProcessBean());
        return mapping.findForward("requestJuryReviews");
    }

    public ActionForward prepareRequestJuryReviewsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("requestJuryReviewsBean", this.getRenderedObject("requestJuryReviewsBean"));
        return mapping.findForward("requestJuryReviews");
    }

    public ActionForward requestJuryReviews(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RequestJuryReviews.class, this.getRenderedObject("requestJuryReviewsBean"));
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.prepareRequestJuryReviewsInvalid(mapping, form, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward prepareRemindJuryReviews(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("remindJuryReviewsBean", (Object)new PhdThesisProcessBean());
        return mapping.findForward("remindJuryReviews");
    }

    public ActionForward prepareRemindJuryReviewsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("remindJuryReviewsBean", this.getRenderedObject("remindJuryReviewsBean"));
        return mapping.findForward("remindJuryReviews");
    }

    public ActionForward remindJuryReviews(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RemindJuryReviewToReporters.class, this.getRenderedObject("remindJuryReviewsBean"));
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.prepareRemindJuryReviewsInvalid(mapping, form, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward prepareScheduleThesisDiscussion(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        PhdThesisProcess thesisProcess = this.getProcess(request);
        bean.setThesisProcess(thesisProcess);
        this.setDefaultDiscussionMailInformation(bean, thesisProcess);
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("scheduleThesisDiscussion");
    }

    private void setDefaultDiscussionMailInformation(PhdThesisProcessBean bean, PhdThesisProcess thesisProcess) {
        PhdIndividualProgramProcess process2 = thesisProcess.getIndividualProgramProcess();
        bean.setMailSubject(AlertService.getSubjectPrefixed(process2, "message.phd.thesis.schedule.thesis.discussion.default.subject"));
        bean.setMailBody(AlertService.getBodyText(process2, "message.phd.thesis.schedule.thesis.discussion.default.body"));
    }

    public ActionForward scheduleThesisDiscussionInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        return mapping.findForward("scheduleThesisDiscussion");
    }

    public ActionForward scheduleThesisDiscussionPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        RenderUtils.invalidateViewState();
        return mapping.findForward("scheduleThesisDiscussion");
    }

    public ActionForward scheduleThesisDiscussion(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcess thesisProcess = this.getProcess(request);
        try {
            ExecuteProcessActivity.run((Process)((Object)thesisProcess), ScheduleThesisDiscussion.class, (Object)this.getThesisProcessBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.scheduleThesisDiscussionPostback(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, thesisProcess);
    }

    public ActionForward prepareSubmitThesis(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.FINAL_THESIS));
        request.setAttribute("submitThesisBean", (Object)bean);
        return mapping.findForward("submitThesis");
    }

    public ActionForward prepareSubmitThesisInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("submitThesisBean", this.getRenderedObject("submitThesisBean"));
        RenderUtils.invalidateViewState((String)"submitThesisBean.edit.documents");
        return mapping.findForward("submitThesis");
    }

    public ActionForward submitThesis(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!RenderUtils.getViewState((String)"submitThesisBean.edit.documents").isValid()) {
                this.addErrorMessage(request, "error.phd.invalid.documents", new String[0]);
                return this.prepareSubmitThesisInvalid(mapping, form, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), SubmitThesis.class, this.getRenderedObject("submitThesisBean"));
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.prepareSubmitThesisInvalid(mapping, form, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward prepareRatifyFinalThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.FINAL_THESIS_RATIFICATION_DOCUMENT));
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("ratifyFinalThesis");
    }

    public ActionForward ratifyFinalThesisInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        return mapping.findForward("ratifyFinalThesis");
    }

    public ActionForward ratifyFinalThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!RenderUtils.getViewState((String)"thesisProcessBean.edit").isValid()) {
                return this.ratifyFinalThesisInvalid(mapping, actionForm, request, response);
            }
            if (!RenderUtils.getViewState((String)"thesisProcessBean.edit.documents").isValid()) {
                this.addErrorMessage(request, "error.phd.invalid.documents", new String[0]);
                return this.ratifyFinalThesisInvalid(mapping, actionForm, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RatifyFinalThesis.class, (Object)this.getThesisProcessBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.ratifyFinalThesisInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward prepareSetFinalGrade(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.CONCLUSION_DOCUMENT));
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("setFinalGrade");
    }

    public ActionForward setFinalGradeInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        return mapping.findForward("setFinalGrade");
    }

    public ActionForward setFinalGrade(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!RenderUtils.getViewState((String)"thesisProcessBean.edit").isValid()) {
                return this.setFinalGradeInvalid(mapping, actionForm, request, response);
            }
            if (!RenderUtils.getViewState((String)"thesisProcessBean.edit.documents").isValid()) {
                this.addErrorMessage(request, "error.phd.invalid.documents", new String[0]);
                return this.setFinalGradeInvalid(mapping, actionForm, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), SetFinalGrade.class, (Object)this.getThesisProcessBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.setFinalGradeInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward prepareRejectJuryElementsDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("rejectJuryElementsDocuments");
    }

    public ActionForward rejectJuryElementsDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RejectJuryElementsDocuments.class, this.getRenderedObject("thesisProcessBean"));
            this.addSuccessMessage(request, "message.thesis.jury.elements.documents.rejected.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("thesisProcessBean", this.getRenderedObject("thesisProcessBean"));
            return mapping.findForward("rejectJuryElementsDocuments");
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward viewMeetingSchedulingProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("viewMeetingSchedulingProcess");
    }

    public ActionForward prepareReplaceDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramDocumentUploadBean bean = new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.valueOf(request.getParameter("type")));
        request.setAttribute("documentBean", (Object)bean);
        return mapping.findForward("replaceDocument");
    }

    public ActionForward replaceDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            IViewState viewState = RenderUtils.getViewState((String)"documentBean");
            if (!viewState.isValid()) {
                return this.juryReportFeedbackUploadInvalid(mapping, form, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), ReplaceDocument.class, this.getRenderedObject("documentBean"));
            this.addSuccessMessage(request, "message.replace.document.done.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.replaceDocumentInvalid(mapping, form, request, response);
        }
        return this.manageThesisDocuments(mapping, form, request, response);
    }

    public ActionForward replaceDocumentInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        return mapping.findForward("replaceDocument");
    }

    @Override
    public ActionForward prepareJuryReportFeedbackUpload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean(this.getProcess(request).getIndividualProgramProcess());
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.JURY_REPORT_FEEDBACK));
        request.setAttribute("thesisProcessBean", (Object)bean);
        request.setAttribute("thesisDocuments", this.getProcess(request).getThesisDocumentsToFeedback());
        return mapping.findForward("juryReporterFeedbackUpload");
    }

    public ActionForward juryReportFeedbackUploadPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        request.setAttribute("thesisDocuments", this.getProcess(request).getThesisDocumentsToFeedback());
        return mapping.findForward("juryReporterFeedbackUpload");
    }

    public ActionForward manageStates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean(this.getProcess(request).getIndividualProgramProcess());
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("manageStates");
    }

    public ActionForward addState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("thesisProcessBean");
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AddState.class, (Object)bean);
        }
        catch (PhdDomainOperationException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
        }
        return this.manageStates(mapping, form, request, response);
    }

    public ActionForward addStateInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("thesisProcessBean");
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("manageStates");
    }

    public ActionForward removeLastState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RemoveLastState.class, null);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
        }
        return this.manageStates(mapping, form, request, response);
    }

    public ActionForward prepareEditPhdThesisProcessInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdThesisProcessBean", (Object)new PhdThesisProcessBean(this.getProcess(request).getIndividualProgramProcess()));
        return mapping.findForward("editPhdThesisProcessInformation");
    }

    public ActionForward editPhdThesisProcessInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdThesisProcessBean", this.getRenderedObject("phdThesisProcessBean"));
        return mapping.findForward("editPhdThesisProcessInformation");
    }

    public ActionForward editPhdThesisProcessInformationPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdThesisProcessBean", this.getRenderedObject("phdThesisProcessBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("editPhdThesisProcessInformation");
    }

    public ActionForward editPhdThesisProcessInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("phdThesisProcessBean");
        request.setAttribute("phdThesisProcessBean", (Object)bean);
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), EditPhdThesisProcessInformation.class.getSimpleName(), (Object)bean);
            this.addSuccessMessage(request, "message.phdThesisProcessInformation.edit.success", new String[0]);
            return this.viewIndividualProgramProcess(request, this.getProcess(request));
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return mapping.findForward("editPhdThesisProcessInformation");
        }
    }

    public ActionForward listConclusionProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("listConclusionProcess");
    }

    public ActionForward prepareCreateConclusionProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess individualProgramProcess = this.getProcess(request).getIndividualProgramProcess();
        PhdConclusionProcessBean bean = new PhdConclusionProcessBean(individualProgramProcess);
        LocalDate conclusionDate = null;
        conclusionDate = !individualProgramProcess.getStudyPlan().isExempted() ? individualProgramProcess.getRegistration().getLastStudentCurricularPlan().getCycle(CycleType.THIRD_CYCLE).getConclusionDate().toDateMidnight().toLocalDate() : bean.getConclusionDate();
        PhdProgramInformation phdProgramInformation = this.getProcess(request).getIndividualProgramProcess().getPhdProgram().getPhdProgramInformationByDate(conclusionDate);
        request.setAttribute("isExempted", (Object)individualProgramProcess.getStudyPlan().isExempted());
        request.setAttribute("conclusionDateForPhdInformation", (Object)conclusionDate);
        request.setAttribute("phdProgramInformation", (Object)phdProgramInformation);
        request.setAttribute("phdConclusionProcessBean", (Object)bean);
        return mapping.findForward("createConclusionProcess");
    }

    public ActionForward createConclusionProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdConclusionProcessBean bean = (PhdConclusionProcessBean)this.getRenderedObject("phdConclusionProcessBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), ConcludePhdProcess.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.createConclusionProcessInvalid(mapping, form, request, response);
        }
        return this.listConclusionProcesses(mapping, form, request, response);
    }

    public ActionForward createConclusionProcessInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdConclusionProcessBean bean = (PhdConclusionProcessBean)this.getRenderedObject("phdConclusionProcessBean");
        PhdIndividualProgramProcess individualProgramProcess = this.getProcess(request).getIndividualProgramProcess();
        LocalDate conclusionDate = null;
        conclusionDate = !individualProgramProcess.getStudyPlan().isExempted() ? individualProgramProcess.getRegistration().getLastStudentCurricularPlan().getCycle(CycleType.THIRD_CYCLE).getConclusionDate().toDateMidnight().toLocalDate() : bean.getConclusionDate();
        PhdProgramInformation phdProgramInformation = this.getProcess(request).getIndividualProgramProcess().getPhdProgram().getPhdProgramInformationByDate(conclusionDate);
        request.setAttribute("isExempted", (Object)individualProgramProcess.getStudyPlan().isExempted());
        request.setAttribute("conclusionDateForPhdInformation", (Object)conclusionDate);
        request.setAttribute("phdProgramInformation", (Object)phdProgramInformation);
        request.setAttribute("phdConclusionProcessBean", (Object)bean);
        return mapping.findForward("createConclusionProcess");
    }

    public ActionForward setPhdJuryElementsRatificationEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("thesisProcessBean");
        PhdThesisProcess process2 = this.getProcess(request);
        ExecuteProcessActivity.run((Process)((Object)process2), SetPhdJuryElementRatificationEntity.class, (Object)bean);
        return this.prepareSubmitJuryElementsDocument(mapping, form, request, response, bean);
    }

    public ActionForward setPhdJuryElementsRatificationEntityPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("thesisProcessBean");
        RenderUtils.invalidateViewState();
        return this.prepareSubmitJuryElementsDocument(mapping, form, request, response, bean);
    }

    public ActionForward setPhdJuryElementsRatificationEntityInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("thesisProcessBean");
        return this.prepareSubmitJuryElementsDocument(mapping, form, request, response, bean);
    }

    public ActionForward prepareEditState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProcessState state = (PhdProcessState)((Object)this.getDomainObject(request, "stateId"));
        PhdProcessStateBean bean = new PhdProcessStateBean(state);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editPhdProcessState");
    }

    public ActionForward editState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProcessStateBean bean = (PhdProcessStateBean)this.getRenderedObject("bean");
        bean.getState().editStateDate(bean);
        return this.manageStates(mapping, form, request, response);
    }

    public ActionForward editStateInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProcessStateBean bean = (PhdProcessStateBean)this.getRenderedObject("bean");
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editPhdProcessState");
    }

    public ActionForward viewLogs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("viewLogs");
    }

    protected List<PhdProgramDocumentUploadBean> getDocumentsToUpload() {
        return (List)this.getObjectFromViewState("documentsToUpload");
    }

    protected boolean hasAnyDocumentToUpload() {
        for (PhdProgramDocumentUploadBean each : this.getDocumentsToUpload()) {
            if (!each.hasAnyInformation()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActionForward deleteDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.prepareDocumentsToUpload(request);
        return this.executeActivity(DeleteDocument.class, this.getDomainObject(request, "documentId"), request, mapping, "manageThesisDocuments", "manageThesisDocuments", "message.document.deleted.successfuly", new String[0]);
    }

    @Override
    public ActionForward manageThesisDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.prepareDocumentsToUpload(request);
        return mapping.findForward("manageThesisDocuments");
    }

    private void prepareDocumentsToUpload(HttpServletRequest request) {
        request.setAttribute("documentsToUpload", Arrays.asList(new PhdProgramDocumentUploadBean(), new PhdProgramDocumentUploadBean(), new PhdProgramDocumentUploadBean()));
    }

    public ActionForward uploadDocumentsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("documentsToUpload", this.getDocumentsToUpload());
        return mapping.findForward("manageThesisDocuments");
    }

    public ActionForward uploadDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasAnyDocumentToUpload()) {
            request.setAttribute("documentsToUpload", this.getDocumentsToUpload());
            this.addErrorMessage(request, "message.no.documents.to.upload", new String[0]);
            return mapping.findForward("manageThesisDocuments");
        }
        ActionForward result = this.executeActivity(UploadDocuments.class, this.getDocumentsToUpload(), request, mapping, "manageThesisDocuments", "manageThesisDocuments", "message.documents.uploaded.with.success", new String[0]);
        RenderUtils.invalidateViewState((String)"documentsToUpload");
        this.prepareDocumentsToUpload(request);
        return result;
    }

    public static class ExistingPhdParticipantsEvenInPhdThesisProcess
    implements DataProvider {
        public Converter getConverter() {
            return new DomainObjectKeyConverter();
        }

        public Object provide(Object source, Object currentValue) {
            PhdThesisJuryElementBean bean = (PhdThesisJuryElementBean)source;
            return bean.getExistingParticipants();
        }
    }
}

