/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.ui.renderers.student.curriculum.StudentCurricularPlanRenderer;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class PhdCurriculumFilterOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Registration registration;
    private StudentCurricularPlan selectedStudentCurricularPlan;
    private StudentCurricularPlanRenderer.ViewType viewType;
    private StudentCurricularPlanRenderer.EnrolmentStateFilterType enrolmentStateType;
    private StudentCurricularPlanRenderer.OrganizationType organizationType;
    private Boolean detailed;

    public PhdCurriculumFilterOptions() {
        this.setViewType(StudentCurricularPlanRenderer.ViewType.ALL);
        this.setEnrolmentStateType(StudentCurricularPlanRenderer.EnrolmentStateFilterType.APPROVED_OR_ENROLED);
        this.setOrganizationType(StudentCurricularPlanRenderer.OrganizationType.GROUPS);
        this.setDetailed(Boolean.FALSE);
    }

    public PhdCurriculumFilterOptions(Registration registration) {
        this();
        this.setRegistration(registration);
        this.setSelectedStudentCurricularPlan(registration.getLastStudentCurricularPlan());
    }

    private Registration getRegistration() {
        return this.registration;
    }

    private void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public StudentCurricularPlan getSelectedStudentCurricularPlan() {
        return this.selectedStudentCurricularPlan;
    }

    public void setSelectedStudentCurricularPlan(StudentCurricularPlan selectedStudentCurricularPlan) {
        this.selectedStudentCurricularPlan = selectedStudentCurricularPlan;
    }

    public List<StudentCurricularPlan> getStudentCurricularPlans() {
        if (this.getSelectedStudentCurricularPlan() == null) {
            return this.getRegistration().getSortedStudentCurricularPlans();
        }
        return Collections.singletonList(this.getSelectedStudentCurricularPlan());
    }

    public StudentCurricularPlanRenderer.ViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(StudentCurricularPlanRenderer.ViewType viewType) {
        this.viewType = viewType;
    }

    public StudentCurricularPlanRenderer.EnrolmentStateFilterType getEnrolmentStateType() {
        return this.enrolmentStateType;
    }

    public void setEnrolmentStateType(StudentCurricularPlanRenderer.EnrolmentStateFilterType enrolmentStateType) {
        this.enrolmentStateType = enrolmentStateType;
    }

    public StudentCurricularPlanRenderer.OrganizationType getOrganizationType() {
        return this.organizationType;
    }

    public void setOrganizationType(StudentCurricularPlanRenderer.OrganizationType organizationType) {
        this.organizationType = organizationType;
    }

    public Boolean getDetailed() {
        return this.detailed;
    }

    public void setDetailed(Boolean detailed) {
        this.detailed = detailed;
    }

    public static class PhdStudentCurricularPlansFilterProvider
    implements DataProvider {
        public Converter getConverter() {
            return new DomainObjectKeyConverter();
        }

        public Object provide(Object source, Object currentValue) {
            PhdCurriculumFilterOptions filter = (PhdCurriculumFilterOptions)source;
            return filter.getRegistration().getSortedStudentCurricularPlans();
        }
    }
}

