/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.nape.candidacy.over23;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyResultBean;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.Over23CandidacyPeriod;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.academic.ui.struts.action.nape.NapeApplication;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.commons.spreadsheet.SpreadsheetXLSExporter;

@StrutsFunctionality(app=NapeApplication.NapeCandidaciesApp.class, path="over-23", titleKey="title.application.name.over23")
@Mapping(path="/caseHandlingOver23CandidacyProcess", module="nape", formBeanClass=CandidacyProcessDA.CandidacyProcessForm.class)
@Forwards(value={@Forward(name="intro", path="/candidacy/mainCandidacyProcess.jsp")})
public class Over23CandidacyProcessDA
extends CandidacyProcessDA {
    @Override
    protected Class getProcessType() {
        return Over23CandidacyProcess.class;
    }

    @Override
    protected Class getChildProcessType() {
        return Over23IndividualCandidacyProcess.class;
    }

    @Override
    protected Class getCandidacyPeriodType() {
        return Over23CandidacyPeriod.class;
    }

    @Override
    protected void setStartInformation(ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasExecutionInterval(request)) {
            List<ExecutionInterval> executionIntervals = ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType());
            if (executionIntervals.size() == 1) {
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getCandidacyProcess(request, executionIntervals.iterator().next())));
            } else {
                request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
                request.setAttribute("executionIntervals", executionIntervals);
            }
        } else {
            this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getCandidacyProcess(request, this.getExecutionInterval(request))));
        }
    }

    @Override
    protected ActionForward introForward(ActionMapping mapping) {
        return mapping.findForward("intro");
    }

    protected Over23CandidacyProcess getCandidacyProcess(HttpServletRequest request, ExecutionInterval executionInterval) {
        return executionInterval.hasOver23CandidacyPeriod() ? executionInterval.getOver23CandidacyPeriod().getOver23CandidacyProcess() : null;
    }

    public ActionForward prepareExecuteSendInformationToJury(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("send-to-jury");
    }

    public ActionForward executeSendInformationToJury(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendInformationToJury", null);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExecuteSendInformationToJury(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecutePrintCandidacies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getReportFilename());
        ServletOutputStream writer = response.getOutputStream();
        Over23CandidacyProcess process2 = this.getProcess(request);
        Spreadsheet spreadsheet = this.buildReport(process2.getOver23IndividualCandidaciesThatCanBeSendToJury());
        spreadsheet.exportToXLSSheet((OutputStream)writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private Spreadsheet buildReport(List<Over23IndividualCandidacyProcess> over23IndividualCandidacies) {
        CandidacyReport result = new CandidacyReport("candidacies");
        result.setHeaders(new String[]{BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.identificationNumber", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.degrees", (String[])new String[0])});
        for (Over23IndividualCandidacyProcess candidacy : over23IndividualCandidacies) {
            Spreadsheet.Row row = result.addRow();
            row.setCell(candidacy.getPersonalDetails().getName());
            row.setCell(candidacy.getPersonalDetails().getDocumentIdNumber());
            int count = 1;
            String degrees = "";
            for (Degree degree : candidacy.getSelectedDegreesSortedByOrder()) {
                degrees = degrees + count++ + " - " + degree.getNameFor(candidacy.getCandidacyExecutionInterval()) + "\n";
            }
            row.setCell(degrees);
        }
        return result;
    }

    public ActionForward prepareExecuteIntroduceCandidacyResults(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.setInformationToIntroduceCandidacyResults(request);
        return mapping.findForward("view-candidacy-results");
    }

    private void setInformationToIntroduceCandidacyResults(HttpServletRequest request) {
        Over23CandidacyProcess process2 = this.getProcess(request);
        ArrayList<Over23IndividualCandidacyResultBean> beans = new ArrayList<Over23IndividualCandidacyResultBean>();
        for (Over23IndividualCandidacyProcess candidacy : process2.getOver23IndividualCandidaciesThatCanBeSendToJury()) {
            beans.add(new Over23IndividualCandidacyResultBean(candidacy));
        }
        request.setAttribute("over23IndividualCandidacyResultBeans", beans);
    }

    public ActionForward prepareIntroduceCandidacyResults(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.setInformationToIntroduceCandidacyResults(request);
        return mapping.findForward("insert-candidacy-results");
    }

    public ActionForward executeIntroduceCandidacyResults(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "IntroduceCandidacyResults", this.getRenderedObject("over23IndividualCandidacyResultBeans"));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("over23IndividualCandidacyResultBeans", this.getRenderedObject("over23IndividualCandidacyResultBeans"));
            return mapping.findForward("insert-candidacy-results");
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward executeIntroduceCandidacyResultsInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("over23IndividualCandidacyResultBeans", this.getRenderedObject("over23IndividualCandidacyResultBeans"));
        return mapping.findForward("insert-candidacy-results");
    }

    public ActionForward prepareExecutePublishCandidacyResults(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "PublishCandidacyResults", null);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    protected Over23CandidacyProcess getProcess(HttpServletRequest request) {
        return (Over23CandidacyProcess)((Object)super.getProcess(request));
    }

    @Override
    protected List<CandidacyProcessDA.CandidacyDegreeBean> createCandidacyDegreeBeans(HttpServletRequest request) {
        Over23CandidacyProcess process2 = this.getProcess(request);
        ArrayList<CandidacyProcessDA.CandidacyDegreeBean> candidacyDegreeBeans = new ArrayList<CandidacyProcessDA.CandidacyDegreeBean>();
        for (Over23IndividualCandidacyProcess child : process2.getAcceptedOver23IndividualCandidacies()) {
            candidacyDegreeBeans.add(new Over23CandidacyDegreeBean(child));
        }
        Collections.sort(candidacyDegreeBeans);
        return candidacyDegreeBeans;
    }

    @Override
    protected Spreadsheet buildIndividualCandidacyReport(Spreadsheet spreadsheet, IndividualCandidacyProcess individualCandidacyProcess) {
        return null;
    }

    public static class Over23CandidacyDegreeBean
    extends CandidacyProcessDA.CandidacyDegreeBean {
        public Over23CandidacyDegreeBean(Over23IndividualCandidacyProcess process2) {
            this.setPersonalDetails(process2.getPersonalDetails());
            this.setDegree(process2.getAcceptedDegree());
            this.setState(process2.getCandidacyState());
            this.setRegistrationCreated(process2.hasRegistrationForCandidacy());
        }
    }

    private static class CandidacyReport
    extends Spreadsheet {
        public CandidacyReport(String name) {
            super(name);
        }

        public void exportToXLSSheet(OutputStream outputStream) throws IOException {
            new CandidacyXLSExporter().exportToXLSSheet(this, outputStream);
        }
    }

    private static class CandidacyXLSExporter
    extends SpreadsheetXLSExporter {
        private CandidacyXLSExporter() {
        }

        protected void exportXLSLine(HSSFSheet sheet, HSSFCellStyle cellStyle, List<Object> cells, int offset) {
            HSSFRow row = sheet.createRow(sheet.getLastRowNum() + offset);
            cellStyle.setVerticalAlignment((short)1);
            int count = 0;
            for (Object cellValue : cells) {
                if (++count == 3) {
                    cellStyle.setAlignment((short)1);
                } else {
                    cellStyle.setAlignment((short)2);
                }
                this.addColumn(cellStyle, row, cellValue);
            }
        }
    }
}

