/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.coordinator.ThesisSummaryBean;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/manageFinalDegreeWork", module="coordinator", formBean="finalDegreeWorkCandidacyRequirements", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="show-final-degree-work-info", path="/coordinator/finalDegreeWork/showFinalDegreeWorkInfo.jsp"), @Forward(name="show-choose-execution-degree-page", path="/coordinator/finalDegreeWork/showFinalDegreeChooseExecutionDegree_bd.jsp")})
public class ManageFinalDegreeWorkDispatchAction
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        String executionDegreePlanOID = ManageFinalDegreeWorkDispatchAction.newFindExecutionDegreeID(request);
        if (executionDegreePlanOID != null) {
            request.setAttribute("executionDegreeOID", (Object)executionDegreePlanOID);
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreePlanOID);
            request.setAttribute("executionDegree", (Object)executionDegree);
        }
        return super.execute(mapping, actionForm, request, response);
    }

    private static String newFindExecutionDegreeID(HttpServletRequest request) {
        String executionDegreePlanOID = request.getParameter("executionDegreeOID");
        if (executionDegreePlanOID == null) {
            executionDegreePlanOID = (String)request.getAttribute("executionDegreeOID");
        }
        return executionDegreePlanOID;
    }

    public ActionForward showChooseExecutionDegreeForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        String degreeCurricularPlanOID = (String)this.getFromRequest(request, "degreeCurricularPlanID");
        request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanOID);
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)((Object)this.getDomainObject(request, "degreeCurricularPlanID"));
        List<InfoExecutionDegree> infoExecutionDegrees = ManageFinalDegreeWorkDispatchAction.getExecutionCourses(degreeCurricularPlan);
        Collections.sort(infoExecutionDegrees, new Comparator<InfoExecutionDegree>(){

            @Override
            public int compare(InfoExecutionDegree o1, InfoExecutionDegree o2) {
                return o2.getExecutionDegree().getExecutionYear().compareTo(o1.getExecutionDegree().getExecutionYear());
            }
        });
        request.setAttribute("infoExecutionDegrees", infoExecutionDegrees);
        return mapping.findForward("show-choose-execution-degree-page");
    }

    public static List<InfoExecutionDegree> getExecutionCourses(DegreeCurricularPlan degreeCurricularPlan) {
        Collection executionDegrees = degreeCurricularPlan.getExecutionYears().stream().map(executionYear -> degreeCurricularPlan.getExecutionDegreeByYear((ExecutionYear)executionYear)).collect(Collectors.toSet());
        ArrayList<InfoExecutionDegree> result = new ArrayList<InfoExecutionDegree>(executionDegrees.size());
        for (ExecutionDegree executionDegree : executionDegrees) {
            InfoExecutionDegree infoExecutionDegree = InfoExecutionDegree.newInfoFromDomain(executionDegree);
            result.add(infoExecutionDegree);
        }
        return result;
    }

    public ActionForward finalDegreeWorkInfo(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionDegree executionDegree = this.getExecutionDegree(request);
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        ExecutionYear executionYear = executionDegree.getExecutionYear().getNextExecutionYear();
        if (executionYear != null) {
            request.setAttribute("executionYearId", (Object)executionYear.getExternalId());
        }
        request.setAttribute("summary", (Object)new ThesisSummaryBean(executionDegree, degreeCurricularPlan));
        return mapping.findForward("show-final-degree-work-info");
    }

    private ExecutionDegree getExecutionDegree(HttpServletRequest request) {
        return (ExecutionDegree)this.getDomainObject(request, "executionDegreeOID");
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        return (DegreeCurricularPlan)((Object)this.getDomainObject(request, "degreeCurricularPlanID"));
    }

    @Mapping(path="/finalDegreeWorkProposal", module="coordinator", input="/finalDegreeWorkProposal.do?method=createNewFinalDegreeWorkProposal", formBean="finalDegreeWorkProposal", functionality=DegreeCoordinatorIndex.class)
    @Forwards(value={@Forward(name="show-final-degree-work-list", path="/coordinator/manageFinalDegreeWork.do?method=showProposal&page=0")})
    public static class FinalDegreeWorkProposalDA
    extends ManageFinalDegreeWorkDispatchAction {
    }
}

