/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrollmentDomainException;
import org.fenixedu.academic.dto.student.OptionalCurricularCoursesLocationBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.student.curriculumLines.MoveCurriculumLines;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/optionalCurricularCoursesLocation", module="academicAdministration", formBeanClass=OptionalCurricularCoursesLocationForm.class, functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="showEnrolments", path="/academicAdminOffice/curriculum/enrolments/location/showEnrolments.jsp"), @Forward(name="chooseNewDestination", path="/academicAdminOffice/curriculum/enrolments/location/chooseNewDestination.jsp"), @Forward(name="backToStudentEnrolments", path="/academicAdministration/studentEnrolments.do?method=prepare")})
public class OptionalCurricularCoursesLocationManagementDA
extends FenixDispatchAction {
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        StudentCurricularPlan studentCurricularPlan = this.getStudentCurricularPlan(request);
        request.setAttribute("studentCurricularPlan", (Object)studentCurricularPlan);
        ArrayList<Enrolment> enrolments = new ArrayList<Enrolment>(studentCurricularPlan.getEnrolmentsSet());
        Collections.sort(enrolments, Enrolment.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
        request.setAttribute("enrolments", enrolments);
        return mapping.findForward("showEnrolments");
    }

    public ActionForward chooseNewDestination(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        StudentCurricularPlan studentCurricularPlan = this.getStudentCurricularPlan(request);
        request.setAttribute("studentCurricularPlan", (Object)studentCurricularPlan);
        OptionalCurricularCoursesLocationBean bean = new OptionalCurricularCoursesLocationBean(studentCurricularPlan);
        String[] enrolmentIds = ((OptionalCurricularCoursesLocationForm)actionForm).getEnrolmentsToChange();
        bean.addEnrolments(this.getEnrolments(bean.getStudentCurricularPlan(), enrolmentIds));
        request.setAttribute("optionalCurricularCoursesLocationBean", (Object)bean);
        return mapping.findForward("chooseNewDestination");
    }

    public ActionForward chooseNewDestinationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OptionalCurricularCoursesLocationBean bean = this.getBean();
        RenderUtils.invalidateViewState();
        request.setAttribute("optionalCurricularCoursesLocationBean", (Object)bean);
        request.setAttribute("studentCurricularPlan", (Object)bean.getStudentCurricularPlan());
        return mapping.findForward("chooseNewDestination");
    }

    public ActionForward moveEnrolments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OptionalCurricularCoursesLocationBean bean = this.getBean();
        try {
            MoveCurriculumLines.run(bean);
            return this.backToStudentEnrolments(mapping, actionForm, request, response);
        }
        catch (EnrollmentDomainException ex) {
            this.addRuleResultMessagesToActionMessages("error", request, ex.getFalseResult());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        catch (FenixServiceException e) {
            this.addActionMessage(request, e.getMessage());
        }
        request.setAttribute("optionalCurricularCoursesLocationBean", (Object)bean);
        request.setAttribute("studentCurricularPlan", (Object)bean.getStudentCurricularPlan());
        return mapping.findForward("chooseNewDestination");
    }

    protected StudentCurricularPlan getStudentCurricularPlan(HttpServletRequest request) {
        return (StudentCurricularPlan)((Object)this.getDomainObject(request, "scpID"));
    }

    private OptionalCurricularCoursesLocationBean getBean() {
        return (OptionalCurricularCoursesLocationBean)this.getRenderedObject("optionalCurricularCoursesLocationBean");
    }

    private List<Enrolment> getEnrolments(StudentCurricularPlan studentCurricularPlan, String[] enrolmentIds) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        Set<Enrolment> enrolments = studentCurricularPlan.getEnrolmentsSet();
        for (String stringId : enrolmentIds) {
            Enrolment enrolment = this.getEnrolment(enrolments, stringId);
            if (enrolment == null) continue;
            result.add(enrolment);
        }
        return result;
    }

    private Enrolment getEnrolment(Collection<Enrolment> enrolments, String enrolmentId) {
        for (Enrolment enrolment : enrolments) {
            if (!enrolment.getExternalId().equals(enrolmentId)) continue;
            return enrolment;
        }
        return null;
    }

    public ActionForward backToStudentEnrolments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("backToStudentEnrolments");
    }

    public static class OptionalCurricularCoursesLocationForm
    extends FenixActionForm {
        private static final long serialVersionUID = -4536468956181155941L;
        private String[] enrolmentsToChange;

        public String[] getEnrolmentsToChange() {
            return this.enrolmentsToChange;
        }

        public void setEnrolmentsToChange(String[] enrolmentsToChange) {
            this.enrolmentsToChange = enrolmentsToChange;
        }
    }
}

