/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.accounts;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Person_Base;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.UserProfile;
import org.fenixedu.commons.StringNormalizer;

public class SearchParametersBean
implements Serializable {
    private static final long serialVersionUID = -7514731909906016794L;
    private String username;
    private String name;
    private String documentIdNumber;
    private String email;
    private String socialSecurityNumber;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDocumentIdNumber() {
        return this.documentIdNumber;
    }

    public void setDocumentIdNumber(String documentIdNumber) {
        this.documentIdNumber = documentIdNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public Collection<Person> search() {
        Stream<User> matches = this.filterSocialSecurityNumber(this.filterEmail(this.filterDocumentIdNumber(this.filterName(this.filterUsername(null)))));
        return matches == null ? Collections.emptySet() : (Collection)matches.map(u -> u.getPerson()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Stream<User> filterUsername(Stream<User> matches) {
        if (!Strings.isNullOrEmpty((String)this.username)) {
            if (matches == null) {
                return Stream.of(User.findByUsername((String)this.username)).filter(Objects::nonNull);
            }
            return matches.filter(p -> Objects.equals(p.getUsername(), this.username));
        }
        return matches;
    }

    private Stream<User> filterName(Stream<User> matches) {
        if (!Strings.isNullOrEmpty((String)this.name)) {
            if (matches == null) {
                return UserProfile.searchByName((String)this.name, (int)Integer.MAX_VALUE).map(UserProfile::getUser).filter(Objects::nonNull);
            }
            return matches.filter(u -> SearchParametersBean.namesMatch(this.name, u.getProfile().getFullName()));
        }
        return matches;
    }

    private Stream<User> filterDocumentIdNumber(Stream<User> matches) {
        if (!Strings.isNullOrEmpty((String)this.documentIdNumber)) {
            if (matches == null) {
                return Person.findPersonByDocumentID(this.documentIdNumber).stream().map(Person_Base::getUser).filter(Objects::nonNull);
            }
            return matches.filter(u -> Objects.equals(u.getPerson().getDocumentIdNumber(), this.documentIdNumber));
        }
        return matches;
    }

    private Stream<User> filterEmail(Stream<User> matches) {
        if (!Strings.isNullOrEmpty((String)this.email)) {
            if (matches == null) {
                return Stream.of(Person.readPersonByEmailAddress(this.email)).filter(Objects::nonNull).map(Person_Base::getUser).filter(Objects::nonNull);
            }
            return matches.filter(u -> u.getPerson().getEmailAddresses().stream().filter(a -> a.getValue().equals(this.email)).findAny().isPresent());
        }
        return matches;
    }

    private Stream<User> filterSocialSecurityNumber(Stream<User> matches) {
        if (!Strings.isNullOrEmpty((String)this.socialSecurityNumber)) {
            if (matches == null) {
                return Stream.of(Party.readByContributorNumber(this.socialSecurityNumber)).filter(Objects::nonNull).filter(p -> p instanceof Person).map(p -> (Person)((Object)((Object)p))).map(Person_Base::getUser).filter(Objects::nonNull);
            }
            return matches.filter(u -> Objects.equals(u.getPerson().getSocialSecurityNumber(), this.socialSecurityNumber));
        }
        return matches;
    }

    private static boolean namesMatch(String query, String name) {
        List<String> namearts = Arrays.asList(StringNormalizer.normalizeAndRemoveAccents((String)name).toLowerCase().trim().split("\\s+|-"));
        List<String> queryParts = Arrays.asList(StringNormalizer.normalizeAndRemoveAccents((String)query).toLowerCase().trim().split("\\s+|-"));
        return namearts.containsAll(queryParts);
    }
}

