/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.validator.DynaValidatorForm;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.InfoExecutionCourseEditor;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.service.services.commons.ReadExecutionPeriods;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.InsertExecutionCourseAtExecutionPeriod;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.utils.PresentationConstants;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminExecutionsApp.class, path="insert-execution-course", titleKey="label.manager.executionCourseManagement.insert.executionCourse", accessGroup="academic(MANAGE_EXECUTION_COURSES)")
@Mapping(module="academicAdministration", path="/insertExecutionCourse", formBean="insertExecutionCourseForm")
@Forwards(value={@Forward(name="firstPage", path="/academicAdministration/executionCourseManagement/welcomeScreen.jsp"), @Forward(name="insertExecutionCourse", path="/academicAdministration/executionCourseManagement/insertExecutionCourse.jsp")})
public class InsertExecutionCourseDispatchAction
extends FenixDispatchAction {
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareInsertExecutionCourse(mapping, form, request, response);
    }

    @EntryPoint
    public ActionForward prepareInsertExecutionCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List infoExecutionPeriods = null;
        infoExecutionPeriods = ReadExecutionPeriods.run();
        if (infoExecutionPeriods != null && !infoExecutionPeriods.isEmpty()) {
            infoExecutionPeriods = (List)CollectionUtils.select((Collection)infoExecutionPeriods, (Predicate)new Predicate(){

                public boolean evaluate(Object input) {
                    InfoExecutionPeriod infoExecutionPeriod = (InfoExecutionPeriod)input;
                    return !infoExecutionPeriod.getState().equals(PeriodState.CLOSED);
                }
            });
            ComparatorChain comparator = new ComparatorChain();
            comparator.addComparator((Comparator)new BeanComparator("infoExecutionYear.year"), true);
            comparator.addComparator((Comparator)new BeanComparator("name"), true);
            Collections.sort(infoExecutionPeriods, comparator);
            ArrayList executionPeriodLabels = new ArrayList();
            CollectionUtils.collect((Collection)infoExecutionPeriods, (Transformer)new Transformer(){

                public Object transform(Object arg0) {
                    InfoExecutionPeriod infoExecutionPeriod = (InfoExecutionPeriod)arg0;
                    LabelValueBean executionPeriod = new LabelValueBean(infoExecutionPeriod.getName() + " - " + infoExecutionPeriod.getInfoExecutionYear().getYear(), infoExecutionPeriod.getExternalId().toString());
                    return executionPeriod;
                }
            }, executionPeriodLabels);
            request.setAttribute(PresentationConstants.LIST_EXECUTION_PERIODS, executionPeriodLabels);
            ArrayList<LabelValueBean> entryPhases = new ArrayList<LabelValueBean>();
            for (EntryPhase entryPhase : EntryPhase.values()) {
                LabelValueBean labelValueBean = new LabelValueBean(entryPhase.getLocalizedName(), entryPhase.getName());
                entryPhases.add(labelValueBean);
            }
            request.setAttribute("entryPhases", entryPhases);
        }
        return mapping.findForward("insertExecutionCourse");
    }

    public ActionForward insertExecutionCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        InfoExecutionCourseEditor infoExecutionCourse = null;
        try {
            infoExecutionCourse = this.fillInfoExecutionCourse(form, request);
            this.checkInfoExecutionCourse(infoExecutionCourse);
        }
        catch (DomainException ex) {
            this.addActionMessageLiteral("error", request, ex.getKey());
            return this.prepareInsertExecutionCourse(mapping, form, request, response);
        }
        try {
            InsertExecutionCourseAtExecutionPeriod.run(infoExecutionCourse);
            this.addActionMessage("success", request, "message.manager.executionCourseManagement.insert.success", infoExecutionCourse.getNome(), infoExecutionCourse.getSigla(), infoExecutionCourse.getInfoExecutionPeriod().getExecutionPeriod().getName(), infoExecutionCourse.getInfoExecutionPeriod().getExecutionPeriod().getExecutionYear().getYear());
        }
        catch (DomainException ex) {
            this.addActionMessage("error", request, ex.getMessage(), ex.getArgs());
            return this.prepareInsertExecutionCourse(mapping, form, request, response);
        }
        catch (FenixServiceException ex) {
            this.addActionMessage("error", request, ex.getMessage());
        }
        return mapping.findForward("firstPage");
    }

    private InfoExecutionCourseEditor fillInfoExecutionCourse(ActionForm form, HttpServletRequest request) {
        DynaValidatorForm dynaForm = (DynaValidatorForm)form;
        InfoExecutionCourseEditor infoExecutionCourse = new InfoExecutionCourseEditor();
        String name = (String)dynaForm.get("name");
        infoExecutionCourse.setNome(name);
        String code = (String)dynaForm.get("code");
        infoExecutionCourse.setSigla(code);
        String executionPeriodId = (String)dynaForm.get("executionPeriodId");
        InfoExecutionPeriod infoExecutionPeriod = null;
        if (!StringUtils.isEmpty((String)executionPeriodId) && StringUtils.isNumeric((String)executionPeriodId)) {
            infoExecutionPeriod = new InfoExecutionPeriod((ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodId));
        }
        infoExecutionCourse.setInfoExecutionPeriod(infoExecutionPeriod);
        String comment = "";
        if ((String)dynaForm.get("comment") != null) {
            comment = (String)dynaForm.get("comment");
        }
        infoExecutionCourse.setComment(comment);
        String entryPhaseString = dynaForm.getString("entryPhase");
        EntryPhase entryPhase = null;
        if (entryPhaseString != null && entryPhaseString.length() > 0) {
            entryPhase = EntryPhase.valueOf(entryPhaseString);
        }
        infoExecutionCourse.setEntryPhase(entryPhase);
        return infoExecutionCourse;
    }

    private void checkInfoExecutionCourse(InfoExecutionCourseEditor infoExecutionCourse) {
        StringBuilder errors = new StringBuilder();
        if (infoExecutionCourse.getInfoExecutionPeriod() == null) {
            errors.append(this.errorStringBuilder("property.executionPeriod"));
        }
        if (StringUtils.isEmpty((String)infoExecutionCourse.getNome())) {
            errors.append(this.errorStringBuilder("label.name"));
        }
        if (StringUtils.isEmpty((String)infoExecutionCourse.getSigla())) {
            errors.append(this.errorStringBuilder("label.code"));
        }
        if (errors.length() > 0) {
            throw new DomainException(errors.toString(), new String[0]);
        }
    }

    private String errorStringBuilder(String property) {
        return BundleUtil.getString((String)"resources.ManagerResources", (String)"errors.required", (String[])new String[]{BundleUtil.getString((String)"resources.ApplicationResources", (String)property, (String[])new String[0])}) + " ";
    }
}

