/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.fenixedu.academic.ui.faces.components.util.JsfRenderUtils;

public class UICommandButton
extends HtmlCommandButton {
    private static final String INPUT_SUBMIT_TYPE = "submit";
    private static final String INPUT_RESET_TYPE = "reset";
    private static final String INPUT_IMAGE_TYPE = "image";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        JsfRenderUtils.addEventHandlingHiddenFieldsIfNotExists(context, (UIComponent)this);
        List<UIParameter> uiParameters = this.getParametersWithNameAttribute();
        JsfRenderUtils.addHiddenFieldsForParametersIfNotExists(context, (UIComponent)this, uiParameters);
        writer.startElement("input", (UIComponent)this);
        writer.writeAttribute("type", (Object)(this.getType() == null ? INPUT_SUBMIT_TYPE : this.getType()), null);
        writer.writeAttribute("id", (Object)this.getClientId(context), null);
        writer.writeAttribute("name", (Object)this.getClientId(context), null);
        writer.writeAttribute("style", (Object)(this.getStyle() != null ? this.getStyle() : ""), null);
        writer.writeAttribute("class", (Object)(this.getStyleClass() != null ? this.getStyleClass() : ""), null);
        writer.writeAttribute("alt", (Object)(this.getAlt() != null ? this.getAlt() : ""), null);
        writer.writeAttribute("value", this.getValue() != null ? this.getValue() : "", null);
        writer.writeAttribute("onclick", (Object)this.getOnClickEvent(context, uiParameters), null);
        if (this.getType() != null && this.getType().equalsIgnoreCase(INPUT_IMAGE_TYPE)) {
            writer.writeAttribute("src", (Object)(this.getImage() != null ? this.getImage() : ""), null);
        }
    }

    private String getOnClickEvent(FacesContext context, List<UIParameter> uiParameters) {
        StringBuilder onClickEvent = new StringBuilder();
        if (this.getOnclick() != null) {
            onClickEvent.append(this.getOnclick()).append(";");
        }
        onClickEvent.append(JsfRenderUtils.getSubmitJavaScriptWithParameters(context, (UIComponent)this, uiParameters));
        return onClickEvent.toString();
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("input");
    }

    public void decode(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        UIForm parentForm = JsfRenderUtils.findForm((UIComponent)this);
        String parentFormClientId = parentForm.getClientId(context);
        String eventSenderHiddenFieldId = JsfRenderUtils.getEventSenderHiddenFieldId(parentFormClientId);
        String eventSenderId = (String)paramMap.get(eventSenderHiddenFieldId);
        boolean isReset = false;
        if (this.getType() != null && this.getType().equalsIgnoreCase(INPUT_RESET_TYPE)) {
            isReset = true;
        }
        if (!isReset && eventSenderId != null && eventSenderId.equals(this.getClientId(context))) {
            this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
        }
    }

    private List<UIParameter> getParametersWithNameAttribute() {
        ArrayList<UIParameter> result = new ArrayList<UIParameter>();
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIParameter parameter;
            UIComponent child = (UIComponent)children.get(i);
            if (!(child instanceof UIParameter) || (parameter = (UIParameter)child).getName() == null) continue;
            result.add(parameter);
        }
        return result;
    }
}

