/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.enrollment.shift;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.InfoLessonInstanceAggregation;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.service.filter.enrollment.ClassEnrollmentAuthorizationFilter;
import org.fenixedu.academic.service.services.enrollment.shift.ReadClassTimeTableByStudent$callable$runReadClassTimeTableByStudent;
import org.fenixedu.academic.service.services.enrollment.shift.ReadClassTimeTableByStudent$callable$runReadClassTimeTableByStudent$1;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadClassTimeTableByStudent {
    private static final ReadClassTimeTableByStudent serviceInstance;
    public static final Advice advice$runReadClassTimeTableByStudent;
    public static final Advice advice$runReadClassTimeTableByStudent$1;

    public List<InfoShowOccupation> run(Registration registration, SchoolClass schoolClass, ExecutionCourse executionCourse) throws FenixServiceException {
        List<InfoShowOccupation> result = this.getOccupations(registration, schoolClass, executionCourse, null);
        return result;
    }

    public List<InfoShowOccupation> run(Registration registration, SchoolClass schoolClass, ExecutionCourse executionCourse, ExecutionSemester executionSemester) throws FenixServiceException {
        List<InfoShowOccupation> result = this.getOccupations(registration, schoolClass, executionCourse, executionSemester);
        return result;
    }

    private List<InfoShowOccupation> getOccupations(Registration registration, SchoolClass schoolClass, ExecutionCourse executionCourse, ExecutionSemester executionSemester) throws FenixServiceException {
        if (registration == null) {
            throw new FenixServiceException("error.readClassTimeTableByStudent.noStudent");
        }
        if (schoolClass == null) {
            throw new FenixServiceException("error.readClassTimeTableByStudent.noSchoolClass");
        }
        Set<ExecutionCourse> attendingExecutionCourses = null;
        if (executionSemester != null) {
            attendingExecutionCourses = new HashSet<ExecutionCourse>();
            attendingExecutionCourses.addAll(registration.getAttendingExecutionCoursesFor(executionSemester));
        } else {
            attendingExecutionCourses = registration.getAttendingExecutionCoursesForCurrentExecutionPeriod();
        }
        ArrayList<InfoShowOccupation> result = new ArrayList<InfoShowOccupation>();
        for (Shift shift : schoolClass.getAssociatedShiftsSet()) {
            if (executionCourse != null && executionCourse != shift.getDisciplinaExecucao() || !attendingExecutionCourses.contains((Object)shift.getDisciplinaExecucao())) continue;
            result.addAll(InfoLessonInstanceAggregation.getAggregations(shift));
        }
        return result;
    }

    public static List<InfoShowOccupation> runReadClassTimeTableByStudent(Registration registration, SchoolClass schoolClass, ExecutionCourse executionCourse) throws FenixServiceException, NotAuthorizedException {
        return (List)advice$runReadClassTimeTableByStudent.perform((Callable)new ReadClassTimeTableByStudent$callable$runReadClassTimeTableByStudent(registration, schoolClass, executionCourse));
    }

    static /* synthetic */ List<InfoShowOccupation> advised$runReadClassTimeTableByStudent(Registration registration, SchoolClass schoolClass, ExecutionCourse executionCourse) throws FenixServiceException, NotAuthorizedException {
        ClassEnrollmentAuthorizationFilter.instance.execute(registration);
        return serviceInstance.run(registration, schoolClass, executionCourse);
    }

    public static List<InfoShowOccupation> runReadClassTimeTableByStudent(Registration registration, SchoolClass schoolClass, ExecutionCourse executionCourse, ExecutionSemester executionSemester) throws FenixServiceException, NotAuthorizedException {
        return (List)advice$runReadClassTimeTableByStudent$1.perform((Callable)new ReadClassTimeTableByStudent$callable$runReadClassTimeTableByStudent$1(registration, schoolClass, executionCourse, executionSemester));
    }

    static /* synthetic */ List<InfoShowOccupation> advised$runReadClassTimeTableByStudent(Registration registration, SchoolClass schoolClass, ExecutionCourse executionCourse, ExecutionSemester executionSemester) throws FenixServiceException, NotAuthorizedException {
        ClassEnrollmentAuthorizationFilter.instance.execute(registration, executionSemester);
        return serviceInstance.run(registration, schoolClass, executionCourse, executionSemester);
    }

    static {
        advice$runReadClassTimeTableByStudent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runReadClassTimeTableByStudent$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ReadClassTimeTableByStudent();
    }
}

