/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.dto.InfoCurricularCourse;
import org.fenixedu.academic.dto.InfoDegree;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.MarkType;
import org.fenixedu.commons.i18n.I18N;

public class InfoDegreeCurricularPlan
extends InfoObject
implements Comparable {
    private final DegreeCurricularPlan degreeCurricularPlanDomainReference;
    private final boolean showEnVersion = I18N.getLocale().getLanguage().equals("en");

    public InfoDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        this.degreeCurricularPlanDomainReference = degreeCurricularPlan;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlanDomainReference;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InfoDegreeCurricularPlan && this.getDegreeCurricularPlan() == ((InfoDegreeCurricularPlan)obj).getDegreeCurricularPlan();
    }

    public String toString() {
        return this.getDegreeCurricularPlan().toString();
    }

    public String getLabel() {
        String degreeName = this.getDegreeCurricularPlan().getDegree().getName();
        String initialDateString = DateFormatUtil.format("dd/MM/yyyy", this.getDegreeCurricularPlan().getInitialDate());
        int labelSize = degreeName.length() + initialDateString.length() + this.getDegreeCurricularPlan().getName().length() + 4;
        StringBuilder stringBuilder = new StringBuilder(labelSize);
        stringBuilder.append(degreeName);
        stringBuilder.append(" ");
        stringBuilder.append(initialDateString);
        stringBuilder.append(" - ");
        stringBuilder.append(this.getDegreeCurricularPlan().getName());
        return stringBuilder.toString();
    }

    public Double getNeededCredits() {
        return this.getDegreeCurricularPlan().getNeededCredits();
    }

    public Date getEndDate() {
        return this.getDegreeCurricularPlan().getEndDate();
    }

    public Date getInitialDate() {
        return this.getDegreeCurricularPlan().getInitialDate();
    }

    public String getName() {
        return this.getDegreeCurricularPlan().getName();
    }

    public String getPresentationName() {
        return this.getDegreeCurricularPlan().getDegree().getName() + " " + this.getName();
    }

    public DegreeCurricularPlanState getState() {
        return this.getDegreeCurricularPlan().getState();
    }

    public Integer getDegreeDuration() {
        return this.getDegreeCurricularPlan().getDegreeDuration();
    }

    public Integer getMinimalYearForOptionalCourses() {
        return this.getDegreeCurricularPlan().getMinimalYearForOptionalCourses();
    }

    public MarkType getMarkType() {
        return this.getDegreeCurricularPlan().getMarkType();
    }

    public Integer getNumerusClausus() {
        return this.getDegreeCurricularPlan().getNumerusClausus();
    }

    public int compareTo(Object arg0) {
        InfoDegreeCurricularPlan degreeCurricularPlan = (InfoDegreeCurricularPlan)arg0;
        return this.getName().compareTo(degreeCurricularPlan.getName());
    }

    public List<InfoCurricularCourse> getCurricularCourses() {
        ArrayList<InfoCurricularCourse> infoCurricularCourses = new ArrayList<InfoCurricularCourse>();
        for (CurricularCourse curricularCourse : this.getDegreeCurricularPlan().getCurricularCoursesSet()) {
            infoCurricularCourses.add(InfoCurricularCourse.newInfoFromDomain(curricularCourse));
        }
        return infoCurricularCourses;
    }

    public String getDescription() {
        return this.showEnVersion ? this.getDescriptionEn() : this.getDegreeCurricularPlan().getDescription();
    }

    public String getDescriptionEn() {
        return this.getDegreeCurricularPlan().getDescriptionEn();
    }

    public InfoDegree getInfoDegree() {
        return InfoDegree.newInfoFromDomain(this.getDegreeCurricularPlan().getDegree());
    }

    public static InfoDegreeCurricularPlan newInfoFromDomain(DegreeCurricularPlan plan) {
        return plan == null ? null : new InfoDegreeCurricularPlan(plan);
    }

    public String getAnotation() {
        return this.getDegreeCurricularPlan().getAnotation();
    }

    public List<InfoExecutionDegree> getInfoExecutionDegrees() {
        ArrayList<InfoExecutionDegree> infoExeutionDegrees = new ArrayList<InfoExecutionDegree>();
        for (ExecutionDegree executionDegree : this.getDegreeCurricularPlan().getExecutionDegreesSet()) {
            infoExeutionDegrees.add(InfoExecutionDegree.newInfoFromDomain(executionDegree));
        }
        return infoExeutionDegrees;
    }

    public GradeScale getGradeScale() {
        return this.getDegreeCurricularPlan().getGradeScale();
    }

    @Override
    public String getExternalId() {
        return this.getDegreeCurricularPlan().getExternalId();
    }
}

