/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util.email;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.util.Email;
import org.fenixedu.academic.domain.util.EmailAddressList;
import org.fenixedu.academic.domain.util.email.Message$callable$createEmailBatch;
import org.fenixedu.academic.domain.util.email.Message_Base;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Message
extends Message_Base {
    public static final Comparator<Message> COMPARATOR_BY_CREATED_DATE_OLDER_FIRST;
    public static final Comparator<Message> COMPARATOR_BY_CREATED_DATE_OLDER_LAST;
    public static final int NUMBER_OF_SENT_EMAILS_TO_STAY = 500;
    public static final Advice advice$createEmailBatch;

    public Message() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Message(Sender sender, String to, String subject, String body) {
        this(sender, (Collection<? extends ReplyTo>)sender.getReplyTosSet(), null, subject, body, to);
    }

    public Message(Sender sender, Collection<? extends ReplyTo> replyTos, Collection<Recipient> tos, Collection<Recipient> ccs, Collection<Recipient> recipientsBccs, String subject, String body, Set<String> bccs) {
        this(sender, replyTos, recipientsBccs, subject, body, bccs);
        if (tos != null) {
            for (Recipient recipient : tos) {
                this.addTos(recipient);
            }
        }
        if (ccs != null) {
            for (Recipient recipient : ccs) {
                this.addCcs(recipient);
            }
        }
    }

    public Message(Sender sender, Collection<? extends ReplyTo> replyTos, Collection<Recipient> tos, Collection<Recipient> ccs, Collection<Recipient> recipientsBccs, String subject, String body, Set<String> bccs, String htmlBody) {
        this(sender, replyTos, recipientsBccs, subject, body, bccs);
        if (tos != null) {
            for (Recipient recipient : tos) {
                this.addTos(recipient);
            }
        }
        if (ccs != null) {
            for (Recipient recipient : ccs) {
                this.addCcs(recipient);
            }
        }
    }

    public Message(Sender sender, Recipient recipient, String subject, String body) {
        this(sender, sender.getConcreteReplyTos(), Collections.singleton(recipient), subject, body, new EmailAddressList(Collections.EMPTY_LIST).toString());
    }

    public Message(Sender sender, Collection<? extends ReplyTo> replyTos, Collection<Recipient> recipients, String subject, String body, Set<String> bccs) {
        this(sender, replyTos, recipients, subject, body, new EmailAddressList(bccs).toString());
    }

    public Message(Sender sender, Collection<? extends ReplyTo> replyTos, Collection<Recipient> recipients, String subject, String body, String bccs) {
        Bennu rootDomainObject = Bennu.getInstance();
        this.setRootDomainObject(rootDomainObject);
        this.setRootDomainObjectFromPendingRelation(rootDomainObject);
        this.setSender(sender);
        if (replyTos != null) {
            for (ReplyTo replyTo : replyTos) {
                this.addReplyTos(replyTo);
            }
        }
        if (recipients != null) {
            for (Recipient recipient : recipients) {
                this.addRecipients(recipient);
            }
        }
        this.setSubject(subject);
        this.setBody(body);
        this.setBccs(bccs);
        Person person = AccessControl.getPerson();
        this.setPerson(person);
        this.setCreated(new DateTime());
    }

    public Message(Sender sender, Collection<? extends ReplyTo> replyTos, Collection<Recipient> recipients, String subject, String body, String bccs, String htmlBody) {
        Bennu rootDomainObject = Bennu.getInstance();
        this.setRootDomainObject(rootDomainObject);
        this.setRootDomainObjectFromPendingRelation(rootDomainObject);
        this.setSender(sender);
        if (replyTos != null) {
            for (ReplyTo replyTo : replyTos) {
                this.addReplyTos(replyTo);
            }
        }
        if (recipients != null) {
            for (Recipient recipient : recipients) {
                this.addRecipients(recipient);
            }
        }
        this.setSubject(subject);
        this.setBody(body);
        this.setHtmlBody(htmlBody);
        this.setBccs(bccs);
        Person person = AccessControl.getPerson();
        this.setPerson(person);
        this.setCreated(new DateTime());
    }

    public void safeDelete() {
        if (this.getSent() == null) {
            this.delete();
        }
    }

    public void delete() {
        for (Recipient recipient : this.getRecipientsSet()) {
            this.removeRecipients(recipient);
        }
        for (Recipient recipient : this.getTosSet()) {
            this.removeTos(recipient);
        }
        for (Recipient recipient : this.getCcsSet()) {
            this.removeCcs(recipient);
        }
        for (ReplyTo replyTo : this.getReplyTosSet()) {
            replyTo.safeDelete();
        }
        for (Email email : this.getEmailsSet()) {
            email.delete();
        }
        this.setSender(null);
        this.setPerson(null);
        this.setRootDomainObjectFromPendingRelation(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public String getRecipientsAsText() {
        StringBuilder stringBuilder = new StringBuilder();
        Message.recipients2Text(stringBuilder, this.getRecipientsSet());
        if (this.getBccs() != null && !this.getBccs().isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(this.getBccs());
        }
        return stringBuilder.toString();
    }

    public String getRecipientsAsToText() {
        return Message.recipients2Text(this.getTosSet());
    }

    public String getRecipientsAsCcText() {
        return Message.recipients2Text(this.getCcsSet());
    }

    protected static String recipients2Text(Set<Recipient> recipients) {
        StringBuilder stringBuilder = new StringBuilder();
        Message.recipients2Text(stringBuilder, recipients);
        return stringBuilder.toString();
    }

    protected static void recipients2Text(StringBuilder stringBuilder, Set<Recipient> recipients) {
        for (Recipient recipient : recipients) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(recipient.getToName());
        }
    }

    public String getRecipientsGroupMembersInText() {
        StringBuilder builder = new StringBuilder();
        Set recipients = this.getRecipientsSet();
        for (Recipient recipient : recipients) {
            builder.append(recipient.getMembersEmailInText());
        }
        return builder.toString();
    }

    protected static Set<String> getRecipientAddresses(Set<Recipient> recipients) {
        HashSet<String> emailAddresses = new HashSet<String>();
        for (Recipient recipient : recipients) {
            recipient.addDestinationEmailAddresses(emailAddresses);
        }
        return emailAddresses;
    }

    protected Set<String> getDestinationBccs() {
        HashSet<String> emailAddresses = new HashSet<String>();
        if (this.getBccs() != null && !this.getBccs().isEmpty()) {
            for (String emailAddress : this.getBccs().replace(',', ' ').replace(';', ' ').split(" ")) {
                String trimmed = emailAddress.trim();
                if (trimmed.isEmpty()) continue;
                emailAddresses.add(emailAddress);
            }
        }
        for (Recipient recipient : this.getRecipientsSet()) {
            recipient.addDestinationEmailAddresses(emailAddresses);
        }
        return emailAddresses;
    }

    protected String[] getReplyToAddresses(Person person) {
        String[] replyToAddresses = new String[this.getReplyTosSet().size()];
        int i = 0;
        for (ReplyTo replyTo : this.getReplyTosSet()) {
            replyToAddresses[i++] = replyTo.getReplyToAddress(person);
        }
        return replyToAddresses;
    }

    public int dispatch() {
        Person person = this.getPerson();
        Set<String> destinationBccs = this.getDestinationBccs();
        Set<String> tos = Message.getRecipientAddresses(this.getTosSet());
        Set<String> ccs = Message.getRecipientAddresses(this.getCcsSet());
        this.createEmailBatch(person, tos, ccs, this.split(destinationBccs));
        return destinationBccs.size() + tos.size() + ccs.size();
    }

    private void createEmailBatch(Person person, Set<String> set, Set<String> set2, Set<Set<String>> set3) {
        Object object = advice$createEmailBatch.perform((Callable)new Message$callable$createEmailBatch(this, person, set, set2, set3));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$createEmailBatch(Message this_, Person person, Set tos, Set ccs, Set destinationBccs) {
        if (this_.getRootDomainObjectFromPendingRelation() != null) {
            for (Set bccs : destinationBccs) {
                if (bccs.isEmpty()) continue;
                new Email(this_.getReplyToAddresses(person), Collections.emptySet(), Collections.emptySet(), bccs, this_);
            }
            if (!tos.isEmpty() || !ccs.isEmpty()) {
                new Email(this_.getReplyToAddresses(person), tos, ccs, Collections.emptySet(), this_);
            }
            this_.setRootDomainObjectFromPendingRelation(null);
            this_.setSent(new DateTime());
        }
    }

    private Set<Set<String>> split(Set<String> destinations) {
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        int i = 0;
        HashSet<String> subSet = new HashSet<String>();
        for (String destination : destinations) {
            if (i++ == 50) {
                result.add(subSet);
                subSet = new HashSet();
                i = 1;
            }
            subSet.add(destination);
        }
        result.add(subSet);
        return result;
    }

    public int getPossibleRecipientsCount() {
        return (int)this.getRecipientsSet().stream().flatMap(r -> r.getMembers().getMembers().stream()).distinct().count();
    }

    public int getRecipientsWithEmailCount() {
        return (int)this.getRecipientsSet().stream().flatMap(r -> r.getMembers().getMembers().stream()).distinct().filter(u -> u.getPerson().getEmailAddressForSendingEmails() != null).count();
    }

    public int getSentMailsCount() {
        return (int)this.getEmailsSet().stream().filter(e -> e.getConfirmedAddresses() != null).flatMap(e -> e.getConfirmedAddresses().toCollection().stream()).distinct().count();
    }

    public int getFailedMailsCount() {
        return (int)this.getEmailsSet().stream().filter(e -> e.getFailedAddresses() != null).flatMap(e -> e.getFailedAddresses().toCollection().stream()).distinct().count();
    }

    public String getFromName() {
        return this.getSender().getFromName().replace(",", "");
    }

    public String getFromAddress() {
        return this.getSender().getFromAddress();
    }

    static {
        advice$createEmailBatch = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        COMPARATOR_BY_CREATED_DATE_OLDER_FIRST = new Comparator<Message>(){

            @Override
            public int compare(Message o1, Message o2) {
                return o1.getCreated().compareTo((ReadableInstant)o2.getCreated());
            }
        };
        COMPARATOR_BY_CREATED_DATE_OLDER_LAST = new Comparator<Message>(){

            @Override
            public int compare(Message o1, Message o2) {
                return o2.getCreated().compareTo((ReadableInstant)o1.getCreated());
            }
        };
    }
}

