/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.meeting.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.PhdMeetingSchedulingActivity;
import org.fenixedu.bennu.core.domain.User;

public class ScheduleThesisMeetingRequest
extends PhdMeetingSchedulingActivity {
    @Override
    protected void activityPreConditions(PhdMeetingSchedulingProcess process2, User userView) {
        if (!process2.getActiveState().equals(PhdMeetingSchedulingProcessStateType.WITHOUT_THESIS_MEETING_REQUEST)) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdMeetingSchedulingProcess executeActivity(PhdMeetingSchedulingProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        PhdThesisProcess thesisProcess = process2.getThesisProcess();
        if (bean.isToNotify()) {
            AlertService.alertParticipants(thesisProcess.getIndividualProgramProcess(), AlertService.AlertMessage.create("message.phd.request.schedule.meeting.president.notification.subject", new Object[0]), AlertService.AlertMessage.create("message.phd.request.schedule.meeting.president.notification.body", new Object[0]), thesisProcess.getPresidentJuryElement().getParticipant());
            AlertService.alertResponsibleCoordinators(thesisProcess.getIndividualProgramProcess(), AlertService.AlertMessage.create("message.phd.request.schedule.meeting.coordinator.notification.subject", new Object[0]), AlertService.AlertMessage.create("message.phd.request.schedule.meeting.coordinator.notification.body", thesisProcess.getPresidentJuryElement().getNameWithTitle()));
        }
        process2.createState(PhdMeetingSchedulingProcessStateType.WAITING_THESIS_MEETING_SCHEDULE, userView.getPerson(), bean.getRemarks());
        return process2;
    }
}

