/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.alert.PhdAlert_Base;
import org.fenixedu.academic.domain.util.email.UnitBasedSender;
import org.fenixedu.academic.util.MultiLanguageString;

public abstract class PhdAlert
extends PhdAlert_Base {
    protected PhdAlert() {
    }

    protected void init(PhdIndividualProgramProcess process2, MultiLanguageString subject, MultiLanguageString body) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.phd.alert.PhdAlert.process.cannot.be.null", args);
        }
        super.setProcess(process2);
        super.init(subject, body);
    }

    public void setProcess(PhdIndividualProgramProcess process2) {
        throw new DomainException("error.phd.alert.PhdAlert.cannot.modify.process", new String[0]);
    }

    protected String buildMailBody() {
        StringBuilder result = new StringBuilder();
        for (String eachContent : this.getFormattedBody().getAllContents()) {
            result.append(eachContent).append("\n").append(" ------------------------- ");
        }
        result.delete(result.lastIndexOf("\n") + 1, result.length());
        return result.toString();
    }

    protected String buildMailSubject() {
        StringBuilder result = new StringBuilder();
        for (String eachContent : this.getFormattedSubject().getAllContents()) {
            result.append(eachContent).append(" / ");
        }
        if (result.toString().endsWith(" / ")) {
            result.delete(result.length() - 3, result.length());
        }
        return result.toString();
    }

    public boolean isSystemAlert() {
        return false;
    }

    public boolean isCustomAlert() {
        return false;
    }

    protected void disconnect() {
        super.setProcess(null);
        this.setRootDomainObjectForActiveAlerts(null);
        this.setRootDomainObject(null);
    }

    public void delete() {
        this.disconnect();
        super.deleteDomainObject();
    }

    public boolean isActive() {
        return this.getActive();
    }

    protected UnitBasedSender getSender() {
        AdministrativeOffice administrativeOffice = this.getProcess().getAdministrativeOffice();
        return (UnitBasedSender)((Object)administrativeOffice.getUnit().getUnitBasedSenderSet().iterator().next());
    }
}

