/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitAcronym_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.StringNormalizer;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class UnitAcronym
extends UnitAcronym_Base {
    public UnitAcronym(String acronym) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setAcronym(acronym);
    }

    public void setAcronym(String acronym) {
        super.setAcronym(acronym == null ? null : acronym.toLowerCase());
    }

    protected void delete() {
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public static UnitAcronym readUnitAcronymByAcronym(String acronym) {
        return UnitAcronym.readUnitAcronymByAcronym(acronym, false);
    }

    public static UnitAcronym readUnitAcronymByAcronym(String acronym, boolean shouldNormalize) {
        if (acronym == null) {
            return null;
        }
        String acronymLowerCase = shouldNormalize ? UnitAcronym.normalize(acronym.toLowerCase()) : acronym.toLowerCase();
        for (UnitAcronym unitAcronym : Bennu.getInstance().getUnitAcronymsSet()) {
            if ((!shouldNormalize || !UnitAcronym.normalize(unitAcronym.getAcronym()).equals(acronymLowerCase)) && !unitAcronym.getAcronym().equals(acronymLowerCase)) continue;
            return unitAcronym;
        }
        return null;
    }

    public static String normalize(String string) {
        return string == null ? null : StringNormalizer.normalize((String)string).replace(' ', '-');
    }

    static {
        UnitAcronym.getRelationUnitUnitAcronym().addListener((RelationListener)new RelationAdapter<Unit, UnitAcronym>(){

            public void afterRemove(Unit unit, UnitAcronym unitAcronym) {
                if (unitAcronym != null && unitAcronym.getUnitsSet().isEmpty()) {
                    unitAcronym.delete();
                }
            }
        });
    }
}

