/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.log;

import java.util.Locale;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.log.EnrolmentEvaluationLog_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;

public class EnrolmentEvaluationLog
extends EnrolmentEvaluationLog_Base {
    EnrolmentEvaluationLog() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    EnrolmentEvaluationLog(EnrolmentEvaluation enrolmentEvaluation) {
        this();
        this.init(enrolmentEvaluation);
        this.setWho(this.getCurrentUser());
    }

    void init(EnrolmentEvaluation enrolmentEvaluation) {
        this.setCurricularCourse(String.format("externalId: %s; code: %s; name %s", enrolmentEvaluation.getEnrolment().getCurricularCourse().getExternalId(), enrolmentEvaluation.getEnrolment().getCurricularCourse().getCode(), enrolmentEvaluation.getEnrolment().getCurricularCourse().getName()));
        this.setGradeValue(enrolmentEvaluation.getGradeValue());
        this.setGradeScale(enrolmentEvaluation.getGradeScale() != null ? enrolmentEvaluation.getGradeScale().getName() : "");
        this.setEvaluationSeason(enrolmentEvaluation.getEvaluationSeason().getName().getContent(Locale.getDefault()));
        this.setEnrolmentEvaluationState(enrolmentEvaluation.getEnrolmentEvaluationState() != null ? enrolmentEvaluation.getEnrolmentEvaluationState().getState().toString() : "");
        this.setExecutionSemester(enrolmentEvaluation.getEnrolment().getExecutionPeriod().getName());
        this.setExamDate(enrolmentEvaluation.getExamDateYearMonthDay() != null ? enrolmentEvaluation.getExamDateYearMonthDay().toString("dd/MM/yyyy") : "");
        this.setEnrolmentEvaluationResponsible(enrolmentEvaluation.getPerson() != null ? enrolmentEvaluation.getPerson().getUsername() : "");
        this.setBook(enrolmentEvaluation.getBookReference());
        this.setPage(enrolmentEvaluation.getPage());
        this.setActionDate(new DateTime().toString());
    }

    public static void logEnrolmentEvaluationCreation(EnrolmentEvaluation enrolmentEvaluation) {
        EnrolmentEvaluationLog log = new EnrolmentEvaluationLog(enrolmentEvaluation);
        log.setAction("create");
    }

    public static void logEnrolmentEvaluationDeletion(EnrolmentEvaluation enrolmentEvaluation) {
        EnrolmentEvaluationLog log = new EnrolmentEvaluationLog(enrolmentEvaluation);
        log.setAction("delete");
    }

    protected String getCurrentUser() {
        return Authenticate.getUser() != null ? Authenticate.getUser().getUsername() : null;
    }
}

