/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroupInformation$callable$edit;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroupInformation_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CycleCourseGroupInformation
extends CycleCourseGroupInformation_Base {
    public static final Comparator<CycleCourseGroupInformation> COMPARATOR_BY_EXECUTION_YEAR;
    public static final Advice advice$edit;

    public CycleCourseGroupInformation() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public CycleCourseGroupInformation(CycleCourseGroup cycleCourseGroup, ExecutionYear executionYear, String graduateTitleSuffix, String graduateTitleSuffixEn) {
        this();
        this.setExecutionYear(executionYear);
        this.setCycleCourseGroup(cycleCourseGroup);
        this.checkParameters(graduateTitleSuffix, graduateTitleSuffixEn);
        this.setGraduateTitleSuffix(new LocalizedString(Locale.getDefault(), graduateTitleSuffix).with(Locale.ENGLISH, graduateTitleSuffixEn));
    }

    public void edit(ExecutionYear executionYear, String string, String string2) {
        Object object = advice$edit.perform((Callable)new CycleCourseGroupInformation$callable$edit(this, executionYear, string, string2));
    }

    static /* synthetic */ void advised$edit(CycleCourseGroupInformation this_, ExecutionYear editExecutionYear, String graduateTitleSuffix, String graduateTitleSuffixEn) {
        this_.setExecutionYear(editExecutionYear);
        this_.checkParameters(graduateTitleSuffix, graduateTitleSuffixEn);
        this_.setGraduateTitleSuffix(new LocalizedString(Locale.getDefault(), graduateTitleSuffix).with(Locale.ENGLISH, graduateTitleSuffixEn));
    }

    private void checkParameters(String graduatedTitleSuffix, String graduatedTitleSuffixEn) {
        if (this.getExecutionYear() == null) {
            throw new DomainException("cycle.course.group.information.execution.year.cannot.be.empty", new String[0]);
        }
        if (this.getCycleCourseGroup() == null) {
            throw new DomainException("cycle.course.group.information.course.group.cannot.be.empty", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)graduatedTitleSuffix) || Strings.isNullOrEmpty((String)graduatedTitleSuffixEn)) {
            throw new DomainException("cycle.course.group.information.title.suffix.cannot.be.empty", new String[0]);
        }
    }

    public String getGraduateTitleSuffixDefault() {
        return this.getGraduateTitleSuffix() != null ? this.getGraduateTitleSuffix().getContent(Locale.getDefault()) : "";
    }

    public String getGraduateTitleSuffixEn() {
        return this.getGraduateTitleSuffix() != null ? this.getGraduateTitleSuffix().getContent(Locale.ENGLISH) : "";
    }

    public boolean isFor(ExecutionInterval executionInterval) {
        return this.getExecutionYear() == executionInterval;
    }

    public void delete() {
        super.setExecutionYear(null);
        super.setCycleCourseGroup(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_EXECUTION_YEAR = new Comparator<CycleCourseGroupInformation>(){

            @Override
            public int compare(CycleCourseGroupInformation arg0, CycleCourseGroupInformation arg1) {
                return arg0.getExecutionYear().isBefore(arg1.getExecutionYear()) ? 1 : -1;
            }
        };
    }
}

