/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.secondCycle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCodeState;
import org.fenixedu.academic.domain.accounting.events.candidacy.IndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacySeriesGrade;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyResultBean;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacySeriesGrade;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacy_Base;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;

public class SecondCycleIndividualCandidacy
extends SecondCycleIndividualCandidacy_Base {
    private SecondCycleIndividualCandidacy() {
    }

    SecondCycleIndividualCandidacy(SecondCycleIndividualCandidacyProcess process2, SecondCycleIndividualCandidacyProcessBean bean) {
        this();
        Person person = this.init(bean, (IndividualCandidacyProcess)((Object)process2));
        this.getSelectedDegreesSet().addAll(bean.getSelectedDegreeList());
        for (Degree degree : bean.getSelectedDegreeList()) {
            SecondCycleIndividualCandidacySeriesGrade newSCICSeriesGrade = new SecondCycleIndividualCandidacySeriesGrade();
            newSCICSeriesGrade.setDegree(degree);
            this.getIndividualCandidacySeriesGradeSet().add(newSCICSeriesGrade);
        }
        this.setProfessionalStatus(bean.getProfessionalStatus());
        this.setOtherEducation(bean.getOtherEducation());
        this.createFormationEntries(bean.getFormationConcludedBeanList(), bean.getFormationNonConcludedBeanList());
        this.editFormerIstStudentNumber(bean);
        if (bean.getInternalPersonCandidacy().booleanValue()) {
            this.createDebt(person);
        }
        if (this.getSelectedDegreesSet().isEmpty()) {
            throw new DomainException("This shouldnt happen", new String[0]);
        }
    }

    protected void checkParameters(Person person, IndividualCandidacyProcess process2, IndividualCandidacyProcessBean bean) {
        SecondCycleIndividualCandidacyProcess secondCycleIndividualCandidacyProcess = (SecondCycleIndividualCandidacyProcess)((Object)process2);
        SecondCycleIndividualCandidacyProcessBean secondCandidacyProcessBean = (SecondCycleIndividualCandidacyProcessBean)bean;
        LocalDate candidacyDate = bean.getCandidacyDate();
        PrecedentDegreeInformationBean precedentDegreeInformationBean = secondCandidacyProcessBean.getPrecedentDegreeInformation();
        this.checkParameters(person, secondCycleIndividualCandidacyProcess, candidacyDate, secondCandidacyProcessBean.getSelectedDegreeList(), precedentDegreeInformationBean);
    }

    private void checkParameters(Person person, SecondCycleIndividualCandidacyProcess process2, LocalDate candidacyDate, Set<Degree> degrees, PrecedentDegreeInformationBean precedentDegreeInformation) {
        this.checkParameters(person, (IndividualCandidacyProcess)((Object)process2), candidacyDate);
        if (degrees.isEmpty()) {
            throw new DomainException("error.SecondCycleIndividualCandidacy.invalid.degrees.selection", new String[0]);
        }
        if (precedentDegreeInformation == null) {
            throw new DomainException("error.SecondCycleIndividualCandidacy.invalid.precedentDegreeInformation", new String[0]);
        }
    }

    protected void createDebt(Person person) {
        new SecondCycleIndividualCandidacyEvent(this, person);
    }

    public SecondCycleIndividualCandidacyProcess getCandidacyProcess() {
        return (SecondCycleIndividualCandidacyProcess)((Object)super.getCandidacyProcess());
    }

    void editCandidacyInformation(LocalDate candidacyDate, Set<Degree> selectedDegrees, PrecedentDegreeInformationBean precedentDegreeInformation, String professionalStatus, String otherEducation) {
        this.checkParameters(candidacyDate, selectedDegrees, precedentDegreeInformation);
        this.setCandidacyDate(candidacyDate);
        this.putSelectedDegrees(selectedDegrees);
        this.setProfessionalStatus(professionalStatus);
        this.setOtherEducation(otherEducation);
    }

    private void putSelectedDegrees(Set<Degree> selectedDegreeList) {
        SecondCycleIndividualCandidacySeriesGrade newSCICSeriesGrade;
        for (Degree degree : this.getSelectedDegreesSet()) {
            if (selectedDegreeList.contains(degree)) {
                if (this.getSecondCycleIndividualCandidacySeriesGradeForDegree(degree) != null) continue;
                newSCICSeriesGrade = new SecondCycleIndividualCandidacySeriesGrade();
                newSCICSeriesGrade.setDegree(degree);
                this.getIndividualCandidacySeriesGradeSet().add(newSCICSeriesGrade);
                continue;
            }
            SecondCycleIndividualCandidacySeriesGrade seriesGrade = this.getSecondCycleIndividualCandidacySeriesGradeForDegree(degree);
            if (seriesGrade == null) {
                throw new RuntimeException("should.exist.series.grade.to.delete");
            }
            if (!seriesGrade.isClean()) {
                throw new RuntimeException("cannot.delete.series.grade.with.grades");
            }
            seriesGrade.delete();
        }
        while (!this.getSelectedDegreesSet().isEmpty()) {
            this.getSelectedDegreesSet().remove(this.getSelectedDegreesSet().iterator().next());
        }
        this.getSelectedDegreesSet().addAll(selectedDegreeList);
        for (Degree degree : selectedDegreeList) {
            if (this.getSecondCycleIndividualCandidacySeriesGradeForDegree(degree) != null) continue;
            newSCICSeriesGrade = new SecondCycleIndividualCandidacySeriesGrade();
            newSCICSeriesGrade.setDegree(degree);
            this.getIndividualCandidacySeriesGradeSet().add(newSCICSeriesGrade);
        }
        IndividualCandidacyEvent individualCandidacyEvent = this.getEvent();
        if (individualCandidacyEvent != null && individualCandidacyEvent.getAmountToPay().isPositive() && this.getEvent().isClosed()) {
            individualCandidacyEvent.open();
            Set paymentCodes = individualCandidacyEvent.getAllPaymentCodes();
            for (AccountingEventPaymentCode accountingEventPaymentCode : paymentCodes) {
                accountingEventPaymentCode.setState(PaymentCodeState.NEW);
            }
        }
        if (this.getSelectedDegreesSet().isEmpty()) {
            throw new DomainException("this shouldnt happen", new String[0]);
        }
    }

    void editSelectedDegrees(Set<Degree> selectedDegreeList) {
        SecondCycleIndividualCandidacySeriesGrade newSCICSeriesGrade;
        for (Degree degree : this.getSelectedDegreesSet()) {
            if (selectedDegreeList.contains(degree)) {
                if (this.getSecondCycleIndividualCandidacySeriesGradeForDegree(degree) != null) continue;
                newSCICSeriesGrade = new SecondCycleIndividualCandidacySeriesGrade();
                newSCICSeriesGrade.setDegree(degree);
                this.getIndividualCandidacySeriesGradeSet().add(newSCICSeriesGrade);
                continue;
            }
            SecondCycleIndividualCandidacySeriesGrade seriesGrade = this.getSecondCycleIndividualCandidacySeriesGradeForDegree(degree);
            if (seriesGrade == null) {
                throw new RuntimeException("should.exist.series.grade.to.delete");
            }
            if (!seriesGrade.isClean()) {
                throw new RuntimeException("cannot.delete.series.grade.with.grades");
            }
            seriesGrade.delete();
        }
        while (!this.getSelectedDegreesSet().isEmpty()) {
            this.getSelectedDegreesSet().remove(this.getSelectedDegreesSet().iterator().next());
        }
        this.getSelectedDegreesSet().addAll(selectedDegreeList);
        for (Degree degree : selectedDegreeList) {
            if (this.getSecondCycleIndividualCandidacySeriesGradeForDegree(degree) != null) continue;
            newSCICSeriesGrade = new SecondCycleIndividualCandidacySeriesGrade();
            newSCICSeriesGrade.setDegree(degree);
            this.getIndividualCandidacySeriesGradeSet().add(newSCICSeriesGrade);
        }
        IndividualCandidacyEvent individualCandidacyEvent = this.getEvent();
        if (individualCandidacyEvent != null && individualCandidacyEvent.getAmountToPay().isPositive() && this.getEvent().isClosed()) {
            individualCandidacyEvent.open();
            Set paymentCodes = individualCandidacyEvent.getAllPaymentCodes();
            for (AccountingEventPaymentCode accountingEventPaymentCode : paymentCodes) {
                accountingEventPaymentCode.setState(PaymentCodeState.NEW);
            }
        }
        if (this.getSelectedDegreesSet().isEmpty()) {
            throw new DomainException("this shouldnt happen", new String[0]);
        }
    }

    private void checkParameters(LocalDate candidacyDate, Set<Degree> selectedDegrees, PrecedentDegreeInformationBean precedentDegreeInformation) {
        this.checkParameters(this.getPersonalDetails().getPerson(), (IndividualCandidacyProcess)((Object)this.getCandidacyProcess()), candidacyDate);
        if (selectedDegrees == null || selectedDegrees.isEmpty()) {
            throw new DomainException("error.SecondCycleIndividualCandidacy.invalid.degree", new String[0]);
        }
        if (this.isCandidacyInternal().booleanValue() && this.personHasOneOfDegrees(this.getPersonalDetails().getPerson(), selectedDegrees)) {
            throw new DomainException("error.SecondCycleIndividualCandidacy.existing.degree", new String[0]);
        }
        if (precedentDegreeInformation == null) {
            throw new DomainException("error.SecondCycleIndividualCandidacy.invalid.precedentDegreeInformation", new String[0]);
        }
    }

    void editCandidacyResult(SecondCycleIndividualCandidacyResultBean bean) {
        this.setProfessionalExperience(bean.getProfessionalExperience());
        this.setAffinity(bean.getAffinity());
        this.setDegreeNature(bean.getDegreeNature());
        this.setCandidacyGrade(bean.getGrade());
        this.setInterviewGrade(bean.getInterviewGrade());
        this.setSeriesCandidacyGrade(bean.getSeriesGrade());
        this.setNotes(bean.getNotes());
        if (bean.getState() == null) {
            this.setState(IndividualCandidacyState.STAND_BY);
            this.setRegistration(null);
        } else {
            this.setState(bean.getState());
        }
    }

    protected ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    public Registration createRegistration(DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        if (this.getRegistration() != null) {
            throw new DomainException("error.IndividualCandidacy.person.with.registration", degreeCurricularPlan.getPresentationName());
        }
        if (this.hasRegistration(degreeCurricularPlan)) {
            Registration registration = this.getRegistration(degreeCurricularPlan);
            this.setRegistration(registration);
            return registration;
        }
        this.getPersonalDetails().ensurePersonInternalization();
        return this.createRegistration(this.getPersonalDetails().getPerson(), degreeCurricularPlan, cycleType, ingressionType);
    }

    private boolean hasRegistration(DegreeCurricularPlan degreeCurricularPlan) {
        return this.hasStudent() && this.getStudent().hasRegistrationFor(degreeCurricularPlan);
    }

    private Registration getRegistration(DegreeCurricularPlan degreeCurricularPlan) {
        List<Registration> registrations = this.getStudent().getRegistrationsFor(degreeCurricularPlan);
        Collections.sort(registrations, Registration.COMPARATOR_BY_START_DATE);
        Registration result = null;
        for (Registration registration : registrations) {
            if (result != null && !registration.hasAnyActiveState(this.getCandidacyExecutionInterval())) continue;
            result = registration;
        }
        return result;
    }

    protected Registration createRegistration(Person person, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        Registration registration = super.createRegistration(person, degreeCurricularPlan, cycleType, ingressionType);
        registration.setRegistrationYear(this.getCandidacyExecutionInterval());
        return registration;
    }

    void editFormerIstStudentNumber(SecondCycleIndividualCandidacyProcessBean bean) {
        this.setFormerStudentNumber(bean.getIstStudentNumber());
    }

    public void exportValues(StringBuilder result) {
        super.exportValues(result);
        Formatter formatter = new Formatter(result);
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.process.id", (String[])new String[0]), this.getCandidacyProcess().getProcessCode());
        PrecedentDegreeInformation precedentDegreeInformation = this.getCandidacyProcess().getPrecedentDegreeInformation();
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.previous.degree", (String[])new String[0]), precedentDegreeInformation.getDegreeDesignation());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.conclusionDate", (String[])new String[0]), precedentDegreeInformation.getConclusionDate());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.institution", (String[])new String[0]), precedentDegreeInformation.getInstitution().getName());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.conclusionGrade", (String[])new String[0]), precedentDegreeInformation.getConclusionGrade());
        formatter.format("\n", new Object[0]);
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.professionalStatus", (String[])new String[0]), StringUtils.isEmpty((String)this.getProfessionalStatus()) ? "" : this.getProfessionalStatus());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.otherEducation", (String[])new String[0]), StringUtils.isEmpty((String)this.getOtherEducation()) ? "" : this.getOtherEducation());
        formatter.format("%s: %d\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.professionalExperience", (String[])new String[0]), this.getProfessionalExperience() != null ? this.getProfessionalExperience() : 0);
        formatter.format("%s: %f\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.affinity", (String[])new String[0]), this.getAffinity() != null ? this.getAffinity() : BigDecimal.ZERO);
        formatter.format("%s: %d\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.degreeNature", (String[])new String[0]), this.getDegreeNature() != null ? this.getDegreeNature() : 0);
        formatter.format("%s: %f\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.candidacyGrade", (String[])new String[0]), this.getCandidacyGrade() != null ? this.getCandidacyGrade() : BigDecimal.ZERO);
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.interviewGrade", (String[])new String[0]), this.getInterviewGrade());
        formatter.format("%s: %f\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.SecondCycleIndividualCandidacy.seriesCandidacyGrade", (String[])new String[0]), this.getSeriesCandidacyGrade() != null ? this.getSeriesCandidacyGrade() : BigDecimal.ZERO);
        formatter.close();
    }

    public String getDescription() {
        return this.getCandidacyProcess().getDisplayName() + (this.hasSelectedDegree() ? ": " + this.getSelectedDegree().getNameI18N() : "");
    }

    public Collection<Degree> getAllDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        result.addAll(this.getSelectedDegreesSet());
        return result;
    }

    public boolean hasSelectedDegree() {
        throw new DomainException("error.second.cycle.individual.candidacy.relation.with.degree.obsolete", new String[0]);
    }

    public void setSelectedDegree(Degree selectedDegree) {
        throw new DomainException("error.second.cycle.individual.candidacy.relation.with.degree.obsolete", new String[0]);
    }

    public void removeSelectedDegree() {
        throw new DomainException("error.second.cycle.individual.candidacy.relation.with.degree.obsolete", new String[0]);
    }

    public boolean isSecondCycle() {
        return true;
    }

    public boolean isEventClosedButWithDebt() {
        IndividualCandidacyEvent event = this.getEvent();
        return !event.getNonAdjustingTransactions().isEmpty() && event.getAmountToPay().isPositive();
    }

    public SecondCycleIndividualCandidacySeriesGrade getSecondCycleIndividualCandidacySeriesGradeForDegree(Degree degree) {
        for (IndividualCandidacySeriesGrade seriesGrade : this.getIndividualCandidacySeriesGradeSet()) {
            if (seriesGrade.getDegree() != degree) continue;
            return (SecondCycleIndividualCandidacySeriesGrade)((Object)seriesGrade);
        }
        return null;
    }

    public SecondCycleIndividualCandidacySeriesGrade getSecondCycleIndividualCandidacySeriesGrade() {
        if (this.getIndividualCandidacySeriesGradeSet().size() == 0) {
            return null;
        }
        if (this.getIndividualCandidacySeriesGradeSet().size() == 1) {
            return this.getSecondCycleIndividualCandidacySeriesGradeForDegree((Degree)this.getSelectedDegreesSet().iterator().next());
        }
        return this.getSecondCycleIndividualCandidacySeriesGradeForDegree(this.getSelectedDegree());
    }

    public BigDecimal getAffinity() {
        if (this.getSecondCycleIndividualCandidacySeriesGrade() != null) {
            return this.getSecondCycleIndividualCandidacySeriesGrade().getAffinity();
        }
        return null;
    }

    public Integer getProfessionalExperience() {
        if (this.getSecondCycleIndividualCandidacySeriesGrade() != null) {
            return this.getSecondCycleIndividualCandidacySeriesGrade().getProfessionalExperience();
        }
        return null;
    }

    public BigDecimal getCandidacyGrade() {
        if (this.getSecondCycleIndividualCandidacySeriesGrade() != null) {
            return this.getSecondCycleIndividualCandidacySeriesGrade().getCandidacyGrade();
        }
        return null;
    }

    public BigDecimal getSerieseCandidacyGrade() {
        if (this.getSecondCycleIndividualCandidacySeriesGrade() != null) {
            return this.getSecondCycleIndividualCandidacySeriesGrade().getCandidacyGrade();
        }
        return null;
    }

    public String getInterviewGrade() {
        if (this.getSecondCycleIndividualCandidacySeriesGrade() != null) {
            return this.getSecondCycleIndividualCandidacySeriesGrade().getInterviewGrade();
        }
        return null;
    }

    public Integer getDegreeNature() {
        if (this.getSecondCycleIndividualCandidacySeriesGrade() != null) {
            return this.getSecondCycleIndividualCandidacySeriesGrade().getDegreeNature();
        }
        return null;
    }

    public void setProfessionalExperience(Integer value) {
        this.getSecondCycleIndividualCandidacySeriesGrade().setProfessionalExperience(value);
    }

    public void setCandidacyGrade(BigDecimal value) {
        this.getSecondCycleIndividualCandidacySeriesGrade().setCandidacyGrade(value);
    }

    public void setAffinity(BigDecimal value) {
        this.getSecondCycleIndividualCandidacySeriesGrade().setAffinity(value);
    }

    public void setInterviewGrade(String value) {
        this.getSecondCycleIndividualCandidacySeriesGrade().setInterviewGrade(value);
    }

    public void setSeriesCandidacyGrade(BigDecimal value) {
        this.getSecondCycleIndividualCandidacySeriesGrade().setSeriesCandidacyGrade(value);
    }

    public void setDegreeNature(Integer value) {
        this.getSecondCycleIndividualCandidacySeriesGrade().setDegreeNature(value);
    }
}

