/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityQuota$callable$createVacancy;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityQuota_Base;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityStudentData;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MobilityQuota
extends MobilityQuota_Base {
    public static final Advice advice$createVacancy = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public MobilityQuota() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public MobilityQuota(MobilityApplicationPeriod period, Degree degree, MobilityAgreement mobilityAgreement, Integer numberOfOpenings) {
        this();
        this.setApplicationPeriod(period);
        this.setDegree(degree);
        this.setMobilityAgreement(mobilityAgreement);
        this.setNumberOfOpenings(numberOfOpenings);
        this.check();
    }

    public MobilityQuota(MobilityApplicationPeriod period, Degree degree, MobilityProgram mobilityProgram, UniversityUnit unit, Integer numberOfOpenings) {
        this();
        this.setApplicationPeriod(period);
        this.setDegree(degree);
        MobilityAgreement agreement = MobilityAgreement.getOrCreateAgreement(mobilityProgram, unit);
        this.setMobilityAgreement(agreement);
        this.setNumberOfOpenings(numberOfOpenings);
        this.check();
    }

    private void check() {
        if (this.getApplicationPeriod() == null) {
            throw new DomainException("error.erasmus.vacancy.candidacy.period.must.not.be.null", new String[0]);
        }
        if (this.getDegree() == null) {
            throw new DomainException("error.erasmus.vacancy.degree.must.not.be.null", new String[0]);
        }
        if (this.getMobilityAgreement().getUniversityUnit() == null) {
            throw new DomainException("error.erasmus.vacancy.university.unit.must.not.be.null", new String[0]);
        }
        if (this.getNumberOfOpenings() == null) {
            throw new DomainException("error.erasmus.vacancy.number.of.vacancies.must.not.be.null", new String[0]);
        }
    }

    public static MobilityQuota createVacancy(MobilityApplicationPeriod mobilityApplicationPeriod, Degree degree, MobilityProgram mobilityProgram, UniversityUnit universityUnit, Integer n) {
        return (MobilityQuota)((Object)advice$createVacancy.perform((Callable)new MobilityQuota$callable$createVacancy(mobilityApplicationPeriod, degree, mobilityProgram, universityUnit, n)));
    }

    static /* synthetic */ MobilityQuota advised$createVacancy(MobilityApplicationPeriod period, Degree degree, MobilityProgram mobilityProgram, UniversityUnit unit, Integer numberOfOpenings) {
        return new MobilityQuota(period, degree, mobilityProgram, unit, numberOfOpenings);
    }

    public List<MobilityIndividualApplicationProcess> getStudentApplicationProcesses() {
        ArrayList<MobilityIndividualApplicationProcess> processList = new ArrayList<MobilityIndividualApplicationProcess>();
        for (MobilityStudentData data : this.getApplicationsSet()) {
            processList.add(data.getMobilityIndividualApplication().getCandidacyProcess());
        }
        return processList;
    }

    public boolean isQuotaAssociatedWithAnyApplication() {
        return !this.getApplicationsSet().isEmpty();
    }

    public void delete() {
        if (this.isQuotaAssociatedWithAnyApplication()) {
            throw new DomainException("error.mobility.quota.is.associated.with.applications", new String[0]);
        }
        this.setMobilityAgreement(null);
        this.setDegree(null);
        this.setApplicationPeriod(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public boolean isFor(MobilityProgram mobilityProgram) {
        return this.getMobilityAgreement().getMobilityProgram() == mobilityProgram;
    }

    public boolean isAssociatedToApplications() {
        return !this.getStudentApplicationProcesses().isEmpty();
    }
}

