/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.graduatedPerson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPerson;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualCandidacyResultBean;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonProcess;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonSeriesGade;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.bennu.core.domain.User;

public class DegreeCandidacyForGraduatedPersonIndividualProcess
extends DegreeCandidacyForGraduatedPersonIndividualProcess_Base {
    private static List<Activity> activities = new ArrayList<Activity>();

    private DegreeCandidacyForGraduatedPersonIndividualProcess() {
    }

    private DegreeCandidacyForGraduatedPersonIndividualProcess(DegreeCandidacyForGraduatedPersonIndividualProcessBean bean) {
        this();
        this.init(bean);
        this.setSpecificIndividualCandidacyDocumentFiles(bean);
    }

    protected void checkParameters(CandidacyProcess candidacyProcess) {
        if (candidacyProcess == null || candidacyProcess.getCandidacyPeriod() == null) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPersonIndividualProcess.invalid.candidacy.process", new String[0]);
        }
    }

    protected void createIndividualCandidacy(IndividualCandidacyProcessBean bean) {
        new DegreeCandidacyForGraduatedPerson(this, (DegreeCandidacyForGraduatedPersonIndividualProcessBean)bean);
    }

    public DegreeCandidacyForGraduatedPerson getCandidacy() {
        return (DegreeCandidacyForGraduatedPerson)((Object)super.getCandidacy());
    }

    public DegreeCandidacyForGraduatedPersonProcess getCandidacyProcess() {
        return (DegreeCandidacyForGraduatedPersonProcess)((Object)super.getCandidacyProcess());
    }

    public boolean canExecuteActivity(User userView) {
        return DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(this, userView);
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public Degree getCandidacySelectedDegree() {
        return this.getCandidacy().getSelectedDegree();
    }

    public BigDecimal getCandidacyAffinity() {
        return this.getCandidacy().getAffinity();
    }

    public Integer getCandidacyDegreeNature() {
        return this.getCandidacy().getDegreeNature();
    }

    public BigDecimal getCandidacyGrade() {
        return this.getCandidacy().getCandidacyGrade();
    }

    public PrecedentDegreeInformation getPrecedentDegreeInformation() {
        return this.getCandidacy().getRefactoredPrecedentDegreeInformation();
    }

    private void editCandidacyInformation(DegreeCandidacyForGraduatedPersonIndividualProcessBean bean) {
        this.getCandidacy().editCandidacyInformation(bean);
    }

    public boolean hasCandidacyForSelectedDegree(Degree degree) {
        return this.getCandidacySelectedDegree() == degree;
    }

    public ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    private static boolean isAllowedToManageProcess(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
        if (process2 == null || process2.getCandidacy() == null) {
            return false;
        }
        return AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES, (AcademicProgram)((Object)process2.getCandidacy().getSelectedDegree()), userView.getPerson().getUser());
    }

    public Boolean isCandidacyProcessComplete() {
        return null;
    }

    private void setSpecificIndividualCandidacyDocumentFiles(DegreeCandidacyForGraduatedPersonIndividualProcessBean bean) {
    }

    public List<IndividualCandidacyDocumentFileType> getMissingRequiredDocumentFiles() {
        ArrayList<IndividualCandidacyDocumentFileType> missingDocumentFiles = new ArrayList<IndividualCandidacyDocumentFileType>();
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.PHOTO) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.PHOTO);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.CV_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.CV_DOCUMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.DEGREE_CERTIFICATE) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.DEGREE_CERTIFICATE);
        }
        return missingDocumentFiles;
    }

    protected void executeOperationsBeforeDocumentFileBinding(IndividualCandidacyDocumentFile documentFile) {
        IndividualCandidacyDocumentFileType type = documentFile.getCandidacyFileType();
        IndividualCandidacyDocumentFile file = this.getActiveFileForType(type);
        if (file == null) {
            return;
        }
        if (IndividualCandidacyDocumentFileType.REPORT_OR_WORK_DOCUMENT.equals((Object)type)) {
            return;
        }
        file.setCandidacyFileActive(false);
    }

    static {
        activities.add(new CandidacyPayment());
        activities.add(new EditCandidacyPersonalInformation());
        activities.add(new EditCandidacyInformation());
        activities.add(new IntroduceCandidacyResult());
        activities.add(new ChangeIndividualCandidacyState());
        activities.add(new CancelCandidacy());
        activities.add(new CreateRegistration());
        activities.add(new EditPublicCandidacyPersonalInformation());
        activities.add(new EditPublicCandidacyDocumentFile());
        activities.add(new EditPublicCandidacyHabilitations());
        activities.add(new EditDocuments());
        activities.add(new ChangeProcessCheckedState());
        activities.add(new SendEmailForApplicationSubmission());
        activities.add(new RevokeDocumentFile());
        activities.add(new ChangePaymentCheckedState());
        activities.add(new RejectCandidacy());
        activities.add(new RevertApplicationToStandBy());
    }

    private static class RevertApplicationToStandBy
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private RevertApplicationToStandBy() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyCancelled() && !process2.isCandidacyRejected()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            process2.getCandidacy().setState(IndividualCandidacyState.STAND_BY);
            return process2;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }
    }

    private static class RejectCandidacy
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private RejectCandidacy() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            process2.rejectCandidacy(userView.getPerson());
            return process2;
        }
    }

    protected static class RevokeDocumentFile
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        protected RevokeDocumentFile() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            ((CandidacyProcessDocumentUploadBean)object).getDocumentFile().setCandidacyFileActive(Boolean.FALSE);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class SendEmailForApplicationSubmission
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private SendEmailForApplicationSubmission() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            DegreeOfficePublicCandidacyHashCode hashCode = (DegreeOfficePublicCandidacyHashCode)((Object)object);
            hashCode.sendEmailForApplicationSuccessfullySubmited();
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class ChangePaymentCheckedState
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private ChangePaymentCheckedState() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            process2.setPaymentChecked(((IndividualCandidacyProcessBean)object).getPaymentChecked());
            return process2;
        }
    }

    private static class ChangeProcessCheckedState
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private ChangeProcessCheckedState() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            process2.setProcessChecked(((IndividualCandidacyProcessBean)object).getProcessChecked());
            return process2;
        }
    }

    private static class EditDocuments
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private EditDocuments() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }
    }

    private static class EditPublicCandidacyHabilitations
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private EditPublicCandidacyHabilitations() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            DegreeCandidacyForGraduatedPersonIndividualProcessBean bean = (DegreeCandidacyForGraduatedPersonIndividualProcessBean)object;
            process2.editCandidacyHabilitations(bean);
            process2.getCandidacy().editSelectedDegree(bean.getSelectedDegree());
            process2.getCandidacy().editObservations(bean);
            process2.editPrecedentDegreeInformation(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyDocumentFile
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private EditPublicCandidacyDocumentFile() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyPersonalInformation
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private EditPublicCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            process2.editPersonalCandidacyInformation(((DegreeCandidacyForGraduatedPersonIndividualProcessBean)object).getPersonBean());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class CreateRegistration
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private CreateRegistration() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyAccepted()) {
                throw new PreConditionNotValidException();
            }
            if (process2.hasRegistrationForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            process2.getCandidacy().createRegistration(this.getDegreeCurricularPlan(process2), CycleType.FIRST_CYCLE, IngressionType.findByPredicate(IngressionType::isMiddleAndSuperiorCourses).orElse(null));
            return process2;
        }

        private DegreeCurricularPlan getDegreeCurricularPlan(DegreeCandidacyForGraduatedPersonIndividualProcess candidacyProcess) {
            return candidacyProcess.getCandidacySelectedDegree().getLastActiveDegreeCurricularPlan();
        }
    }

    private static class CancelCandidacy
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private CancelCandidacy() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || process2.hasAnyPaymentForCandidacy() || !process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            process2.cancelCandidacy(userView.getPerson());
            return process2;
        }
    }

    private static class ChangeIndividualCandidacyState
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private ChangeIndividualCandidacyState() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyDebtPayed()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isSentToCoordinator() && !process2.isSentToScientificCouncil()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            DegreeCandidacyForGraduatedPersonIndividualCandidacyResultBean bean = (DegreeCandidacyForGraduatedPersonIndividualCandidacyResultBean)object;
            process2.getCandidacy().setState(bean.getState());
            return process2;
        }
    }

    private static class IntroduceCandidacyResult
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private IntroduceCandidacyResult() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || !process2.isCandidacyDebtPayed()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isSentToCoordinator()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            DegreeCandidacyForGraduatedPersonIndividualCandidacyResultBean bean = (DegreeCandidacyForGraduatedPersonIndividualCandidacyResultBean)object;
            DegreeCandidacyForGraduatedPersonSeriesGade degreeCandidacyForGraduatedPersonSeriesGade = process2.getCandidacy().getDegreeCandidacyForGraduatedPersonSeriesGadeForDegree(bean.getDegree());
            degreeCandidacyForGraduatedPersonSeriesGade.setAffinity(bean.getAffinity());
            degreeCandidacyForGraduatedPersonSeriesGade.setDegreeNature(bean.getDegreeNature());
            degreeCandidacyForGraduatedPersonSeriesGade.setCandidacyGrade(bean.getGrade());
            degreeCandidacyForGraduatedPersonSeriesGade.setState(bean.getSeriesGradeState());
            return process2;
        }
    }

    private static class EditCandidacyInformation
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private EditCandidacyInformation() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            DegreeCandidacyForGraduatedPersonIndividualProcessBean bean = (DegreeCandidacyForGraduatedPersonIndividualProcessBean)object;
            process2.editCandidacyHabilitations(bean);
            process2.getCandidacy().editObservations(bean);
            process2.editCandidacyInformation(bean);
            process2.getCandidacy().setUtlStudent(bean.getUtlStudent());
            return process2;
        }
    }

    private static class EditCandidacyPersonalInformation
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private EditCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            process2.editPersonalCandidacyInformation(((DegreeCandidacyForGraduatedPersonIndividualProcessBean)object).getPersonBean());
            return process2;
        }
    }

    private static class CandidacyPayment
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        private CandidacyPayment() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonIndividualProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView, Object object) {
            return process2;
        }
    }

    @StartActivity
    public static class IndividualCandidacyInformation
    extends Activity<DegreeCandidacyForGraduatedPersonIndividualProcess> {
        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonIndividualProcess process2, User userView) {
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonIndividualProcess executeActivity(DegreeCandidacyForGraduatedPersonIndividualProcess dummy, User userView, Object object) {
            return new DegreeCandidacyForGraduatedPersonIndividualProcess((DegreeCandidacyForGraduatedPersonIndividualProcessBean)object);
        }
    }
}

