/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.Account_Base;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class Account
extends Account_Base {
    private Account() {
        super.setCreationDate(new DateTime());
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Account(AccountType accountType, Party party) {
        this();
        this.init(accountType, party);
    }

    private void init(AccountType accountType, Party party) {
        this.checkParameters(accountType, party);
        super.setAccountType(accountType);
        super.setParty(party);
    }

    private void checkParameters(AccountType accountType, Party party) {
        if (accountType == null) {
            throw new DomainException("error.accounting.account.invalid.accountType", new String[0]);
        }
        if (party == null) {
            throw new DomainException("error.accounting.account.invalid.party", new String[0]);
        }
    }

    public void addEntries(Entry entries) {
        throw new DomainException("error.accounting.account.cannot.add.entries", new String[0]);
    }

    public Set<Entry> getEntriesSet() {
        return Collections.unmodifiableSet(super.getEntriesSet());
    }

    public void removeEntries(Entry entries) {
        throw new DomainException("error.accounting.account.cannot.remove.entries", new String[0]);
    }

    public void setAccountType(AccountType accountType) {
        throw new DomainException("error.accounting.account.cannot.modify.accountType", new String[0]);
    }

    public void setParty(Party party) {
        throw new DomainException("error.accounting.account.cannot.modify.party", new String[0]);
    }

    public void setCreationDate(DateTime creationDate) {
        throw new DomainException("error.accounting.account.cannot.modify.creationDate", new String[0]);
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        super.setParty(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getEntriesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.accounting.account.cannot.be.deleted", (String[])new String[0]));
        }
    }

    public void transferEntry(Entry entry) {
        super.addEntries(entry);
    }

    public boolean isInternal() {
        return this.getAccountType() == AccountType.INTERNAL;
    }

    public boolean isExternal() {
        return this.getAccountType() == AccountType.EXTERNAL;
    }
}

