/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager.exams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.ui.struts.action.base.FenixContextDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.bennu.core.util.VariantBean;
import org.fenixedu.bennu.portal.servlet.PortalLayoutInjector;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=RAMApplication.RAMEvaluationsApp.class, path="search-by-degree-and-year", titleKey="link.exams.searchWrittenEvaluationsByDegreeAndYear")
@Mapping(module="resourceAllocationManager", path="/searchWrittenEvaluationsByDegreeAndYear", formBean="searchWrittenEvaluationsByDegreeAndYearForm")
@Forwards(value={@Forward(name="showForm", path="/resourceAllocationManager/writtenEvaluations/selectDegreeAndYear.jsp"), @Forward(name="showMap", path="/resourceAllocationManager/writtenEvaluations/degreeYearWrittenEvaluationsMap.jsp")})
public class WrittenEvaluationsSearchByDegreeAndYear
extends FenixContextDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VariantBean bean = (VariantBean)this.getRenderedObject();
        if (bean == null) {
            bean = new VariantBean();
            bean.setObject((Object)AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER));
        }
        RenderUtils.invalidateViewState();
        AcademicInterval academicInterval = (AcademicInterval)bean.getObject();
        request.setAttribute("bean", (Object)bean);
        ArrayList<LabelValueBean> executionDegreeLabelValueBeans = new ArrayList<LabelValueBean>();
        for (ExecutionDegree executionDegree : ExecutionDegree.filterByAcademicInterval(academicInterval)) {
            String part = this.addAnotherInfoToLabel(executionDegree, academicInterval) ? " - " + executionDegree.getDegreeCurricularPlan().getName() : "";
            executionDegreeLabelValueBeans.add(new LabelValueBean(executionDegree.getDegree().getPresentationName() + part, executionDegree.getExternalId().toString()));
        }
        Collections.sort(executionDegreeLabelValueBeans, Comparator.comparing(LabelValueBean::getLabel));
        request.setAttribute("executionDegreeLabelValueBeans", executionDegreeLabelValueBeans);
        return mapping.findForward("showForm");
    }

    private boolean addAnotherInfoToLabel(ExecutionDegree executionDegreeToTest, AcademicInterval academicInterval) {
        Degree degreeToTest = executionDegreeToTest.getDegree();
        for (ExecutionDegree executionDegree : ExecutionDegree.filterByAcademicInterval(academicInterval)) {
            if (!degreeToTest.equals(executionDegree.getDegree()) || executionDegreeToTest.equals(executionDegree)) continue;
            return true;
        }
        return false;
    }

    public ActionForward choose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PortalLayoutInjector.skipLayoutOn((HttpServletRequest)request);
        this.prepareInformationToList(form, request);
        return mapping.findForward("showMap");
    }

    private void prepareInformationToList(ActionForm form, HttpServletRequest request) {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        VariantBean bean = (VariantBean)this.getRenderedObject();
        AcademicInterval academicInterval = (AcademicInterval)bean.getObject();
        request.setAttribute("academicInterval", (Object)academicInterval);
        Boolean selectAllCurricularYears = (Boolean)dynaActionForm.get("selectAllCurricularYears");
        String[] selectedCurricularYears = (String[])dynaActionForm.get("selectedCurricularYears");
        String executionDegreeID = (String)dynaActionForm.get("executionDegreeID");
        HashSet<Integer> years = new HashSet<Integer>();
        for (String yearString : selectedCurricularYears) {
            years.add(Integer.valueOf(yearString));
        }
        TreeMap executionCoursesByCurricularYearByExecutionDegree = new TreeMap(new Comparator<ExecutionDegree>(){

            @Override
            public int compare(ExecutionDegree executionDegree1, ExecutionDegree executionDegree2) {
                Degree degree1 = executionDegree1.getDegreeCurricularPlan().getDegree();
                Degree degree2 = executionDegree2.getDegreeCurricularPlan().getDegree();
                return degree1.getDegreeType() == degree2.getDegreeType() ? degree1.getNome().compareTo(degree2.getNome()) : degree1.getDegreeType().compareTo(degree2.getDegreeType());
            }
        });
        for (ExecutionDegree executionDegree : ExecutionDegree.filterByAcademicInterval(academicInterval)) {
            if (executionDegreeID != null && executionDegreeID.length() != 0 && !executionDegreeID.equals(executionDegree.getExternalId().toString())) continue;
            TreeMap<Integer, TreeSet<ExecutionCourse>> executionCoursesByCurricularYear = new TreeMap<Integer, TreeSet<ExecutionCourse>>(new Comparator<Integer>(){

                @Override
                public int compare(Integer curricularYear1, Integer curricularYear2) {
                    return curricularYear1.compareTo(curricularYear2);
                }
            });
            executionCoursesByCurricularYearByExecutionDegree.put(executionDegree, executionCoursesByCurricularYear);
            for (CurricularCourse curricularCourse : executionDegree.getDegreeCurricularPlan().getCurricularCoursesSet()) {
                for (DegreeModuleScope degreeModuleScope : curricularCourse.getDegreeModuleScopes()) {
                    TreeSet<ExecutionCourse> executionCourses;
                    if (!degreeModuleScope.isActiveForAcademicInterval(academicInterval)) continue;
                    Integer curricularSemester = degreeModuleScope.getCurricularSemester();
                    Integer curricularYear = degreeModuleScope.getCurricularYear();
                    if ((curricularSemester != AcademicInterval.getCardinalityOfAcademicInterval(academicInterval) || selectAllCurricularYears == null || !selectAllCurricularYears.booleanValue()) && !years.contains(curricularYear)) continue;
                    if (!executionCoursesByCurricularYear.containsKey(curricularYear)) {
                        executionCourses = new TreeSet<ExecutionCourse>(new Comparator<ExecutionCourse>(){

                            @Override
                            public int compare(ExecutionCourse executionCourse1, ExecutionCourse executionCourse2) {
                                return executionCourse1.getNome().compareTo(executionCourse2.getNome());
                            }
                        });
                        executionCoursesByCurricularYear.put(curricularYear, executionCourses);
                    } else {
                        executionCourses = (TreeSet<ExecutionCourse>)executionCoursesByCurricularYear.get(curricularYear);
                    }
                    for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                        if (!academicInterval.equals(executionCourse.getAcademicInterval())) continue;
                        executionCourses.add(executionCourse);
                    }
                }
            }
        }
        request.setAttribute("executionCoursesByCurricularYearByExecutionDegree", executionCoursesByCurricularYearByExecutionDegree);
        request.setAttribute("semester", (Object)AcademicInterval.getCardinalityOfAcademicInterval(academicInterval));
    }
}

