/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.InfoClass;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.resourceAllocationManager.CourseLoadBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.resourceAllocationManager.DeleteCourseLoad;
import org.fenixedu.academic.service.services.resourceAllocationManager.EditExecutionCourse;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadClassesByExecutionCourse;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ManageExecutionCoursesDA;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.base.FenixExecutionCourseAndExecutionDegreeAndCurricularYearContextDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/manageExecutionCourse", module="resourceAllocationManager", functionality=ManageExecutionCoursesDA.class)
@Forwards(value={@Forward(name="ManageExecutionCourse", path="/resourceAllocationManager/manageExecutionCourse_bd.jsp")})
public class ManageExecutionCourseDA
extends FenixExecutionCourseAndExecutionDegreeAndCurricularYearContextDispatchAction {
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InfoExecutionCourse infoExecutionCourse = (InfoExecutionCourse)request.getAttribute("execution_course");
        ExecutionCourse executionCourse = infoExecutionCourse.getExecutionCourse();
        this.readAndSetExecutionCourseClasses(request, executionCourse);
        request.setAttribute("courseLoadBean", (Object)new CourseLoadBean(executionCourse));
        return mapping.findForward("ManageExecutionCourse");
    }

    public ActionForward preparePostBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CourseLoadBean bean = (CourseLoadBean)this.getRenderedObject("courseLoadBeanID");
        ShiftType type = bean.getType();
        if (type != null) {
            CourseLoad courseLoad = bean.getExecutionCourse().getCourseLoadByShiftType(type);
            if (courseLoad != null) {
                bean.setUnitQuantity(courseLoad.getUnitQuantity());
                bean.setTotalQuantity(courseLoad.getTotalQuantity());
            } else {
                bean.setUnitQuantity(null);
                bean.setTotalQuantity(null);
            }
        }
        this.readAndSetExecutionCourseClasses(request, bean.getExecutionCourse());
        RenderUtils.invalidateViewState((String)"courseLoadBeanID");
        request.setAttribute("courseLoadBean", (Object)bean);
        return mapping.findForward("ManageExecutionCourse");
    }

    public ActionForward showCourseLoad(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CourseLoadBean bean = (CourseLoadBean)this.getRenderedObject("courseLoadBeanID");
        this.readAndSetExecutionCourseClasses(request, bean.getExecutionCourse());
        request.setAttribute("courseLoadBean", (Object)bean);
        return mapping.findForward("ManageExecutionCourse");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CourseLoadBean bean = (CourseLoadBean)this.getRenderedObject("courseLoadBeanID");
        try {
            EditExecutionCourse.run(bean);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            this.readAndSetExecutionCourseClasses(request, bean.getExecutionCourse());
            request.setAttribute("courseLoadBean", (Object)bean);
            return mapping.findForward("ManageExecutionCourse");
        }
        bean.setType(null);
        bean.setUnitQuantity(null);
        bean.setTotalQuantity(null);
        this.readAndSetExecutionCourseClasses(request, bean.getExecutionCourse());
        request.setAttribute("courseLoadBean", (Object)bean);
        return mapping.findForward("ManageExecutionCourse");
    }

    public ActionForward deleteCourseLoad(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CourseLoad courseLoad = this.getCourseLoadFromParameter(request);
        ExecutionCourse executionCourse = courseLoad.getExecutionCourse();
        try {
            DeleteCourseLoad.run(courseLoad);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
        }
        this.readAndSetExecutionCourseClasses(request, executionCourse);
        request.setAttribute("courseLoadBean", (Object)new CourseLoadBean(executionCourse));
        return mapping.findForward("ManageExecutionCourse");
    }

    private void readAndSetExecutionCourseClasses(HttpServletRequest request, ExecutionCourse executionCourse) throws FenixServiceException {
        List<InfoClass> infoClasses = ReadClassesByExecutionCourse.runReadClassesByExecutionCourse(executionCourse);
        if (infoClasses != null && !infoClasses.isEmpty()) {
            Collections.sort(infoClasses, new BeanComparator("nome"));
            request.setAttribute("infoClasses", infoClasses);
        }
    }

    private CourseLoad getCourseLoadFromParameter(HttpServletRequest request) {
        String idString = request.getParameterMap().containsKey("courseLoadID") ? request.getParameter("courseLoadID") : null;
        return (CourseLoad)FenixFramework.getDomainObject((String)idString);
    }
}

