/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.person;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.person.VisualizePersonalInfo;
import org.fenixedu.academic.util.ContentType;
import org.fenixedu.bennu.core.domain.Avatar;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="person", path="/retrievePersonalPhoto", scope="session", parameter="method", functionality=VisualizePersonalInfo.class)
public class RetrievePersonalPhotoAction
extends FenixDispatchAction {
    private static final Logger logger = LoggerFactory.getLogger(RetrievePersonalPhotoAction.class);

    public ActionForward retrieveOwnPhoto(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        User userView = Authenticate.getUser();
        Photograph personalPhoto = userView.getPerson().getPersonalPhotoEvenIfPending();
        if (personalPhoto != null) {
            RetrievePersonalPhotoAction.writePhoto(response, personalPhoto);
            return null;
        }
        this.writeUnavailablePhoto(response);
        return null;
    }

    public ActionForward retrievePendingByID(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        String photoID = request.getParameter("photoCode");
        Photograph photo = (Photograph)FenixFramework.getDomainObject((String)photoID);
        if (photo != null) {
            RetrievePersonalPhotoAction.writePhoto(response, photo);
            return null;
        }
        this.writeUnavailablePhoto(response);
        return null;
    }

    public static void writePhoto(HttpServletResponse response, Photograph personalPhoto) {
        try {
            response.setContentType(ContentType.PNG.getMimeType());
            DataOutputStream dos = new DataOutputStream((OutputStream)response.getOutputStream());
            byte[] avatar = personalPhoto.getDefaultAvatar();
            dos.write(avatar);
            dos.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void writeUnavailablePhoto(HttpServletResponse response) {
        RetrievePersonalPhotoAction.writeUnavailablePhoto(response, this.getServlet());
    }

    public static void writeUnavailablePhoto(HttpServletResponse response, ActionServlet actionServlet) {
        response.setContentType("image/png");
        try (InputStream mm = RetrievePersonalPhotoAction.class.getClassLoader().getResourceAsStream("META-INF/resources/img/mysteryman.png");){
            response.getOutputStream().write(Avatar.process((InputStream)mm, (String)"image/png", (int)100));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

