/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import com.google.common.base.Strings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.struts.action.base.FenixAction;
import org.fenixedu.academic.ui.struts.action.coordinator.CoordinatorApplication;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=CoordinatorApplication.CoordinatorManagementApp.class, path="degree", titleKey="coordinator")
@Mapping(path="/coordinatorIndex", module="coordinator")
@Forwards(value={@Forward(name="Success", path="/coordinator/welcomeScreen.jsp")})
public class DegreeCoordinatorIndex
extends FenixAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return mapping.findForward("Success");
    }

    public static void setCoordinatorContext(HttpServletRequest request) {
        String degreeCurricularPlanOID = DegreeCoordinatorIndex.findDegreeCurricularPlanID(request);
        request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanOID);
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanOID);
        if (degreeCurricularPlan != null) {
            request.setAttribute("master_degree", (Object)degreeCurricularPlan.getMostRecentExecutionDegree());
            request.setAttribute("isCoordinator", (Object)degreeCurricularPlan.getDegree().isCoordinatorInSomeExecutionYear(AccessControl.getPerson()));
            request.setAttribute("isScientificCommissionMember", (Object)degreeCurricularPlan.getDegree().isMemberOfAnyScientificCommission(AccessControl.getPerson()));
        }
    }

    public static String findDegreeCurricularPlanID(HttpServletRequest request) {
        String paramValue = request.getParameter("degreeCurricularPlanID");
        if (!Strings.isNullOrEmpty((String)paramValue)) {
            return paramValue;
        }
        String attribute = (String)request.getAttribute("degreeCurricularPlanID");
        if (!Strings.isNullOrEmpty((String)attribute)) {
            return attribute;
        }
        return null;
    }
}

